/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.mathworks.matlabserver.internalservices.annotations.ExcludeField;
import com.mathworks.matlabserver.internalservices.annotations.ExposeClass;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.logging.Logger;

public class CustomExclusionStrategy
implements ExclusionStrategy {
    private static final Logger logger = Logger.getLogger(CustomExclusionStrategy.class.getName());
    private static final String MATHWORKS_CLASS = "com.mathworks";

    @Override
    public boolean shouldSkipField(FieldAttributes fieldAttributes) {
        boolean retval = false;
        Collection<Annotation> annotations = fieldAttributes.getAnnotations();
        for (Annotation a2 : annotations) {
            if (!(a2 instanceof ExcludeField)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    @Override
    public boolean shouldSkipClass(Class<?> aClass) {
        boolean retval = false;
        Class<?> componentType = aClass.getComponentType();
        if (componentType != null) {
            aClass = componentType;
        }
        String canonicalName = aClass.getCanonicalName();
        if (!aClass.isInterface() && canonicalName.startsWith(MATHWORKS_CLASS)) {
            Annotation[] annotations;
            retval = true;
            for (Annotation annotation : annotations = aClass.getAnnotations()) {
                if (!(annotation instanceof ExposeClass)) continue;
                retval = false;
                break;
            }
        }
        return retval;
    }
}

