/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.mathworks.matlabserver.internalservices.client.ClientTypeRequestMessageDO;
import com.mathworks.matlabserver.internalservices.client.ClientTypeResponseMessageDO;
import com.mathworks.matlabserver.internalservices.common.MessageContainerDO;
import com.mathworks.matlabserver.internalservices.entitledproducts.AuthorizationDetailsResponseMessageDO;
import com.mathworks.matlabserver.internalservices.eval.FEvalOpaqueRequestMessageDO;
import com.mathworks.matlabserver.internalservices.eval.FEvalOpaqueResponseMessageDO;
import com.mathworks.matlabserver.internalservices.faults.MessageFaultDO;
import com.mathworks.matlabserver.internalservices.feedback.FeedbackRequestMessageDO;
import com.mathworks.matlabserver.internalservices.figure.FigureSaveRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.DeleteFileRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.DisplayVersionRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.FileDO;
import com.mathworks.matlabserver.internalservices.file.ListFileRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.ListFileResponseMessageDO;
import com.mathworks.matlabserver.internalservices.file.ListVersionRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.MoveMultipleFilesRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.MoveMultipleFilesResponseMessageDO;
import com.mathworks.matlabserver.internalservices.file.OpenFileRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.OpenFileResponseMessageDO;
import com.mathworks.matlabserver.internalservices.file.OpenOrCreateFileRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.RenameFileRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.SetActiveVersionRequestMessageDO;
import com.mathworks.matlabserver.internalservices.filesharing.GetShareInfoRequestMessageDO;
import com.mathworks.matlabserver.internalservices.message.MLSMessage;
import com.mathworks.matlabserver.internalservices.opaqueMessageService.OpaqueMessageDO;
import com.mathworks.matlabserver.internalservices.security.CreateProfileRequestMessageDO;
import com.mathworks.matlabserver.internalservices.serviceendpoints.ServiceRegistryRequestMessageDO;
import com.mathworks.matlabserver.internalservices.serviceendpoints.ServiceRegistryResponseMessageDO;
import com.mathworks.matlabserver.internalservices.session.DeleteSessionRequestMessageDO;
import com.mathworks.matlabserver.internalservices.session.LoadSessionRequestMessageDO;
import com.mathworks.matlabserver.internalservices.session.LoadSessionResponseMessageDO;
import com.mathworks.matlabserver.internalservices.session.NewSessionRequestMessageDO;
import com.mathworks.matlabserver.internalservices.session.NewSessionResponseMessageDO;
import com.mathworks.matlabserver.internalservices.session.SaveSessionRequestMessageDO;
import com.mathworks.matlabserver.internalservices.syntaxhighlighting.SyntaxHighlightingColorMapResponseMessageDO;
import com.mathworks.matlabserver.internalservices.variableeditor.VariableContentDO;
import com.mathworks.matlabserver.jsonconverter.ClassLookupService;
import com.mathworks.matlabserver.jsonconverter.JsonConverterService;
import com.mathworks.matlabserver.jsonconverter.JsonRequestPayload;
import com.mathworks.matlabserver.jsonconverter.JsonResponsePayload;
import com.mathworks.matlabserver.jsonconverter.impl.Client.ClientConverter;
import com.mathworks.matlabserver.jsonconverter.impl.Client.ClientResponseConverter;
import com.mathworks.matlabserver.jsonconverter.impl.ConvertUtils;
import com.mathworks.matlabserver.jsonconverter.impl.CustomExclusionStrategy;
import com.mathworks.matlabserver.jsonconverter.impl.common.ObjectConverter;
import com.mathworks.matlabserver.jsonconverter.impl.entitledproducts.AuthorizationDetailsConverter;
import com.mathworks.matlabserver.jsonconverter.impl.eval.FEvalRequestConverter;
import com.mathworks.matlabserver.jsonconverter.impl.eval.FEvalResponseConverter;
import com.mathworks.matlabserver.jsonconverter.impl.fault.MessageFaultConverter;
import com.mathworks.matlabserver.jsonconverter.impl.feedback.FeedbackConverter;
import com.mathworks.matlabserver.jsonconverter.impl.figure.FigureSaveConverter;
import com.mathworks.matlabserver.jsonconverter.impl.file.CommonFileMessageConverter;
import com.mathworks.matlabserver.jsonconverter.impl.file.DeleteFileRequestConverter;
import com.mathworks.matlabserver.jsonconverter.impl.file.FileConverter;
import com.mathworks.matlabserver.jsonconverter.impl.file.ListFileRequestConverter;
import com.mathworks.matlabserver.jsonconverter.impl.file.ListFileResponseConverter;
import com.mathworks.matlabserver.jsonconverter.impl.file.MoveMultipleFilesRequestConverter;
import com.mathworks.matlabserver.jsonconverter.impl.file.MoveMultipleFilesResponseConverter;
import com.mathworks.matlabserver.jsonconverter.impl.file.OpenFileRequestConverter;
import com.mathworks.matlabserver.jsonconverter.impl.file.OpenFileResponseConverter;
import com.mathworks.matlabserver.jsonconverter.impl.file.OpenOrCreateFileRequestConverter;
import com.mathworks.matlabserver.jsonconverter.impl.file.RenameFileRequestConverter;
import com.mathworks.matlabserver.jsonconverter.impl.message.MapConverter;
import com.mathworks.matlabserver.jsonconverter.impl.message.MessageContainerConverter;
import com.mathworks.matlabserver.jsonconverter.impl.opaqueMessageService.OpaqueMessageConverter;
import com.mathworks.matlabserver.jsonconverter.impl.security.SecurityConverter;
import com.mathworks.matlabserver.jsonconverter.impl.serviceregistry.ServiceRegistryConverter;
import com.mathworks.matlabserver.jsonconverter.impl.session.SessionMessagesConverter;
import com.mathworks.matlabserver.jsonconverter.impl.syntaxhighlighting.SyntaxHighlightingColorMapConverter;
import com.mathworks.matlabserver.jsonconverter.impl.variableeditor.VariableContentConverter;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.logging.Logger;

public class JsonConverterServiceImpl
implements JsonConverterService {
    private static final Logger logger = Logger.getLogger(JsonConverterServiceImpl.class.getName());
    private final ClassLookupService classLookupService;
    private final Gson gson;

    public JsonConverterServiceImpl(ClassLookupService classLookupService) {
        this.classLookupService = classLookupService;
        GsonBuilder gsonBuilder = new GsonBuilder();
        this.registerCustomConverters(gsonBuilder);
        gsonBuilder = gsonBuilder.setPrettyPrinting().serializeNulls();
        gsonBuilder = gsonBuilder.serializeSpecialFloatingPointValues();
        this.gson = gsonBuilder.create();
    }

    @Override
    public JsonResponsePayload convertJsonResponseToPayload(String json) {
        JsonResponsePayload payload = null;
        try {
            payload = this.gson.fromJson(json, JsonResponsePayload.class);
        }
        catch (JsonParseException e2) {
            logger.warning("Error parsing " + json + ", " + e2.getMessage());
        }
        return payload;
    }

    @Override
    public JsonRequestPayload convertJsonRequestToPayload(String json) {
        JsonRequestPayload payload = null;
        try {
            payload = this.gson.fromJson(json, JsonRequestPayload.class);
        }
        catch (JsonParseException e2) {
            logger.warning("Error parsing " + json + ", " + e2.getMessage());
        }
        return payload;
    }

    @Override
    public String convertRequestPayloadToJson(JsonRequestPayload payload) {
        return this.gson.toJson((Object)payload, (Type)((Object)JsonRequestPayload.class));
    }

    @Override
    public String convertResponsePayloadToJson(JsonResponsePayload payload) {
        return this.gson.toJson((Object)payload, (Type)((Object)JsonResponsePayload.class));
    }

    @Override
    public String convertMessageToJson(MessageContainerDO messageContainer) {
        Map<String, MLSMessage[]> map = ConvertUtils.convertToMap(this.classLookupService, messageContainer);
        return this.gson.toJson(map);
    }

    public <T> T convertFromJson(String str, Class<T> theClass) {
        return this.gson.fromJson(str, theClass);
    }

    public String convertToJson(Object obj, Type type) {
        return this.gson.toJson(obj, type);
    }

    @Override
    public String convertToJson(Object obj) {
        return this.gson.toJson(obj);
    }

    @Override
    public MessageContainerDO convertFromJson(String json) {
        MessageContainerDO messageContainer = null;
        try {
            Map map = this.gson.fromJson(json, Map.class);
            messageContainer = ConvertUtils.convertToMessageContainer(map);
        }
        catch (JsonParseException e2) {
            logger.warning("Error parsing " + json + ", " + e2.getMessage());
        }
        return messageContainer;
    }

    private void registerCustomConverters(GsonBuilder gsonBuilder) {
        Type Map_String_MLSMessage = new TypeToken<Map<String, MLSMessage>>(){}.getType();
        MapConverter mapConverter = new MapConverter(this.classLookupService);
        gsonBuilder.registerTypeAdapter(Map_String_MLSMessage, mapConverter);
        ObjectConverter objectConverter = new ObjectConverter();
        gsonBuilder.registerTypeAdapter((Type)((Object)Object.class), objectConverter);
        MessageContainerConverter containerConverter = new MessageContainerConverter(this.classLookupService);
        gsonBuilder.registerTypeAdapter((Type)((Object)MessageContainerDO.class), containerConverter);
        gsonBuilder.registerTypeAdapter((Type)((Object)SyntaxHighlightingColorMapResponseMessageDO.class), new SyntaxHighlightingColorMapConverter());
        gsonBuilder.registerTypeAdapter((Type)((Object)FileDO.class), new FileConverter());
        CommonFileMessageConverter commonFileConverter = new CommonFileMessageConverter();
        gsonBuilder.registerTypeAdapter((Type)((Object)ListVersionRequestMessageDO.class), commonFileConverter);
        gsonBuilder.registerTypeAdapter((Type)((Object)DisplayVersionRequestMessageDO.class), commonFileConverter);
        gsonBuilder.registerTypeAdapter((Type)((Object)SetActiveVersionRequestMessageDO.class), commonFileConverter);
        gsonBuilder.registerTypeAdapter((Type)((Object)VariableContentDO.class), new VariableContentConverter());
        gsonBuilder.registerTypeAdapter((Type)((Object)GetShareInfoRequestMessageDO.class), commonFileConverter);
        gsonBuilder.registerTypeAdapter((Type)((Object)ListFileRequestMessageDO.class), new ListFileRequestConverter());
        gsonBuilder.registerTypeAdapter((Type)((Object)ListFileResponseMessageDO.class), new ListFileResponseConverter());
        MoveMultipleFilesRequestConverter moveFileRequestConverter = new MoveMultipleFilesRequestConverter();
        gsonBuilder.registerTypeAdapter((Type)((Object)MoveMultipleFilesRequestMessageDO.class), moveFileRequestConverter);
        MoveMultipleFilesResponseConverter moveFileResponseConverter = new MoveMultipleFilesResponseConverter();
        gsonBuilder.registerTypeAdapter((Type)((Object)MoveMultipleFilesResponseMessageDO.class), moveFileResponseConverter);
        FigureSaveConverter figureSaveConverter = new FigureSaveConverter();
        gsonBuilder.registerTypeAdapter((Type)((Object)FigureSaveRequestMessageDO.class), figureSaveConverter);
        ClientConverter clientConverter = new ClientConverter();
        gsonBuilder.registerTypeAdapter((Type)((Object)ClientTypeRequestMessageDO.class), clientConverter);
        ClientResponseConverter clientResponseConverter = new ClientResponseConverter();
        gsonBuilder.registerTypeAdapter((Type)((Object)ClientTypeResponseMessageDO.class), clientResponseConverter);
        ServiceRegistryConverter serviceRegistryConverter = new ServiceRegistryConverter();
        gsonBuilder.registerTypeAdapter((Type)((Object)ServiceRegistryRequestMessageDO.class), serviceRegistryConverter);
        gsonBuilder.registerTypeAdapter((Type)((Object)ServiceRegistryResponseMessageDO.class), serviceRegistryConverter);
        FEvalResponseConverter fEvalResponseConverter = new FEvalResponseConverter();
        gsonBuilder.registerTypeAdapter((Type)((Object)FEvalOpaqueResponseMessageDO.class), fEvalResponseConverter);
        FEvalRequestConverter fEvalRequestConverter = new FEvalRequestConverter();
        gsonBuilder.registerTypeAdapter((Type)((Object)FEvalOpaqueRequestMessageDO.class), fEvalRequestConverter);
        SessionMessagesConverter sessionMessagesConverter = new SessionMessagesConverter();
        gsonBuilder.registerTypeAdapter((Type)((Object)SaveSessionRequestMessageDO.class), sessionMessagesConverter);
        gsonBuilder.registerTypeAdapter((Type)((Object)NewSessionRequestMessageDO.class), sessionMessagesConverter);
        gsonBuilder.registerTypeAdapter((Type)((Object)DeleteSessionRequestMessageDO.class), sessionMessagesConverter);
        gsonBuilder.registerTypeAdapter((Type)((Object)LoadSessionRequestMessageDO.class), sessionMessagesConverter);
        gsonBuilder.registerTypeAdapter((Type)((Object)LoadSessionResponseMessageDO.class), sessionMessagesConverter);
        gsonBuilder.registerTypeAdapter((Type)((Object)NewSessionResponseMessageDO.class), sessionMessagesConverter);
        gsonBuilder.setExclusionStrategies(new CustomExclusionStrategy());
        FeedbackConverter feedbackConverter = new FeedbackConverter();
        gsonBuilder.registerTypeAdapter((Type)((Object)FeedbackRequestMessageDO.class), feedbackConverter);
        AuthorizationDetailsConverter authorizationDetailsConverter = new AuthorizationDetailsConverter();
        gsonBuilder.registerTypeAdapter((Type)((Object)AuthorizationDetailsResponseMessageDO.class), authorizationDetailsConverter);
        SecurityConverter securityConverter = new SecurityConverter();
        gsonBuilder.registerTypeAdapter((Type)((Object)CreateProfileRequestMessageDO.class), securityConverter);
        gsonBuilder.registerTypeAdapter((Type)((Object)DeleteFileRequestMessageDO.class), new DeleteFileRequestConverter());
        gsonBuilder.registerTypeAdapter((Type)((Object)OpenFileRequestMessageDO.class), new OpenFileRequestConverter());
        gsonBuilder.registerTypeAdapter((Type)((Object)OpenFileResponseMessageDO.class), new OpenFileResponseConverter());
        gsonBuilder.registerTypeAdapter((Type)((Object)OpenOrCreateFileRequestMessageDO.class), new OpenOrCreateFileRequestConverter());
        gsonBuilder.registerTypeAdapter((Type)((Object)RenameFileRequestMessageDO.class), new RenameFileRequestConverter());
        gsonBuilder.registerTypeAdapter((Type)((Object)OpaqueMessageDO.class), new OpaqueMessageConverter());
        gsonBuilder.registerTypeAdapter((Type)((Object)MessageFaultDO.class), new MessageFaultConverter());
    }
}

