/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl.session;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.message.AbstractMessageDO;
import com.mathworks.matlabserver.internalservices.message.AbstractResponseMessageDO;
import com.mathworks.matlabserver.internalservices.session.DeleteSessionRequestMessageDO;
import com.mathworks.matlabserver.internalservices.session.HistoryCommandDO;
import com.mathworks.matlabserver.internalservices.session.LoadSessionRequestMessageDO;
import com.mathworks.matlabserver.internalservices.session.LoadSessionResponseMessageDO;
import com.mathworks.matlabserver.internalservices.session.NewSessionRequestMessageDO;
import com.mathworks.matlabserver.internalservices.session.NewSessionResponseMessageDO;
import com.mathworks.matlabserver.internalservices.session.PropertyDO;
import com.mathworks.matlabserver.internalservices.session.SaveSessionRequestMessageDO;
import com.mathworks.matlabserver.internalservices.session.SessionDataDO;
import com.mathworks.matlabserver.internalservices.session.SessionNameDO;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.time.DateUtils;

public class SessionMessagesConverter
implements JsonDeserializer,
JsonSerializer {
    public static final String UUID = "uuid";
    public static final String COMMAND_WINDOW_TEXT = "commandWindowText";
    public static final String COMMAND_HISTORY = "commandHistory";
    public static final String EDITOR_FILES = "editorFiles";
    public static final String SESSION_NAME = "sessionName";
    public static final String WINDOW_PROPERTIES = "windowProperties";
    public static final String CLIENT_PROPERTIES = "clientProperties";
    public static final String UTC_TIMESTAMP_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final String MESSAGE_FAULTS = "messageFaults";
    private static final Logger logger = Logger.getLogger(SessionMessagesConverter.class.getName());

    public Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        AbstractMessageDO retval = null;
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (type == SaveSessionRequestMessageDO.class) {
            SaveSessionRequestMessageDO request = new SaveSessionRequestMessageDO();
            request.setUuid(this.getUuid(jsonObject));
            request.setSessionData(this.getSessionData(jsonObject));
            retval = request;
        } else if (type == NewSessionRequestMessageDO.class) {
            NewSessionRequestMessageDO request = new NewSessionRequestMessageDO();
            request.setUuid(this.getUuid(jsonObject));
            request.setSessionName(this.getSessionName(jsonObject));
            retval = request;
        } else if (type == NewSessionResponseMessageDO.class) {
            NewSessionResponseMessageDO response = new NewSessionResponseMessageDO();
            response.setSessionData(this.getSessionData(jsonObject));
            response.setUuid(this.getUuid(jsonObject));
            retval = response;
        } else if (type == DeleteSessionRequestMessageDO.class) {
            DeleteSessionRequestMessageDO request = new DeleteSessionRequestMessageDO();
            request.setUuid(this.getUuid(jsonObject));
            request.setSessionName(this.getSessionName(jsonObject));
            retval = request;
        } else if (type == LoadSessionRequestMessageDO.class) {
            LoadSessionRequestMessageDO request = new LoadSessionRequestMessageDO();
            request.setUuid(this.getUuid(jsonObject));
            request.setSessionName(this.getSessionName(jsonObject));
            retval = request;
        } else if (type == LoadSessionResponseMessageDO.class) {
            LoadSessionResponseMessageDO response = new LoadSessionResponseMessageDO();
            response.setSessionData(this.getSessionData(jsonObject));
            response.setUuid(this.getUuid(jsonObject));
            retval = response;
        }
        return retval;
    }

    SessionNameDO getSessionName(JsonObject jsonObject) {
        SessionNameDO sessionName;
        JsonElement element = jsonObject.get(SESSION_NAME);
        if (element != null) {
            sessionName = new SessionNameDO();
            sessionName.setName(element.getAsString());
        } else {
            sessionName = new SessionNameDO();
            sessionName.setName("");
        }
        return sessionName;
    }

    SessionDataDO getSessionData(JsonObject jsonObject) {
        SessionDataDO sessionData = new SessionDataDO();
        sessionData.setSessionName(this.getSessionName(jsonObject));
        JsonElement element = jsonObject.get(COMMAND_HISTORY);
        if (element != null) {
            sessionData.setCommandHistory(this.getCommandHistoryArray(jsonObject));
        }
        if ((element = jsonObject.get(COMMAND_WINDOW_TEXT)) != null) {
            sessionData.setCommandWindowText(element.getAsString());
        }
        if ((element = jsonObject.get(EDITOR_FILES)) != null) {
            sessionData.setEditorFiles(this.getOpenFilesArray(jsonObject));
        }
        if ((element = jsonObject.get(WINDOW_PROPERTIES)) != null) {
            sessionData.setWindowProperties(this.getWindowPropertiesArray(jsonObject));
        }
        if ((element = jsonObject.get(CLIENT_PROPERTIES)) != null) {
            sessionData.setClientProperties(this.getClientProperties(jsonObject));
        }
        return sessionData;
    }

    String getUuid(JsonObject jsonObject) {
        String uuid = null;
        JsonElement element = jsonObject.get(UUID);
        if (element != null && !element.isJsonNull()) {
            uuid = element.getAsString();
        }
        return uuid;
    }

    String getClientProperties(JsonObject jsonObject) {
        String clientProperties = null;
        Gson gson = new Gson();
        JsonElement element = jsonObject.get(CLIENT_PROPERTIES);
        if (element != null) {
            clientProperties = gson.toJson(element);
        }
        return clientProperties;
    }

    FileInfoDO[] getOpenFilesArray(JsonObject jsonObject) {
        FileInfoDO[] fileInfoArray = null;
        JsonElement element = jsonObject.get(EDITOR_FILES);
        if (element != null) {
            int size = element.getAsJsonArray().size();
            int index = 0;
            for (FileInfoDO fileInfoElement : fileInfoArray = new FileInfoDO[size]) {
                String path = element.getAsJsonArray().get(index).getAsString();
                fileInfoArray[index] = fileInfoElement = new FileInfoDO(path);
                ++index;
            }
        }
        return fileInfoArray;
    }

    HistoryCommandDO[] getCommandHistoryArray(JsonObject jsonObject) {
        HistoryCommandDO[] commandHistory = null;
        JsonElement element = jsonObject.get(COMMAND_HISTORY);
        if (element != null) {
            int size = element.getAsJsonArray().size();
            int index = 0;
            for (HistoryCommandDO historyCommand : commandHistory = new HistoryCommandDO[size]) {
                historyCommand = new HistoryCommandDO();
                JsonElement historyElement = element.getAsJsonArray().get(index);
                if (historyElement.isJsonObject()) {
                    JsonElement timeElement = historyElement.getAsJsonObject().get("time");
                    JsonElement textElement = historyElement.getAsJsonObject().get("text");
                    historyCommand.setText(textElement.getAsString().trim());
                    try {
                        SimpleDateFormat format = new SimpleDateFormat(UTC_TIMESTAMP_FORMAT);
                        format.setTimeZone(TimeZone.getTimeZone("GMT"));
                        historyCommand.setTime(DateUtils.parseDate(timeElement.getAsString(), new String[]{format.toPattern()}));
                    }
                    catch (ParseException pe) {
                        historyCommand.setTime(null);
                    }
                }
                commandHistory[index] = historyCommand;
                ++index;
            }
        }
        return commandHistory;
    }

    PropertyDO[] getWindowPropertiesArray(JsonObject jsonObject) {
        Gson gson = new Gson();
        PropertyDO[] windowProperties = null;
        JsonElement element = jsonObject.get(WINDOW_PROPERTIES);
        if (element != null) {
            int size = element.getAsJsonArray().size();
            int index = 0;
            for (PropertyDO windowProperty : windowProperties = new PropertyDO[size]) {
                windowProperty = new PropertyDO();
                JsonElement windowElement = element.getAsJsonArray().get(index);
                if (windowElement.isJsonObject()) {
                    windowProperty = gson.fromJson((JsonElement)windowElement.getAsJsonObject(), PropertyDO.class);
                }
                windowProperties[index] = windowProperty;
                ++index;
            }
        }
        return windowProperties;
    }

    public JsonElement serialize(Object src, Type type, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        if (src instanceof SaveSessionRequestMessageDO) {
            SaveSessionRequestMessageDO request = (SaveSessionRequestMessageDO)src;
            if (request.getSessionData() != null) {
                jsonObject = this.convertSessionDataToJson(request.getSessionData(), context);
            }
            this.addAbstractMessageMembersToJson(request, context, jsonObject);
        } else if (src instanceof NewSessionRequestMessageDO) {
            NewSessionRequestMessageDO request = (NewSessionRequestMessageDO)src;
            if (request.getSessionName() != null) {
                JsonElement element = context.serialize(request.getSessionName().getName(), (Type)((Object)String.class));
                jsonObject.add(SESSION_NAME, element);
            }
            this.addAbstractMessageMembersToJson(request, context, jsonObject);
        } else if (src instanceof NewSessionResponseMessageDO) {
            NewSessionResponseMessageDO response = (NewSessionResponseMessageDO)src;
            if (response.getSessionData() != null) {
                jsonObject = this.convertSessionDataToJson(response.getSessionData(), context);
            }
            this.addAbstractResponseMessageMembersToJson(response, context, jsonObject);
        } else if (src instanceof DeleteSessionRequestMessageDO) {
            DeleteSessionRequestMessageDO request = (DeleteSessionRequestMessageDO)src;
            if (request.getSessionName() != null) {
                JsonElement element = context.serialize(request.getSessionName().getName(), (Type)((Object)String.class));
                jsonObject.add(SESSION_NAME, element);
            }
            this.addAbstractMessageMembersToJson(request, context, jsonObject);
        } else if (src instanceof LoadSessionRequestMessageDO) {
            LoadSessionRequestMessageDO request = (LoadSessionRequestMessageDO)src;
            this.addAbstractMessageMembersToJson(request, context, jsonObject);
            if (request.getSessionName() != null) {
                JsonElement element = context.serialize(request.getSessionName().getName(), (Type)((Object)String.class));
                jsonObject.add(SESSION_NAME, element);
            }
        } else if (src instanceof LoadSessionResponseMessageDO) {
            LoadSessionResponseMessageDO response = (LoadSessionResponseMessageDO)src;
            if (response.getSessionData() != null) {
                jsonObject = this.convertSessionDataToJson(response.getSessionData(), context);
            }
            this.addAbstractResponseMessageMembersToJson(response, context, jsonObject);
        }
        return jsonObject;
    }

    protected void addAbstractResponseMessageMembersToJson(AbstractResponseMessageDO message, JsonSerializationContext context, JsonObject obj) {
        if (message.getMessageFaults() != null) {
            obj.add(MESSAGE_FAULTS, context.serialize(message.getMessageFaults()));
        }
        this.addAbstractMessageMembersToJson(message, context, obj);
    }

    protected void addAbstractMessageMembersToJson(AbstractMessageDO message, JsonSerializationContext context, JsonObject obj) {
        if (message.getUuid() != null) {
            obj.add(UUID, context.serialize(message.getUuid(), (Type)((Object)String.class)));
        }
    }

    protected JsonObject convertSessionDataToJson(SessionDataDO sessionData, JsonSerializationContext context) {
        JsonElement element;
        JsonObject jsonObject = new JsonObject();
        if (sessionData.getSessionName() != null) {
            element = context.serialize(sessionData.getSessionName().getName(), (Type)((Object)String.class));
            jsonObject.add(SESSION_NAME, element);
        }
        if (sessionData.getCommandHistory() != null && (element = context.serialize(sessionData.getCommandHistory(), (Type)((Object)HistoryCommandDO[].class))) != null) {
            JsonArray historyCommands = new JsonArray();
            SimpleDateFormat f2 = new SimpleDateFormat(UTC_TIMESTAMP_FORMAT);
            f2.setTimeZone(TimeZone.getTimeZone("GMT"));
            for (HistoryCommandDO historyCommand : sessionData.getCommandHistory()) {
                JsonObject object = new JsonObject();
                object.addProperty("text", historyCommand.getText());
                try {
                    object.addProperty("time", f2.format(historyCommand.getTime()));
                }
                catch (Exception e2) {
                    object.addProperty("time", "");
                }
                historyCommands.add(object);
            }
            jsonObject.add(COMMAND_HISTORY, historyCommands);
        }
        if (sessionData.getCommandWindowText() != null && (element = context.serialize(sessionData.getCommandWindowText(), (Type)((Object)String.class))) != null) {
            jsonObject.add(COMMAND_WINDOW_TEXT, element);
        }
        if (sessionData.getEditorFiles() != null && (element = context.serialize(sessionData.getEditorFiles(), (Type)((Object)FileInfoDO[].class))) != null) {
            FileInfoDO[] fileInfos = sessionData.getEditorFiles();
            if (fileInfos != null) {
                String[] filePaths = new String[fileInfos.length];
                int index = 0;
                for (FileInfoDO fInfo : fileInfos) {
                    String path;
                    String properFileName = fInfo.getName().replaceAll("//", "/");
                    filePaths[index] = path = fInfo.getLocation() + properFileName;
                    ++index;
                }
                element = context.serialize(filePaths, (Type)((Object)String[].class));
            }
            jsonObject.add(EDITOR_FILES, element);
        }
        if (sessionData.getWindowProperties() != null && (element = context.serialize(sessionData.getWindowProperties(), (Type)((Object)PropertyDO[].class))) != null) {
            jsonObject.add(WINDOW_PROPERTIES, element);
        }
        if (sessionData.getClientProperties() != null && (element = context.serialize(sessionData.getClientProperties(), (Type)((Object)String.class))) != null) {
            JsonParser jsonParser = new JsonParser();
            try {
                jsonObject.add(CLIENT_PROPERTIES, jsonParser.parse(sessionData.getClientProperties()));
            }
            catch (Exception e3) {
                jsonObject.add(CLIENT_PROPERTIES, null);
                logger.log(Level.WARNING, "Client Properties Not Found");
            }
        }
        return jsonObject;
    }
}

