/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl.syntaxhighlighting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mathworks.matlabserver.internalservices.syntaxhighlighting.SyntaxHighlightingColorMapResponseMessageDO;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SyntaxHighlightingColorMapConverter
implements JsonSerializer<SyntaxHighlightingColorMapResponseMessageDO> {
    @Override
    public JsonElement serialize(SyntaxHighlightingColorMapResponseMessageDO message, Type type, JsonSerializationContext context) {
        JsonObject jsonMap = new JsonObject();
        List<Integer> tokenIds = SyntaxHighlightingColorMapConverter.getTokenIds(message);
        Collections.sort(tokenIds);
        for (Integer tokenId : tokenIds) {
            Color color = message.getColorMap().get(tokenId);
            JsonObject jsonColor = new JsonObject();
            jsonColor.addProperty("r", SyntaxHighlightingColorMapConverter.getColorByMethodName(color, "getRed"));
            jsonColor.addProperty("g", SyntaxHighlightingColorMapConverter.getColorByMethodName(color, "getGreen"));
            jsonColor.addProperty("b", SyntaxHighlightingColorMapConverter.getColorByMethodName(color, "getBlue"));
            jsonMap.add(String.valueOf(tokenId), jsonColor);
        }
        return jsonMap;
    }

    private static List<Integer> getTokenIds(SyntaxHighlightingColorMapResponseMessageDO message) {
        try {
            Object colorMap = message.getClass().getMethod("getColorMap", new Class[0]).invoke((Object)message, new Object[0]);
            Set keySet = (Set)colorMap.getClass().getMethod("keySet", new Class[0]).invoke(colorMap, new Object[0]);
            return new ArrayList<Integer>(keySet);
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static int getColorByMethodName(Object obj, String methodName) {
        try {
            return (Integer)obj.getClass().getMethod(methodName, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (Exception e2) {
            return 0;
        }
    }
}

