/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.matlabsubscriber;

import com.mathworks.jmi.Matlab;
import com.mathworks.matlabserver.common.util.CalledFromMATLAB;
import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageRaw;
import com.mathworks.messageservice.Subscriber;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MatlabSubscriberImpl
implements Subscriber {
    private static final Logger logger = Logger.getLogger(MatlabSubscriberImpl.class.getName());
    private static final ConcurrentHashMap<String, MatlabSubscriberImpl> subscribers = new ConcurrentHashMap();
    private static final String EXECUTE_CALLBACK_FUNCTION = "message.internal.executeCallback";
    private final String subscriberId;
    private final String channel;

    public MatlabSubscriberImpl(String channel) {
        this.channel = channel;
        this.subscriberId = UUID.randomUUID().toString();
        logger.finest("new subscriber id: " + this.subscriberId + " for channel:" + channel);
    }

    @Override
    public void handle(Message message) {
        String messageJSON;
        if (message.getData() instanceof byte[]) {
            try {
                messageJSON = new String(((MessageRaw)message).getData(), "UTF-8");
            }
            catch (UnsupportedEncodingException e2) {
                messageJSON = new String(((MessageRaw)message).getData());
            }
        } else {
            messageJSON = (String)message.getData();
        }
        logger.finest("Execute Callback for subscriber Id:" + this.subscriberId + " with message: " + messageJSON);
        this.doExecuteCallback(this.subscriberId, messageJSON);
    }

    public String getSubscriberId() {
        return this.subscriberId;
    }

    public String getChannel() {
        return this.channel;
    }

    protected void doExecuteCallback(final String subscriberId, final String messageJSON) {
        Matlab.whenMatlabReady((Runnable)new Runnable(){

            @Override
            public void run() {
                Object[] arguments = new Object[]{subscriberId, messageJSON};
                try {
                    Object result = Matlab.mtFevalConsoleOutput((String)MatlabSubscriberImpl.EXECUTE_CALLBACK_FUNCTION, (Object[])arguments, (int)0);
                    if (result == null || !(result instanceof String)) {
                        logger.fine("Error while processing subscription callback: " + subscriberId + " - '" + messageJSON + "'");
                    }
                }
                catch (Exception e2) {
                    logger.log(Level.FINE, "Error while processing subscription callback", e2);
                }
            }
        });
    }

    @CalledFromMATLAB
    public static void addSubscriber(MatlabSubscriberImpl subscriber) {
        subscribers.put(subscriber.getSubscriberId(), subscriber);
    }

    @CalledFromMATLAB
    public static MatlabSubscriberImpl getSubscriber(String subscriberId) {
        return subscribers.get(subscriberId);
    }

    @CalledFromMATLAB
    public static void removeSubscriber(String subscriberId) {
        subscribers.remove(subscriberId);
    }

    @CalledFromMATLAB
    public static Enumeration<MatlabSubscriberImpl> getSubscribers() {
        return subscribers.elements();
    }
}

