/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.rest.client.jersey;

import com.mathworks.matlabserver.common.rest.RestClientConfig;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import com.sun.jersey.core.impl.provider.entity.StringProvider;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;

public class BaseJerseyRestClient {
    private static final Logger log = Logger.getLogger(BaseJerseyRestClient.class.getName());
    private final Client client;
    private final RestClientConfig clientConfig;
    private final HttpURLConnectionFactory httpURLConnectionFactory;

    protected BaseJerseyRestClient(RestClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.httpURLConnectionFactory = this.createHttpUrlConnectionFactory();
        this.client = this.createClient();
    }

    protected HttpURLConnectionFactory createHttpUrlConnectionFactory() {
        Object httpURLConnectionFactory;
        if (StringUtils.isNotEmpty(this.clientConfig.getHttpProxyHost())) {
            final Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.clientConfig.getHttpProxyHost(), (int)this.clientConfig.getHttpProxyPort()));
            httpURLConnectionFactory = new HttpURLConnectionFactory(){

                public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                    return (HttpURLConnection)url.openConnection(proxy);
                }
            };
        } else {
            httpURLConnectionFactory = new HttpURLConnectionFactory(){

                public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                    return (HttpURLConnection)url.openConnection();
                }
            };
        }
        return httpURLConnectionFactory;
    }

    protected Client createClient() {
        DefaultClientConfig jerseyClientConfig = new DefaultClientConfig();
        jerseyClientConfig.getProperties().put("com.sun.jersey.client.property.connectTimeout", this.clientConfig.getConnectTimeoutMillis());
        jerseyClientConfig.getProperties().put("com.sun.jersey.client.property.readTimeout", this.clientConfig.getReadTimeoutMillis());
        jerseyClientConfig.getClasses().add(JacksonJsonProvider.class);
        jerseyClientConfig.getClasses().add(StringProvider.class);
        jerseyClientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        TrustManager[] tm = this.createTrustManagers();
        SSLContext sslContext = this.createSSLContext(tm);
        HostnameVerifier hostNameVerifier = this.createHostNameVerifier();
        try {
            jerseyClientConfig.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(hostNameVerifier, sslContext));
        }
        catch (Exception e2) {
            log.log(Level.SEVERE, "Error setting HTTPS properties for REST client", e2);
        }
        Client client = new Client((ClientHandler)new URLConnectionClientHandler(this.httpURLConnectionFactory), (ClientConfig)jerseyClientConfig);
        return client;
    }

    protected HostnameVerifier createHostNameVerifier() {
        HostnameVerifier hostNameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        return hostNameVerifier;
    }

    protected Client getClient() {
        return this.client;
    }

    protected SSLContext createSSLContext(TrustManager[] trustManagers) {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagers, new SecureRandom());
        }
        catch (GeneralSecurityException ex) {
            log.log(Level.SEVERE, "Error initializing SSL context for REST client", ex);
        }
        return sslContext;
    }

    protected TrustManager[] createTrustManagers() {
        TrustManager[] certs = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        return certs;
    }
}

