/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.worker.service.eval.impl13b;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabMCRFactory;
import com.mathworks.jmi.typocorrection.TypoSuggestionEvent;
import com.mathworks.matlabserver.internalservices.eval.EvalRequestMessageDO;
import com.mathworks.matlabserver.internalservices.eval.EvalResponseMessageDO;
import com.mathworks.matlabserver.internalservices.faults.FaultUtils;
import com.mathworks.matlabserver.internalservices.faults.MessageFaultDO;
import com.mathworks.matlabserver.worker.desktopservices.Interrupt;
import com.mathworks.matlabserver.worker.service.eval.impl13b.AbstractMvmEval;
import com.mathworks.matlabserver.worker.service.eval.impl13b.MvmBufferedWriter;
import com.mathworks.matlabserver.worker.service.eval.impl13b.MvmIqmInputListener;
import com.mathworks.matlabserver.worker.service.eval.impl13b.MvmSinkTextListener;
import com.mathworks.matlabserver.worker.service.eval.impl13b.MvmSuggestListener;
import com.mathworks.matlabserver.worker_config_management.MatlabServerConfigFactory;
import com.mathworks.matlabserver.workercommon.desktopservices.InterruptImpl;
import com.mathworks.matlabserver.workercommon.desktopservices.WorkerConfig;
import com.mathworks.matlabserver.workercommon.util.ConcurrencyCheck;
import com.mathworks.mvm.MvmFactory;
import com.mathworks.mvm.eventmgr.EventMgr;
import com.mathworks.mvm.eventmgr.MvmListener;
import com.mathworks.mvm.eventmgr.SinkTextEvent;
import com.mathworks.mvm.eventmgr.prompt.IqmInputRequestEvent;
import com.mathworks.mvm.exec.MatlabEvalRequest;
import com.mathworks.services.SystemServices;
import java.io.Writer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MvmEval13bImpl
extends AbstractMvmEval {
    private static final Logger logger = Logger.getLogger(MvmEval13bImpl.class.getName());
    private static final String SUGGEST_PREFIX = "Did you mean: ";
    private static final String SUGGEST_POSTFIX = " ?";
    private final MatlabMCR matlab = MatlabMCRFactory.getForCurrentMCR();
    private final MvmBufferedWriter evalWriter = new MvmBufferedWriter();
    private final MvmBufferedWriter errWriter = new MvmBufferedWriter();
    private final MvmIqmInputListener iqmListener = new MvmIqmInputListener();
    private final MvmSuggestListener suggestListener = new MvmSuggestListener();
    private final MvmSinkTextListener textListener = new MvmSinkTextListener();
    private final Interrupt interrupter = new InterruptImpl(new WorkerConfig());
    private final TimeUnit requestTimeoutUnit = TimeUnit.SECONDS;
    private final long requestTimeoutInSeconds;
    private final Object lock = new Object();
    private boolean clc = false;
    protected static boolean specialDebuggingEnabled = false;

    public static void setSpecialDebuggingEnabled(boolean enabled) {
        specialDebuggingEnabled = enabled;
    }

    public MvmEval13bImpl() {
        this(true);
    }

    public MvmEval13bImpl(boolean registerSinkTextEvent) {
        this.registerHooksWithMvm(registerSinkTextEvent);
        this.requestTimeoutInSeconds = MatlabServerConfigFactory.getConfig().getMvmEvalRequestTimeout();
    }

    private void registerHooksWithMvm(final boolean registerSinkTextEvent) {
        MatlabMCR matlab = MatlabMCRFactory.getForCurrentMCR();
        matlab.whenMatlabReady(new Runnable(){

            @Override
            public void run() {
                if (registerSinkTextEvent) {
                    SystemServices.enableSinkTextEventPublishing();
                }
                EventMgr eventMgr = MvmFactory.getCurrentMVM().getEventMgr();
                eventMgr.addMvmListener((MvmListener)MvmEval13bImpl.this.iqmListener, IqmInputRequestEvent.class);
                eventMgr.addMvmListener((MvmListener)MvmEval13bImpl.this.suggestListener, TypoSuggestionEvent.class);
                if (registerSinkTextEvent) {
                    eventMgr.addMvmListener((MvmListener)MvmEval13bImpl.this.textListener, SinkTextEvent.class);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvalResponseMessageDO authoringEval(EvalRequestMessageDO evalRequest) {
        EvalResponseMessageDO retval;
        Semaphore binarySemaphore = new Semaphore(1);
        String uuid = evalRequest.getUuid();
        String mcommand = evalRequest.getMcode();
        MatlabEvalRequest request = new MatlabEvalRequest(mcommand, (Writer)this.evalWriter, (Writer)this.errWriter);
        request.setExternal(true);
        ConcurrencyCheck.getInstance().checkIsNotMatlabThread();
        Object object = this.lock;
        synchronized (object) {
            try {
                if (evalRequest.getHeight() > 0 || evalRequest.getWidth() > 0) {
                    this.matlab.setWindowSize(evalRequest.getHeight(), evalRequest.getWidth());
                }
                this.iqmListener.setSemaphore(binarySemaphore);
                this.suggestListener.clearSuggestion();
                this.textListener.clearBuffer();
                binarySemaphore.acquire();
                this.executeAsyncEval(request, binarySemaphore);
                if (this.requestTimeoutInSeconds > 0L) {
                    if (!binarySemaphore.tryAcquire(this.requestTimeoutInSeconds, this.requestTimeoutUnit)) {
                        logger.info("Waited for " + this.requestTimeoutInSeconds + " seconds.");
                        String message = "MATLAB operation interrupted. Operation(s) taking longer than " + this.requestTimeoutInSeconds + " " + StringUtils.lowerCase(this.requestTimeoutUnit.toString() + " are not supported for this product offering.");
                        throw new TimeoutException(message);
                    }
                } else {
                    binarySemaphore.acquire();
                }
                this.synchronousFlushPendingInterpreterEvents();
                String evalWriterStr = this.evalWriter.getBuffer().toString();
                String errWriterStr = this.errWriter.getBuffer().toString();
                String suggestion = this.suggestListener.getSuggestion();
                String textListenerStr = this.textListener.getBuffer();
                boolean isTruncated = this.textListener.isTruncated() || this.evalWriter.isTruncated() || this.errWriter.isTruncated();
                retval = this.createResponseFromWriters(uuid, this.iqmListener.getPromptType(), evalWriterStr, errWriterStr, textListenerStr, suggestion, this.clc, isTruncated);
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, "Error", e2);
                if (FaultUtils.isTimeoutException(e2)) {
                    logger.info("TimeoutException caught, MATLAB interpreter will be interrupted.");
                    this.interruptMatlabInterpreter();
                }
                retval = this.createResponseFromException(uuid, e2);
            }
            finally {
                this.clc = false;
                this.iqmListener.setSemaphore(null);
                binarySemaphore.release();
                this.evalWriter.reset();
                this.errWriter.reset();
            }
        }
        if (specialDebuggingEnabled) {
            System.out.println("EvalRequest: " + evalRequest.getMcode());
            System.out.println("EvalResponse: " + retval.getResponseStr());
        }
        return retval;
    }

    private void interruptMatlabInterpreter() {
        this.interrupter.interrupt();
        EvalRequestMessageDO emptyEvalRequest = new EvalRequestMessageDO();
        emptyEvalRequest.setMcode("");
        this.executionEval(emptyEvalRequest);
    }

    private void synchronousFlushPendingInterpreterEvents() {
        ConcurrencyCheck.getInstance().checkIsNotMatlabThread();
        try {
            final Semaphore semaphore = new Semaphore(1);
            semaphore.acquire();
            this.matlab.whenMatlabIdle(new Runnable(){

                @Override
                public void run() {
                    semaphore.release();
                }
            });
            semaphore.acquire();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Issue with flushing queue", e2);
        }
    }

    protected EvalResponseMessageDO createResponseFromWriters(String uuid, int promptType, String evalWriterStr, String errWriterStr, String textListenerStr, String suggestion, boolean clc, boolean isTruncated) {
        EvalResponseMessageDO evalMessage = new EvalResponseMessageDO();
        boolean isError = this.isError(errWriterStr);
        StringBuilder response = new StringBuilder();
        evalMessage.setError(isError);
        evalMessage.setUuid(uuid);
        evalMessage.setPromptType(promptType);
        if (!StringUtils.isEmpty(evalWriterStr)) {
            String result = this.truncateResult(evalMessage, evalWriterStr);
            response.append(result);
        }
        if (!StringUtils.isEmpty(errWriterStr)) {
            response.append(errWriterStr);
            if (!StringUtils.isEmpty(suggestion)) {
                response.append(SUGGEST_PREFIX);
                response.append(suggestion);
                response.append(SUGGEST_POSTFIX);
            }
        }
        evalMessage.setResponseStr(response.toString());
        evalMessage.setClearCommandWindow(clc);
        if (StringUtils.isNotEmpty(textListenerStr)) {
            evalMessage.setResponseStr(evalMessage.getResponseStr() + this.textListener.getBuffer());
        }
        if (isTruncated) {
            evalMessage.setFault(MessageFaultDO.newInstanceWithFaultCode("ComputeService.EvalTruncateResultWarning"));
        }
        return evalMessage;
    }

    @Override
    public void clc() {
        this.clc = true;
        this.evalWriter.reset();
    }
}

