/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.worker_config_management.logging;

import com.mathworks.matlabserver.worker_config_management.MatlabServerConfigBean;
import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;

public class LoggingManager {
    private static final String ROOT_LOGGER = "";

    public static synchronized void apply(MatlabServerConfigBean configBean) {
        if (configBean != null) {
            if (configBean.isEnableConsoleLogging()) {
                LoggingManager.enableConsoleLogging();
            } else {
                LoggingManager.removeAllConsoleLogging();
            }
            LoggingManager.setFileLogging(configBean.getLogFileName(), configBean.getLogFileFormat());
        }
    }

    public static void enableConsoleLogging() {
        Handler[] handlerList;
        boolean foundConsoleHandler = false;
        Logger rootLogger = LoggingManager.getRootLogger();
        for (Handler handler : handlerList = rootLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            foundConsoleHandler = true;
            break;
        }
        if (!foundConsoleHandler) {
            ConsoleHandler cHandler = new ConsoleHandler();
            rootLogger.addHandler(cHandler);
        }
    }

    private static void removeAllConsoleLogging() {
        Handler[] handlerList;
        Logger rootLogger = LoggingManager.getRootLogger();
        for (Handler handler : handlerList = rootLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            rootLogger.removeHandler(handler);
        }
    }

    private static void removeAllFileLogging() {
        Handler[] handlerList;
        Logger rootLogger = LoggingManager.getRootLogger();
        for (Handler handler : handlerList = rootLogger.getHandlers()) {
            if (!(handler instanceof FileHandler)) continue;
            rootLogger.removeHandler(handler);
        }
    }

    private static void setFileLogging(String fileName, String format) {
        LoggingManager.removeAllFileLogging();
        if (fileName != null && fileName.length() > 1) {
            try {
                File file = new File(fileName);
                file.createNewFile();
                if (file.canWrite()) {
                    Logger rootLogger = LoggingManager.getRootLogger();
                    boolean append = true;
                    FileHandler fileHandler = new FileHandler(fileName, append);
                    if (format != null && format.equals("xml")) {
                        fileHandler.setFormatter(new XMLFormatter());
                    } else {
                        fileHandler.setFormatter(new SimpleFormatter());
                    }
                    rootLogger.addHandler(fileHandler);
                    rootLogger.info("*** ADDING NEW LOG HANDLER ***");
                } else {
                    System.err.println("Invalid log file specified in worker.properties: " + fileName);
                }
            }
            catch (IOException e2) {
                System.err.println("Invalid log file specified in worker.properties: " + fileName);
            }
        }
    }

    private static Logger getRootLogger() {
        return Logger.getLogger(ROOT_LOGGER);
    }
}

