/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.messageservice;

import com.mathworks.messageservice.AbstractMessageService;
import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageService;
import com.mathworks.messageservice.Subscriber;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class MessageServiceLoopback
extends AbstractMessageService
implements MessageService {
    private ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("message service loopback");
            thread.setDaemon(true);
            return thread;
        }
    });
    private Deque<PendingMessage> pendingMessageTasks = new ArrayDeque<PendingMessage>();
    private MessageService messageService;
    private final ConcurrentMap<String, Set<Subscriber>> subscriptions = new ConcurrentHashMap<String, Set<Subscriber>>();
    private int delayMs;

    @Override
    public void handleMessage(Message message) {
        for (String channel : this.subscriptions.keySet()) {
            if (!this.doesSubscriptionChannelMatchMessage(channel, message)) continue;
            Set subscribers = (Set)this.subscriptions.get(channel);
            for (Subscriber subscriber : subscribers) {
                subscriber.handle(message);
            }
        }
    }

    @Override
    public synchronized void subscribe(String channel, Subscriber observer) {
        Set<Subscriber> subscribers = new HashSet<Subscriber>();
        Set oldSubscribers = this.subscriptions.putIfAbsent(channel, subscribers);
        if (oldSubscribers != null) {
            subscribers = oldSubscribers;
        }
        subscribers.add(observer);
    }

    @Override
    public synchronized void unsubscribe(String channel, Subscriber subscriber) {
        Set subscribers = (Set)this.subscriptions.get(channel);
        if (subscribers != null) {
            subscribers.remove(subscriber);
        }
    }

    @Override
    public void publish(final String channel, final Object data) {
        if (this.delayMs > 0) {
            final PendingMessage message = new PendingMessage();
            message.runnable = new Runnable(){

                @Override
                public void run() {
                    MessageServiceLoopback.this.pendingMessageTasks.remove(message);
                    MessageServiceLoopback.this.doPublish(channel, data);
                }
            };
            message.future = this.service.schedule(message.runnable, (long)this.delayMs, TimeUnit.MILLISECONDS);
            this.pendingMessageTasks.push(message);
        } else {
            this.doPublish(channel, data);
        }
    }

    private void doPublish(final String channel, final Object data) {
        if (this.messageService != null) {
            this.messageService.handleMessage(new Message(){

                @Override
                public String getChannel() {
                    return channel;
                }

                @Override
                public Object getData() {
                    return data;
                }
            });
        }
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setDelay(int ms) {
        this.delayMs = ms;
    }

    public void flush() {
        while (!this.pendingMessageTasks.isEmpty()) {
            PendingMessage message = this.pendingMessageTasks.pop();
            message.future.cancel(false);
            message.runnable.run();
        }
    }

    public void deliverNext() {
        if (!this.pendingMessageTasks.isEmpty()) {
            PendingMessage message = this.pendingMessageTasks.pop();
            message.future.cancel(false);
            message.runnable.run();
        }
    }

    private class PendingMessage {
        public ScheduledFuture future;
        public Runnable runnable;

        private PendingMessage() {
        }
    }
}

