/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.messageservice.asynchronous;

import com.mathworks.matlabserver.internalservices.common.MessageContainerDO;
import com.mathworks.matlabserver.internalservices.common.MessagePushConsumer;
import com.mathworks.matlabserver.internalservices.common.MessagePushProducer;
import com.mathworks.matlabserver.internalservices.opaqueMessageService.OpaqueMessageDO;
import com.mathworks.matlabserver.internalservices.opaqueMessageService.OpaqueRequestMessageDO;
import com.mathworks.matlabserver.internalservices.opaqueMessageService.OpaqueResponseMessageDO;
import com.mathworks.messageservice.AbstractMessageService;
import com.mathworks.messageservice.MessageRaw;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.messageservice.MessageServiceOpaque;
import com.mathworks.messageservice.Subscriber;
import com.mathworks.messageservice.json.MessageJSON;
import com.mathworks.messageservice.json.MessageServiceJSONImpl;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageServiceAsyncPushImpl
extends AbstractMessageService
implements MessageServiceOpaque,
MessagePushProducer {
    private static final Logger logger = Logger.getLogger(MessageServiceAsyncPushImpl.class.getName());
    private ArrayList pushMessages = new ArrayList();
    private static List<MessagePushConsumer> consumers = new ArrayList<MessagePushConsumer>();
    private final Lock lock = new ReentrantLock();

    public void handleMessage(OpaqueRequestMessageDO opaqueRequestMessageDO) {
        MessageServiceJSONImpl messageServiceJSON = (MessageServiceJSONImpl)MessageServiceFactory.getMessageService();
        OpaqueMessageDO[] opaqueMessageDOs = opaqueRequestMessageDO.getOpaqueMessageDOs();
        if (opaqueMessageDOs != null) {
            for (OpaqueMessageDO opaqueMessageDO : opaqueMessageDOs) {
                MessageRaw message = new MessageRaw(opaqueMessageDO.getChannel(), opaqueMessageDO.getData());
                for (String channel : this.subscriptions.keySet()) {
                    if (!this.doesSubscriptionChannelMatchMessage(channel, message)) continue;
                    List subscribers = (List)this.subscriptions.get(channel);
                    for (Subscriber subscriber : subscribers) {
                        try {
                            subscriber.handle(message);
                        }
                        catch (Exception e2) {
                            logger.log(Level.WARNING, "Error in subscription handler", e2);
                        }
                    }
                }
                try {
                    messageServiceJSON.handleMessage(new MessageJSON(opaqueMessageDO.getChannel(), new String(opaqueMessageDO.getData(), "UTF-8")));
                }
                catch (UnsupportedEncodingException e3) {
                    logger.log(Level.ALL, "Unable to handle message.", e3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(String channel, byte[] message) {
        this.lock.lock();
        try {
            OpaqueMessageDO opaqueMessage = new OpaqueMessageDO();
            opaqueMessage.setData(message);
            opaqueMessage.setChannel(channel);
            this.pushMessages.add(opaqueMessage);
            this.notifyObservers();
            this.clearPushMessages();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void addMessagePushConsumer(MessagePushConsumer o2) {
        logger.finer("SoW ASYNC: Added Push Message Consumer : " + o2.getClass().getName());
        consumers.add(o2);
    }

    @Override
    public void removeMessagePushConsumer(MessagePushConsumer o2) {
        consumers.remove(o2);
    }

    private void notifyObservers() {
        if (consumers.size() < 1) {
            logger.finer("No RMI Client for dispatch... creating a new one!");
        }
        for (MessagePushConsumer pushConsumer : consumers) {
            MessageContainerDO packagedMessages = this.getPackagedMessages(this.getPushMessages());
            logger.finer("SoW ASYNC: Notifying RMI Consumer : " + packagedMessages.getAllMessages().size() + " messages for " + pushConsumer.getClass().getName());
            pushConsumer.handlePushMessage(packagedMessages);
        }
        this.clearPushMessages();
    }

    private void clearPushMessages() {
        Iterator iterator = this.pushMessages.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    private MessageContainerDO getPackagedMessages(ArrayList<OpaqueMessageDO> pushMessages) {
        MessageContainerDO messageContainer = new MessageContainerDO();
        OpaqueResponseMessageDO pushMessagesContainer = new OpaqueResponseMessageDO();
        try {
            OpaqueMessageDO[] opaqueMessages = pushMessages.toArray(new OpaqueMessageDO[0]);
            if (opaqueMessages.length > 0) {
                pushMessagesContainer.setOpaqueMessageDOs(opaqueMessages);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        messageContainer.addMessage(OpaqueResponseMessageDO.class, pushMessagesContainer);
        return messageContainer;
    }

    public ArrayList getPushMessages() {
        return this.pushMessages;
    }
}

