/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.messageservice.utils;

import com.google.gson.Gson;
import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.messageservice.MessageServiceOpaque;
import com.mathworks.messageservice.Subscriber;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class EchoService
implements Subscriber {
    private static final Logger logger = Logger.getLogger(EchoService.class.getName());
    private static final int PUSH_NUMBER = 1;
    private static final String ECHO_SERVICE_CHANNEL = "/echo";
    private static final String DOUBLE_ECHO = "GetDoubleEcho";
    private static final String MULTI_CHANNEL = "GetEchoOnMultipleChannels";
    private static final String DEMO_ONE = "RunDemoService";
    private static final String[] DEMO_CHANNELS = new String[]{"/alpha", "/beta", "/delta"};
    private static final String SERVER_ECHO = "/server";
    private static final String CLIENT_ECHO = "/client";
    private static volatile EchoService echoService;
    private static final Gson gson;
    private static MessageServiceOpaque messageService;
    private static AtomicInteger counter;
    private static List<String> specials;
    private static long startTime;

    public static synchronized void start() {
        EchoService.start(MessageServiceFactory.getMessageServiceOpaque());
    }

    public static synchronized void start(MessageServiceOpaque messageService) {
        EchoService.stop();
        EchoService.messageService = messageService;
        echoService = new EchoService();
        messageService.subscribe(ECHO_SERVICE_CHANNEL, echoService);
        messageService.subscribe("/echo/**", echoService);
    }

    public static synchronized void stop() {
        if (echoService != null && messageService != null) {
            try {
                messageService.unsubscribe(ECHO_SERVICE_CHANNEL, echoService);
                messageService.unsubscribe("/echo/**", echoService);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static synchronized void sendRequest(int size) {
        if (echoService != null) {
            StringBuilder text = new StringBuilder(size + 2);
            text.append("\"");
            String possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
            for (int i2 = 0; i2 < size; ++i2) {
                text.append(possible.charAt((int)Math.floor(Math.random() * (double)possible.length())));
            }
            text.append("\"");
            startTime = System.currentTimeMillis();
            messageService.publish("/echo/client", text.toString().getBytes());
        }
    }

    EchoService() {
    }

    @Override
    public void handle(Message message) {
        if (message.getChannel().equals("/echo/server")) {
            System.out.println("Received echo request");
            messageService.publish(message.getChannel(), (byte[])message.getData());
        } else if (message.getChannel().equals("/echo/client")) {
            System.out.println("Received echo response, elapsed time: " + (System.currentTimeMillis() - startTime));
        } else {
            String messageString = new String((byte[])message.getData());
            logger.info("Echo Service: Receiving : " + messageString);
            List<String> specials = this.matchesSpecials(messageString);
            if (specials.size() == 0) {
                logger.info("Echo Service: Dispatching (1)  in response");
                for (int i2 = 0; i2 < 1; ++i2) {
                    CometEchoMessageDO cometEchoMessage = this.getCometEchoMessage(messageString, ECHO_SERVICE_CHANNEL);
                    String echoResponseMessage = gson.toJson((Object)cometEchoMessage, (Type)((Object)CometEchoMessageDO.class));
                    messageService.publish(cometEchoMessage.channelInfo, echoResponseMessage.getBytes());
                }
            } else {
                this.handleSpecials(specials, messageString);
            }
        }
    }

    private void handleSpecials(List<String> whichSpecials, String message) {
        if (whichSpecials.contains(DOUBLE_ECHO)) {
            CometEchoMessageDO cometEchoMessage = this.getCometEchoMessage(message, ECHO_SERVICE_CHANNEL);
            String echoResponseMessage = gson.toJson((Object)cometEchoMessage, (Type)((Object)CometEchoMessageDO.class));
            messageService.publish(cometEchoMessage.channelInfo, echoResponseMessage.getBytes());
            messageService.publish(cometEchoMessage.channelInfo, echoResponseMessage.getBytes());
        }
        if (whichSpecials.contains(MULTI_CHANNEL)) {
            for (int i2 = 0; i2 < 2; ++i2) {
                CometEchoMessageDO cometEchoMessage = this.getCometEchoMessage(message, "/echo/" + i2);
                String echoResponseMessage = gson.toJson((Object)cometEchoMessage, (Type)((Object)CometEchoMessageDO.class));
                messageService.publish(cometEchoMessage.channelInfo, echoResponseMessage.getBytes());
            }
        }
        if (whichSpecials.contains(DEMO_ONE)) {
            for (String channel : DEMO_CHANNELS) {
                CometEchoMessageDO cometEchoMessage = this.getCometEchoMessage("customDemo", ECHO_SERVICE_CHANNEL + channel);
                String echoResponseMessage = gson.toJson((Object)cometEchoMessage, (Type)((Object)CometEchoMessageDO.class));
                messageService.publish(cometEchoMessage.channelInfo, echoResponseMessage.getBytes());
            }
        }
    }

    private List<String> matchesSpecials(String message) {
        ArrayList<String> whichSpecials = new ArrayList<String>();
        boolean retval = false;
        for (String special : specials) {
            if (!message.contains(special)) continue;
            retval = true;
            whichSpecials.add(special);
        }
        return whichSpecials;
    }

    private CometEchoMessageDO getCometEchoMessage(String messageString, String channel) {
        CometEchoMessageDO cometEchoMessage = new CometEchoMessageDO();
        cometEchoMessage.setId(counter.addAndGet(1));
        cometEchoMessage.setMessage(messageString);
        cometEchoMessage.setChannelInfo(channel);
        cometEchoMessage.setServerField("Echo Server");
        return cometEchoMessage;
    }

    static {
        gson = new Gson();
        counter = new AtomicInteger(0);
        specials = new ArrayList<String>();
        specials.add(DOUBLE_ECHO);
        specials.add(MULTI_CHANNEL);
        specials.add(DEMO_ONE);
    }

    class CometEchoMessageDO {
        private int id;
        private String message;
        private String serverField;
        private String channelInfo;

        CometEchoMessageDO() {
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setServerField(String serverField) {
            this.serverField = serverField;
        }

        public void setChannelInfo(String channelInfo) {
            this.channelInfo = channelInfo;
        }
    }
}

