/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.iap;

import com.sun.mail.iap.AString;
import com.sun.mail.iap.Atom;
import com.sun.mail.iap.Literal;
import com.sun.mail.iap.LiteralException;
import com.sun.mail.iap.Protocol;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.util.ASCIIUtility;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class Argument {
    protected Vector items = new Vector(1);

    public void append(Argument arg) {
        this.items.ensureCapacity(this.items.size() + arg.items.size());
        for (int i2 = 0; i2 < arg.items.size(); ++i2) {
            this.items.addElement(arg.items.elementAt(i2));
        }
    }

    public void writeString(String s) {
        this.items.addElement(new AString(ASCIIUtility.getBytes(s)));
    }

    public void writeString(String s, String charset) throws UnsupportedEncodingException {
        if (charset == null) {
            this.writeString(s);
        } else {
            this.items.addElement(new AString(s.getBytes(charset)));
        }
    }

    public void writeBytes(byte[] b2) {
        this.items.addElement(b2);
    }

    public void writeBytes(ByteArrayOutputStream b2) {
        this.items.addElement(b2);
    }

    public void writeBytes(Literal b2) {
        this.items.addElement(b2);
    }

    public void writeAtom(String s) {
        this.items.addElement(new Atom(s));
    }

    public void writeNumber(int i2) {
        this.items.addElement(new Integer(i2));
    }

    public void writeNumber(long i2) {
        this.items.addElement(new Long(i2));
    }

    public void writeArgument(Argument c2) {
        this.items.addElement(c2);
    }

    public void write(Protocol protocol) throws IOException, ProtocolException {
        int size = this.items != null ? this.items.size() : 0;
        DataOutputStream os = (DataOutputStream)protocol.getOutputStream();
        for (int i2 = 0; i2 < size; ++i2) {
            Object o2;
            if (i2 > 0) {
                os.write(32);
            }
            if ((o2 = this.items.elementAt(i2)) instanceof Atom) {
                os.writeBytes(((Atom)o2).string);
                continue;
            }
            if (o2 instanceof Number) {
                os.writeBytes(((Number)o2).toString());
                continue;
            }
            if (o2 instanceof AString) {
                this.astring(((AString)o2).bytes, protocol);
                continue;
            }
            if (o2 instanceof byte[]) {
                this.literal((byte[])o2, protocol);
                continue;
            }
            if (o2 instanceof ByteArrayOutputStream) {
                this.literal((ByteArrayOutputStream)o2, protocol);
                continue;
            }
            if (o2 instanceof Literal) {
                this.literal((Literal)o2, protocol);
                continue;
            }
            if (!(o2 instanceof Argument)) continue;
            os.write(40);
            ((Argument)o2).write(protocol);
            os.write(41);
        }
    }

    private void astring(byte[] bytes, Protocol protocol) throws IOException, ProtocolException {
        byte b2;
        int i2;
        DataOutputStream os = (DataOutputStream)protocol.getOutputStream();
        int len = bytes.length;
        if (len > 1024) {
            this.literal(bytes, protocol);
            return;
        }
        boolean quote = len == 0;
        boolean escape = false;
        for (i2 = 0; i2 < len; ++i2) {
            b2 = bytes[i2];
            if (b2 == 0 || b2 == 13 || b2 == 10 || (b2 & 0xFF) > 127) {
                this.literal(bytes, protocol);
                return;
            }
            if (b2 != 42 && b2 != 37 && b2 != 40 && b2 != 41 && b2 != 123 && b2 != 34 && b2 != 92 && (b2 & 0xFF) > 32) continue;
            quote = true;
            if (b2 != 34 && b2 != 92) continue;
            escape = true;
        }
        if (quote) {
            os.write(34);
        }
        if (escape) {
            for (i2 = 0; i2 < len; ++i2) {
                b2 = bytes[i2];
                if (b2 == 34 || b2 == 92) {
                    os.write(92);
                }
                os.write(b2);
            }
        } else {
            os.write(bytes);
        }
        if (quote) {
            os.write(34);
        }
    }

    private void literal(byte[] b2, Protocol protocol) throws IOException, ProtocolException {
        this.startLiteral(protocol, b2.length).write(b2);
    }

    private void literal(ByteArrayOutputStream b2, Protocol protocol) throws IOException, ProtocolException {
        b2.writeTo(this.startLiteral(protocol, b2.size()));
    }

    private void literal(Literal b2, Protocol protocol) throws IOException, ProtocolException {
        b2.writeTo(this.startLiteral(protocol, b2.size()));
    }

    private OutputStream startLiteral(Protocol protocol, int size) throws IOException, ProtocolException {
        DataOutputStream os = (DataOutputStream)protocol.getOutputStream();
        boolean nonSync = protocol.supportsNonSyncLiterals();
        os.write(123);
        os.writeBytes(Integer.toString(size));
        if (nonSync) {
            os.writeBytes("+}\r\n");
        } else {
            os.writeBytes("}\r\n");
        }
        os.flush();
        if (!nonSync) {
            Response r;
            while (!(r = protocol.readResponse()).isContinuation()) {
                if (!r.isTagged()) continue;
                throw new LiteralException(r);
            }
        }
        return os;
    }
}

