/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.Vector;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.FolderEvent;
import javax.mail.event.FolderListener;
import javax.mail.event.StoreEvent;
import javax.mail.event.StoreListener;

public abstract class Store
extends Service {
    private volatile Vector storeListeners = null;
    private volatile Vector folderListeners = null;

    protected Store(Session session, URLName urlname) {
        super(session, urlname);
    }

    public abstract Folder getDefaultFolder() throws MessagingException;

    public abstract Folder getFolder(String var1) throws MessagingException;

    public abstract Folder getFolder(URLName var1) throws MessagingException;

    public Folder[] getPersonalNamespaces() throws MessagingException {
        return new Folder[]{this.getDefaultFolder()};
    }

    public Folder[] getUserNamespaces(String user) throws MessagingException {
        return new Folder[0];
    }

    public Folder[] getSharedNamespaces() throws MessagingException {
        return new Folder[0];
    }

    public synchronized void addStoreListener(StoreListener l2) {
        if (this.storeListeners == null) {
            this.storeListeners = new Vector();
        }
        this.storeListeners.addElement(l2);
    }

    public synchronized void removeStoreListener(StoreListener l2) {
        if (this.storeListeners != null) {
            this.storeListeners.removeElement(l2);
        }
    }

    protected void notifyStoreListeners(int type, String message) {
        if (this.storeListeners == null) {
            return;
        }
        StoreEvent e2 = new StoreEvent(this, type, message);
        this.queueEvent(e2, this.storeListeners);
    }

    public synchronized void addFolderListener(FolderListener l2) {
        if (this.folderListeners == null) {
            this.folderListeners = new Vector();
        }
        this.folderListeners.addElement(l2);
    }

    public synchronized void removeFolderListener(FolderListener l2) {
        if (this.folderListeners != null) {
            this.folderListeners.removeElement(l2);
        }
    }

    protected void notifyFolderListeners(int type, Folder folder) {
        if (this.folderListeners == null) {
            return;
        }
        FolderEvent e2 = new FolderEvent(this, folder, type);
        this.queueEvent(e2, this.folderListeners);
    }

    protected void notifyFolderRenamedListeners(Folder oldF, Folder newF) {
        if (this.folderListeners == null) {
            return;
        }
        FolderEvent e2 = new FolderEvent(this, oldF, newF, 3);
        this.queueEvent(e2, this.folderListeners);
    }
}

