/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.BoundaryPushbackInputStream;

public class MIMEBodyPartInputStream
extends InputStream {
    BoundaryPushbackInputStream bpis;
    PushbackInputStream inStream;
    Attachments parent = null;
    boolean done = false;

    public MIMEBodyPartInputStream(PushbackInputStream inStream, byte[] boundary) {
        this(inStream, boundary, null, boundary.length + 2);
    }

    public MIMEBodyPartInputStream(PushbackInputStream inStream, byte[] boundary, Attachments parent) {
        this(inStream, boundary, parent, boundary.length + 2);
    }

    public MIMEBodyPartInputStream(PushbackInputStream inStream, byte[] boundary, Attachments parent, int pushbacksize) {
        this.bpis = new BoundaryPushbackInputStream(inStream, boundary, pushbacksize);
        this.inStream = inStream;
        this.parent = parent;
    }

    public int read() throws IOException {
        if (this.done) {
            return -1;
        }
        int rc = this.bpis.read();
        if (this.getBoundaryStatus()) {
            this.finish();
        }
        return rc;
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.done) {
            return -1;
        }
        int rc = this.bpis.read(b2, off, len);
        if (this.getBoundaryStatus()) {
            this.finish();
        }
        return rc;
    }

    public int read(byte[] b2) throws IOException {
        if (this.done) {
            return -1;
        }
        int rc = this.bpis.read(b2);
        if (this.getBoundaryStatus()) {
            this.finish();
        }
        return rc;
    }

    private void finish() throws IOException {
        if (!this.done) {
            int two;
            int one = this.inStream.read();
            if (one != -1) {
                two = this.inStream.read();
                if (two != -1) {
                    if (one == 45 && two == 45) {
                        if (this.parent != null) {
                            this.parent.setEndOfStream(true);
                        }
                    } else {
                        this.inStream.unread(two);
                        this.inStream.unread(one);
                    }
                } else {
                    this.inStream.unread(one);
                }
            }
            if ((one = this.inStream.read()) != -1) {
                two = this.inStream.read();
                if (two != -1) {
                    if (one != 13 || two != 10) {
                        this.inStream.unread(two);
                        this.inStream.unread(one);
                    }
                } else {
                    this.inStream.unread(one);
                }
            }
        }
        this.done = true;
    }

    public boolean getBoundaryStatus() {
        return this.bpis.getBoundaryStatus();
    }
}

