/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.serialize;

import java.net.URLDecoder;
import java.util.ArrayList;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMSerializer;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.util.OMSerializerUtil;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamingOMSerializer
implements XMLStreamConstants,
OMSerializer {
    Log log = LogFactory.getLog(class$org$apache$axiom$om$impl$serialize$StreamingOMSerializer == null ? (class$org$apache$axiom$om$impl$serialize$StreamingOMSerializer = StreamingOMSerializer.class$("org.apache.axiom.om.impl.serialize.StreamingOMSerializer")) : class$org$apache$axiom$om$impl$serialize$StreamingOMSerializer);
    private static int namespaceSuffix = 0;
    public static final String NAMESPACE_PREFIX = "ns";
    private int depth = 0;
    public static final QName XOP_INCLUDE = new QName("http://www.w3.org/2004/08/xop/include", "Include");
    private boolean inputHasAttachments = false;
    private boolean skipEndElement = false;
    static /* synthetic */ Class class$org$apache$axiom$om$impl$serialize$StreamingOMSerializer;

    public void serialize(XMLStreamReader node, XMLStreamWriter writer) throws XMLStreamException {
        this.serialize(node, writer, true);
    }

    public void serialize(XMLStreamReader node, XMLStreamWriter writer, boolean startAtNext) throws XMLStreamException {
        if (node instanceof OMAttachmentAccessor) {
            this.inputHasAttachments = true;
        }
        this.serializeNode(node, writer, startAtNext);
    }

    protected void serializeNode(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        this.serializeNode(reader, writer, true);
    }

    protected void serializeNode(XMLStreamReader reader, XMLStreamWriter writer, boolean startAtNext) throws XMLStreamException {
        boolean useCurrentEvent;
        boolean bl = useCurrentEvent = !startAtNext;
        while (reader.hasNext() || useCurrentEvent) {
            int event = 0;
            if (useCurrentEvent) {
                event = reader.getEventType();
                useCurrentEvent = false;
            } else {
                event = reader.next();
            }
            if (event == 1) {
                this.serializeElement(reader, writer);
                ++this.depth;
            } else if (event == 10) {
                this.serializeAttributes(reader, writer);
            } else if (event == 4) {
                this.serializeText(reader, writer);
            } else if (event == 5) {
                this.serializeComment(reader, writer);
            } else if (event == 12) {
                this.serializeCData(reader, writer);
            } else if (event == 2) {
                this.serializeEndElement(writer);
                --this.depth;
            } else if (event == 7) {
                ++this.depth;
            } else if (event == 8) {
                if (this.depth != 0) {
                    --this.depth;
                }
                try {
                    this.serializeEndElement(writer);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            if (this.depth != 0) continue;
            break;
        }
    }

    protected void serializeElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        String namespace;
        String prefix;
        int i2;
        boolean setPrefixFirst;
        ArrayList<String> writePrefixList = null;
        ArrayList<String> writeNSList = null;
        String ePrefix = reader.getPrefix();
        ePrefix = ePrefix != null && ePrefix.length() == 0 ? null : ePrefix;
        String eNamespace = reader.getNamespaceURI();
        String string = eNamespace = eNamespace != null && eNamespace.length() == 0 ? null : eNamespace;
        if (this.inputHasAttachments && XOP_INCLUDE.getNamespaceURI().equals(eNamespace)) {
            String eLocalPart = reader.getLocalName();
            if (XOP_INCLUDE.getLocalPart().equals(eLocalPart) && this.serializeXOPInclude(reader, writer)) {
                this.skipEndElement = true;
                return;
            }
        }
        if (!(setPrefixFirst = OMSerializerUtil.isSetPrefixBeforeStartElement(writer))) {
            if (eNamespace != null) {
                if (ePrefix == null) {
                    if (!OMSerializerUtil.isAssociated("", eNamespace, writer)) {
                        if (writePrefixList == null) {
                            writePrefixList = new ArrayList<String>();
                            writeNSList = new ArrayList<String>();
                        }
                        writePrefixList.add("");
                        writeNSList.add(eNamespace);
                    }
                    writer.writeStartElement("", reader.getLocalName(), eNamespace);
                } else {
                    if (!OMSerializerUtil.isAssociated(ePrefix, eNamespace, writer)) {
                        if (writePrefixList == null) {
                            writePrefixList = new ArrayList();
                            writeNSList = new ArrayList();
                        }
                        writePrefixList.add(ePrefix);
                        writeNSList.add(eNamespace);
                    }
                    writer.writeStartElement(ePrefix, reader.getLocalName(), eNamespace);
                }
            } else {
                writer.writeStartElement(reader.getLocalName());
            }
        }
        int count = reader.getNamespaceCount();
        for (int i3 = 0; i3 < count; ++i3) {
            String prefix2 = reader.getNamespacePrefix(i3);
            prefix2 = prefix2 != null && prefix2.length() == 0 ? null : prefix2;
            String namespace2 = reader.getNamespaceURI(i3);
            String newPrefix = OMSerializerUtil.generateSetPrefix(prefix2, namespace2 = namespace2 != null && namespace2.length() == 0 ? null : namespace2, writer, false, setPrefixFirst);
            if (newPrefix == null) continue;
            if (writePrefixList == null) {
                writePrefixList = new ArrayList();
                writeNSList = new ArrayList();
            }
            if (writePrefixList.contains(newPrefix)) continue;
            writePrefixList.add(newPrefix);
            writeNSList.add(namespace2);
        }
        String newPrefix = OMSerializerUtil.generateSetPrefix(ePrefix, eNamespace, writer, false, setPrefixFirst);
        if (newPrefix != null) {
            if (writePrefixList == null) {
                writePrefixList = new ArrayList();
                writeNSList = new ArrayList();
            }
            if (!writePrefixList.contains(newPrefix)) {
                writePrefixList.add(newPrefix);
                writeNSList.add(eNamespace);
            }
        }
        count = reader.getAttributeCount();
        for (i2 = 0; i2 < count; ++i2) {
            prefix = reader.getAttributePrefix(i2);
            prefix = prefix != null && prefix.length() == 0 ? null : prefix;
            namespace = reader.getAttributeNamespace(i2);
            String string2 = namespace = namespace != null && namespace.length() == 0 ? null : namespace;
            if (prefix == null && namespace != null) {
                String writerPrefix = writer.getPrefix(namespace);
                writerPrefix = writerPrefix != null && writerPrefix.length() == 0 ? null : writerPrefix;
                String string3 = prefix = writerPrefix != null ? writerPrefix : this.generateUniquePrefix(writer.getNamespaceContext());
            }
            if ((newPrefix = OMSerializerUtil.generateSetPrefix(prefix, namespace, writer, true, setPrefixFirst)) == null) continue;
            if (writePrefixList == null) {
                writePrefixList = new ArrayList();
                writeNSList = new ArrayList();
            }
            if (writePrefixList.contains(newPrefix)) continue;
            writePrefixList.add(newPrefix);
            writeNSList.add(namespace);
        }
        if (setPrefixFirst) {
            if (eNamespace != null) {
                if (ePrefix == null) {
                    writer.writeStartElement("", reader.getLocalName(), eNamespace);
                } else {
                    writer.writeStartElement(ePrefix, reader.getLocalName(), eNamespace);
                }
            } else {
                writer.writeStartElement(reader.getLocalName());
            }
        }
        if (writePrefixList != null) {
            for (i2 = 0; i2 < writePrefixList.size(); ++i2) {
                prefix = (String)writePrefixList.get(i2);
                namespace = (String)writeNSList.get(i2);
                if (prefix != null) {
                    if (namespace == null) {
                        writer.writeNamespace(prefix, "");
                        continue;
                    }
                    writer.writeNamespace(prefix, namespace);
                    continue;
                }
                writer.writeDefaultNamespace(namespace);
            }
        }
        count = reader.getAttributeCount();
        for (i2 = 0; i2 < count; ++i2) {
            String writerPrefix;
            prefix = reader.getAttributePrefix(i2);
            prefix = prefix != null && prefix.length() == 0 ? null : prefix;
            namespace = reader.getAttributeNamespace(i2);
            String string4 = namespace = namespace != null && namespace.length() == 0 ? null : namespace;
            if (prefix == null && namespace != null) {
                prefix = writer.getPrefix(namespace);
                if (prefix == null || "".equals(prefix)) {
                    for (int j2 = 0; j2 < writePrefixList.size(); ++j2) {
                        if (!namespace.equals((String)writeNSList.get(j2))) continue;
                        prefix = (String)writePrefixList.get(j2);
                    }
                }
            } else if (namespace != null && !prefix.equals(writerPrefix = writer.getPrefix(namespace)) && !"".equals(writerPrefix)) {
                prefix = writerPrefix;
            }
            if (namespace != null) {
                writer.writeAttribute(prefix, namespace, reader.getAttributeLocalName(i2), reader.getAttributeValue(i2));
                continue;
            }
            writer.writeAttribute(reader.getAttributeLocalName(i2), reader.getAttributeValue(i2));
        }
    }

    protected void serializeEndElement(XMLStreamWriter writer) throws XMLStreamException {
        if (this.skipEndElement) {
            this.skipEndElement = false;
            return;
        }
        writer.writeEndElement();
    }

    protected void serializeText(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(reader.getText());
    }

    protected void serializeCData(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCData(reader.getText());
    }

    protected void serializeComment(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeComment(reader.getText());
    }

    protected void serializeAttributes(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String prefix = null;
        String namespaceName = null;
        String writerPrefix = null;
        for (int i2 = 0; i2 < count; ++i2) {
            prefix = reader.getAttributePrefix(i2);
            namespaceName = reader.getAttributeNamespace(i2);
            namespaceName = namespaceName == null ? "" : namespaceName;
            writerPrefix = writer.getPrefix(namespaceName);
            if (!"".equals(namespaceName)) {
                if (writerPrefix != null && (prefix == null || prefix.equals(""))) {
                    writer.writeAttribute(writerPrefix, namespaceName, reader.getAttributeLocalName(i2), reader.getAttributeValue(i2));
                    continue;
                }
                if (prefix != null && !"".equals(prefix) && !prefix.equals(writerPrefix)) {
                    writer.writeNamespace(prefix, namespaceName);
                    writer.writeAttribute(prefix, namespaceName, reader.getAttributeLocalName(i2), reader.getAttributeValue(i2));
                    continue;
                }
                prefix = this.generateUniquePrefix(writer.getNamespaceContext());
                writer.writeNamespace(prefix, namespaceName);
                writer.writeAttribute(prefix, namespaceName, reader.getAttributeLocalName(i2), reader.getAttributeValue(i2));
                continue;
            }
            writer.writeAttribute(reader.getAttributeLocalName(i2), reader.getAttributeValue(i2));
        }
    }

    private String generateUniquePrefix(NamespaceContext nsCtxt) {
        String prefix = NAMESPACE_PREFIX + namespaceSuffix++;
        while (nsCtxt.getNamespaceURI(prefix) != null) {
            prefix = NAMESPACE_PREFIX + namespaceSuffix++;
        }
        return prefix;
    }

    private void serializeNamespace(String prefix, String URI2, XMLStreamWriter writer) throws XMLStreamException {
        String prefix1 = writer.getPrefix(URI2);
        if (prefix1 == null) {
            writer.writeNamespace(prefix, URI2);
            writer.setPrefix(prefix, URI2);
        }
    }

    protected boolean serializeXOPInclude(XMLStreamReader reader, XMLStreamWriter writer) {
        MTOMXMLStreamWriter mtomWriter;
        String cid = ElementHelper.getContentID(reader);
        DataHandler dh = this.getDataHandler(cid, (OMAttachmentAccessor)((Object)reader));
        if (dh == null) {
            return false;
        }
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMText omText = omFactory.createOMText(dh, true);
        omText.setContentID(cid);
        MTOMXMLStreamWriter mTOMXMLStreamWriter = mtomWriter = writer instanceof MTOMXMLStreamWriter ? (MTOMXMLStreamWriter)writer : null;
        if (mtomWriter != null && mtomWriter.isOptimized() && mtomWriter.isOptimizedThreshold(omText)) {
            mtomWriter.writeOptimized(omText);
            return false;
        }
        omText.setOptimize(false);
        try {
            writer.writeCharacters(omText.getText());
            return true;
        }
        catch (XMLStreamException e2) {
            return false;
        }
    }

    private DataHandler getDataHandler(String cid, OMAttachmentAccessor oaa) {
        DataHandler dh = null;
        String blobcid = cid;
        if (blobcid.startsWith("cid:")) {
            blobcid = blobcid.substring(4);
        }
        if (oaa != null) {
            dh = oaa.getDataHandler(blobcid);
        }
        if (dh == null) {
            blobcid = this.getNewCID(cid);
            if (blobcid.startsWith("cid:")) {
                blobcid = blobcid.substring(4);
            }
            if (oaa != null) {
                dh = oaa.getDataHandler(blobcid);
            }
        }
        return dh;
    }

    private String getNewCID(String cid) {
        String cid2;
        block2: {
            cid2 = cid;
            try {
                cid2 = URLDecoder.decode(cid, "UTF-8");
            }
            catch (Exception e2) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug("getNewCID decoding " + cid + " as UTF-8 decoding error: " + e2);
            }
        }
        return cid2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

