/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import org.eclipse.jetty.client.AbstractHttpConnection;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AsyncHttpConnection
extends AbstractHttpConnection
implements AsyncConnection {
    private static final Logger LOG = Log.getLogger(AsyncHttpConnection.class);
    private boolean _requestComplete;
    private Buffer _requestContentChunk;
    private final AsyncEndPoint _asyncEndp;

    AsyncHttpConnection(Buffers requestBuffers, Buffers responseBuffers, EndPoint endp) {
        super(requestBuffers, responseBuffers, endp);
        this._asyncEndp = (AsyncEndPoint)endp;
    }

    @Override
    protected void reset() throws IOException {
        this._requestComplete = false;
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection handle() throws IOException {
        Connection connection = this;
        boolean progress = true;
        try {
            boolean failed = false;
            while (progress && connection == this) {
                Connection switched;
                AsyncHttpConnection asyncHttpConnection;
                boolean complete;
                HttpExchange exchange;
                block62: {
                    LOG.debug("while open={} more={} progress={}", this._endp.isOpen(), this._parser.isMoreInBuffer(), progress);
                    progress = false;
                    exchange = this._exchange;
                    LOG.debug("exchange {} on {}", exchange, this);
                    try {
                        if (!this._generator.isCommitted() && exchange != null && exchange.getStatus() == 2) {
                            LOG.debug("commit {}", exchange);
                            progress = true;
                            this.commitRequest();
                        }
                        if (this._generator.isCommitted() && !this._generator.isComplete()) {
                            if (this._generator.flushBuffer() > 0) {
                                LOG.debug("flushed", new Object[0]);
                                progress = true;
                            }
                            if (this._generator.isState(2)) {
                                if (this._requestContentChunk == null) {
                                    this._requestContentChunk = exchange.getRequestContentChunk(null);
                                }
                                if (this._requestContentChunk == null) {
                                    LOG.debug("complete {}", exchange);
                                    progress = true;
                                    this._generator.complete();
                                    if (exchange.getStatus() < 4) {
                                        exchange.setStatus(4);
                                    }
                                } else if (this._generator.isEmpty()) {
                                    LOG.debug("addChunk", new Object[0]);
                                    progress = true;
                                    Buffer chunk = this._requestContentChunk;
                                    this._requestContentChunk = exchange.getRequestContentChunk(null);
                                    this._generator.addContent(chunk, this._requestContentChunk == null);
                                    if (this._requestContentChunk == null) {
                                        exchange.setStatus(4);
                                    }
                                }
                            }
                        }
                        if (this._generator.isComplete() && !this._requestComplete) {
                            LOG.debug("requestComplete {}", exchange);
                            progress = true;
                            this._requestComplete = true;
                            exchange.getEventListener().onRequestComplete();
                        }
                        if (!this._parser.isComplete() && this._parser.parseAvailable()) {
                            LOG.debug("parsed {}", exchange);
                            progress = true;
                        }
                        this._endp.flush();
                        if (!this._asyncEndp.hasProgressed()) break block62;
                        LOG.debug("hasProgressed {}", exchange);
                        progress = true;
                    }
                    catch (Throwable e2) {
                        try {
                            LOG.debug("Failure on " + this._exchange, e2);
                            failed = true;
                            AsyncHttpConnection persistent = this;
                            synchronized (persistent) {
                                if (exchange != null) {
                                    if (exchange.getStatus() != 10 && exchange.getStatus() != 11 && !exchange.isDone() && exchange.setStatus(9)) {
                                        exchange.getEventListener().onException(e2);
                                    }
                                } else {
                                    if (e2 instanceof IOException) {
                                        throw (IOException)e2;
                                    }
                                    if (e2 instanceof Error) {
                                        throw (Error)e2;
                                    }
                                    if (e2 instanceof RuntimeException) {
                                        throw (RuntimeException)e2;
                                    }
                                    throw new RuntimeException(e2);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            boolean complete2;
                            LOG.debug("finally {} on {} progress={} {}", exchange, this, progress, this._endp);
                            boolean bl = complete2 = failed || this._generator.isComplete() && this._parser.isComplete();
                            if (complete2) {
                                boolean persistent = !failed && this._parser.isPersistent() && this._generator.isPersistent();
                                this._generator.setPersistent(persistent);
                                this.reset();
                                if (persistent) {
                                    this._endp.setMaxIdleTime((int)this._destination.getHttpClient().getIdleTimeout());
                                }
                                AsyncHttpConnection asyncHttpConnection2 = this;
                                synchronized (asyncHttpConnection2) {
                                    Connection switched2;
                                    exchange = this._exchange;
                                    this._exchange = null;
                                    if (exchange != null) {
                                        exchange.cancelTimeout(this._destination.getHttpClient());
                                    }
                                    if (this._status == 101 && (switched2 = exchange.onSwitchProtocol(this._endp)) != null) {
                                        if (this._pipeline != null) {
                                            this._destination.send(this._pipeline);
                                        }
                                        this._pipeline = null;
                                        connection = switched2;
                                    }
                                    if (this._pipeline != null) {
                                        if (!persistent || connection != this) {
                                            this._destination.send(this._pipeline);
                                        } else {
                                            this._exchange = this._pipeline;
                                        }
                                        this._pipeline = null;
                                    }
                                    if (this._exchange == null && !this.isReserved()) {
                                        this._destination.returnConnection(this, !persistent);
                                    }
                                }
                            }
                            throw throwable;
                        }
                        LOG.debug("finally {} on {} progress={} {}", exchange, this, progress, this._endp);
                        complete = failed || this._generator.isComplete() && this._parser.isComplete();
                        if (!complete) continue;
                        boolean persistent = !failed && this._parser.isPersistent() && this._generator.isPersistent();
                        this._generator.setPersistent(persistent);
                        this.reset();
                        if (persistent) {
                            this._endp.setMaxIdleTime((int)this._destination.getHttpClient().getIdleTimeout());
                        }
                        asyncHttpConnection = this;
                        synchronized (asyncHttpConnection) {
                            exchange = this._exchange;
                            this._exchange = null;
                            if (exchange != null) {
                                exchange.cancelTimeout(this._destination.getHttpClient());
                            }
                            if (this._status == 101 && (switched = exchange.onSwitchProtocol(this._endp)) != null) {
                                if (this._pipeline != null) {
                                    this._destination.send(this._pipeline);
                                }
                                this._pipeline = null;
                                connection = switched;
                            }
                            if (this._pipeline != null) {
                                if (!persistent || connection != this) {
                                    this._destination.send(this._pipeline);
                                } else {
                                    this._exchange = this._pipeline;
                                }
                                this._pipeline = null;
                            }
                            if (this._exchange == null && !this.isReserved()) {
                                this._destination.returnConnection(this, !persistent);
                            }
                            continue;
                        }
                    }
                }
                LOG.debug("finally {} on {} progress={} {}", exchange, this, progress, this._endp);
                complete = failed || this._generator.isComplete() && this._parser.isComplete();
                if (!complete) continue;
                boolean persistent = !failed && this._parser.isPersistent() && this._generator.isPersistent();
                this._generator.setPersistent(persistent);
                this.reset();
                if (persistent) {
                    this._endp.setMaxIdleTime((int)this._destination.getHttpClient().getIdleTimeout());
                }
                asyncHttpConnection = this;
                synchronized (asyncHttpConnection) {
                    exchange = this._exchange;
                    this._exchange = null;
                    if (exchange != null) {
                        exchange.cancelTimeout(this._destination.getHttpClient());
                    }
                    if (this._status == 101 && (switched = exchange.onSwitchProtocol(this._endp)) != null) {
                        if (this._pipeline != null) {
                            this._destination.send(this._pipeline);
                        }
                        this._pipeline = null;
                        connection = switched;
                    }
                    if (this._pipeline != null) {
                        if (!persistent || connection != this) {
                            this._destination.send(this._pipeline);
                        } else {
                            this._exchange = this._pipeline;
                        }
                        this._pipeline = null;
                    }
                    if (this._exchange == null && !this.isReserved()) {
                        this._destination.returnConnection(this, !persistent);
                    }
                }
            }
            this._parser.returnBuffers();
        }
        catch (Throwable throwable) {
            this._parser.returnBuffers();
            this._generator.returnBuffers();
            LOG.debug("unhandle {} on {}", this._exchange, this._endp);
            throw throwable;
        }
        this._generator.returnBuffers();
        LOG.debug("unhandle {} on {}", this._exchange, this._endp);
        return connection;
    }

    @Override
    public void onInputShutdown() throws IOException {
        if (this._generator.isIdle()) {
            this._endp.shutdownOutput();
        }
    }

    @Override
    public boolean send(HttpExchange ex) throws IOException {
        boolean sent = super.send(ex);
        if (sent) {
            this._asyncEndp.asyncDispatch();
        }
        return sent;
    }
}

