/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.gzip;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.gzip.CompressedResponseWrapper;
import org.eclipse.jetty.util.ByteArrayOutputStream2;

public abstract class AbstractCompressedStream
extends ServletOutputStream {
    private final String _encoding;
    protected final String _vary;
    protected final CompressedResponseWrapper _wrapper;
    protected final HttpServletResponse _response;
    protected OutputStream _out;
    protected ByteArrayOutputStream2 _bOut;
    protected DeflaterOutputStream _compressedOutputStream;
    protected boolean _closed;
    protected boolean _doNotCompress;

    public AbstractCompressedStream(String encoding, HttpServletRequest request, CompressedResponseWrapper wrapper, String vary) throws IOException {
        this._encoding = encoding;
        this._wrapper = wrapper;
        this._response = (HttpServletResponse)wrapper.getResponse();
        this._vary = vary;
        if (this._wrapper.getMinCompressSize() == 0) {
            this.doCompress();
        }
    }

    public void resetBuffer() {
        if (this._response.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        this._closed = false;
        this._out = null;
        this._bOut = null;
        if (this._compressedOutputStream != null) {
            this._response.setHeader("Content-Encoding", null);
        }
        this._compressedOutputStream = null;
        this._doNotCompress = false;
    }

    public void setContentLength() {
        long length;
        if (this._doNotCompress && (length = this._wrapper.getContentLength()) >= 0L) {
            if (length < Integer.MAX_VALUE) {
                this._response.setContentLength((int)length);
            } else {
                this._response.setHeader("Content-Length", Long.toString(length));
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this._out == null || this._bOut != null) {
            long length = this._wrapper.getContentLength();
            if (length > 0L && length < (long)this._wrapper.getMinCompressSize()) {
                this.doNotCompress(false);
            } else {
                this.doCompress();
            }
        }
        this._out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this._closed) {
            return;
        }
        if (this._wrapper.getRequest().getAttribute("javax.servlet.include.request_uri") != null) {
            this.flush();
        } else {
            if (this._bOut != null) {
                long length = this._wrapper.getContentLength();
                if (length < 0L) {
                    length = this._bOut.getCount();
                    this._wrapper.setContentLength(length);
                }
                if (length < (long)this._wrapper.getMinCompressSize()) {
                    this.doNotCompress(false);
                } else {
                    this.doCompress();
                }
            } else if (this._out == null) {
                this.doNotCompress(false);
            }
            if (this._compressedOutputStream != null) {
                this._compressedOutputStream.close();
            } else {
                this._out.close();
            }
            this._closed = true;
        }
    }

    public void finish() throws IOException {
        if (!this._closed) {
            if (this._out == null || this._bOut != null) {
                long length = this._wrapper.getContentLength();
                if (length > 0L && length < (long)this._wrapper.getMinCompressSize()) {
                    this.doNotCompress(false);
                } else {
                    this.doCompress();
                }
            }
            if (this._compressedOutputStream != null && !this._closed) {
                this._closed = true;
                this._compressedOutputStream.close();
            }
        }
    }

    @Override
    public void write(int b2) throws IOException {
        this.checkOut(1);
        this._out.write(b2);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.checkOut(b2.length);
        this._out.write(b2);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        this.checkOut(len);
        this._out.write(b2, off, len);
    }

    public void doCompress() throws IOException {
        if (this._compressedOutputStream == null) {
            if (this._response.isCommitted()) {
                throw new IllegalStateException();
            }
            if (this._encoding != null) {
                this.setHeader("Content-Encoding", this._encoding);
                if (this._response.containsHeader("Content-Encoding")) {
                    this.setHeader("Vary", this._vary);
                    this._compressedOutputStream = this.createStream();
                    this._out = this._compressedOutputStream;
                    if (this._out != null) {
                        String etag;
                        if (this._bOut != null) {
                            this._out.write(this._bOut.getBuf(), 0, this._bOut.getCount());
                            this._bOut = null;
                        }
                        if ((etag = this._wrapper.getETag()) != null) {
                            this.setHeader("ETag", etag.substring(0, etag.length() - 1) + '-' + this._encoding + '\"');
                        }
                        return;
                    }
                }
            }
            this.doNotCompress(true);
        }
    }

    public void doNotCompress(boolean sendVary) throws IOException {
        if (this._compressedOutputStream != null) {
            throw new IllegalStateException("Compressed output stream is already assigned.");
        }
        if (this._out == null || this._bOut != null) {
            if (sendVary) {
                this.setHeader("Vary", this._vary);
            }
            if (this._wrapper.getETag() != null) {
                this.setHeader("ETag", this._wrapper.getETag());
            }
            this._doNotCompress = true;
            this._out = this._response.getOutputStream();
            this.setContentLength();
            if (this._bOut != null) {
                this._out.write(this._bOut.getBuf(), 0, this._bOut.getCount());
            }
            this._bOut = null;
        }
    }

    private void checkOut(int lengthToWrite) throws IOException {
        if (this._closed) {
            throw new IOException("CLOSED");
        }
        if (this._out == null) {
            long length = this._wrapper.getContentLength();
            if (this._response.isCommitted() || length >= 0L && length < (long)this._wrapper.getMinCompressSize()) {
                this.doNotCompress(false);
            } else if (lengthToWrite > this._wrapper.getMinCompressSize()) {
                this.doCompress();
            } else {
                this._bOut = new ByteArrayOutputStream2(this._wrapper.getBufferSize());
                this._out = this._bOut;
            }
        } else if (this._bOut != null) {
            long length = this._wrapper.getContentLength();
            if (this._response.isCommitted() || length >= 0L && length < (long)this._wrapper.getMinCompressSize()) {
                this.doNotCompress(false);
            } else if (lengthToWrite >= this._bOut.getBuf().length - this._bOut.getCount()) {
                this.doCompress();
            }
        }
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public boolean isClosed() {
        return this._closed;
    }

    protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        return encoding == null ? new PrintWriter(out) : new PrintWriter(new OutputStreamWriter(out, encoding));
    }

    protected void setHeader(String name, String value) {
        this._response.setHeader(name, value);
    }

    protected abstract DeflaterOutputStream createStream() throws IOException;
}

