/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBean;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ObjectMBean
implements DynamicMBean {
    private static final Logger LOG = Log.getLogger(ObjectMBean.class);
    private static Class[] OBJ_ARG = new Class[]{Object.class};
    protected Object _managed;
    private MBeanInfo _info;
    private Map _getters = new HashMap();
    private Map _setters = new HashMap();
    private Map _methods = new HashMap();
    private Set _convert = new HashSet();
    private ClassLoader _loader;
    private MBeanContainer _mbeanContainer;
    private static String OBJECT_NAME_CLASS = ObjectName.class.getName();
    private static String OBJECT_NAME_ARRAY_CLASS = ObjectName[].class.getName();

    public static Object mbeanFor(Object o2) {
        try {
            Object mbean = null;
            for (Class<Object> oClass = o2.getClass(); mbean == null && oClass != null; oClass = oClass.getSuperclass()) {
                String pName = oClass.getPackage().getName();
                String cName = oClass.getName().substring(pName.length() + 1);
                String mName = pName + ".jmx." + cName + "MBean";
                try {
                    block12: {
                        Class<Object> mClass;
                        Class<Object> clazz = mClass = Object.class.equals(oClass) ? (oClass = ObjectMBean.class) : Loader.loadClass(oClass, mName, true);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("mbeanFor " + o2 + " mClass=" + mClass, new Object[0]);
                        }
                        try {
                            Constructor constructor = mClass.getConstructor(OBJ_ARG);
                            mbean = constructor.newInstance(o2);
                        }
                        catch (Exception e2) {
                            LOG.ignore(e2);
                            if (!ModelMBean.class.isAssignableFrom(mClass)) break block12;
                            mbean = mClass.newInstance();
                            ((ModelMBean)mbean).setManagedResource(o2, "objectReference");
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("mbeanFor " + o2 + " is " + mbean, new Object[0]);
                    }
                    return mbean;
                }
                catch (ClassNotFoundException e3) {
                    if (e3.getMessage().contains(mName)) {
                        LOG.ignore(e3);
                        continue;
                    }
                    LOG.warn(e3);
                    continue;
                }
                catch (Error e4) {
                    LOG.warn(e4);
                    mbean = null;
                    continue;
                }
                catch (Exception e5) {
                    LOG.warn(e5);
                    mbean = null;
                }
            }
        }
        catch (Exception e6) {
            LOG.ignore(e6);
        }
        return null;
    }

    public ObjectMBean(Object managedObject) {
        this._managed = managedObject;
        this._loader = Thread.currentThread().getContextClassLoader();
    }

    public Object getManagedObject() {
        return this._managed;
    }

    public ObjectName getObjectName() {
        return null;
    }

    public String getObjectContextBasis() {
        return null;
    }

    public String getObjectNameBasis() {
        return null;
    }

    protected void setMBeanContainer(MBeanContainer container) {
        this._mbeanContainer = container;
    }

    public MBeanContainer getMBeanContainer() {
        return this._mbeanContainer;
    }

    public MBeanInfo getMBeanInfo() {
        try {
            if (this._info == null) {
                String desc = null;
                Object attributes = null;
                Object constructors = null;
                Object operations = null;
                Object notifications = null;
                Class<?> o_class = this._managed.getClass();
                Object influences = ObjectMBean.findInfluences(null, this._managed.getClass());
                HashSet<String> defined = new HashSet<String>();
                for (int i2 = 0; i2 < LazyList.size(influences); ++i2) {
                    Class<ObjectMBean> oClass = (Class<ObjectMBean>)LazyList.get(influences, i2);
                    if (Object.class.equals((Object)oClass)) {
                        oClass = ObjectMBean.class;
                    }
                    String pName = oClass.getPackage().getName();
                    String cName = oClass.getName().substring(pName.length() + 1);
                    String rName = pName.replace('.', '/') + "/jmx/" + cName + "-mbean";
                    try {
                        LOG.debug(rName, new Object[0]);
                        ResourceBundle bundle = Loader.getResourceBundle(o_class, rName, true, Locale.getDefault());
                        Enumeration<String> e2 = bundle.getKeys();
                        while (e2.hasMoreElements()) {
                            String key = e2.nextElement();
                            String value = bundle.getString(key);
                            if (key.equals(cName)) {
                                if (desc != null) continue;
                                desc = value;
                                continue;
                            }
                            if (key.indexOf(40) > 0) {
                                if (defined.contains(key) || key.indexOf(91) >= 0) continue;
                                defined.add(key);
                                operations = LazyList.add(operations, this.defineOperation(key, value, bundle));
                                continue;
                            }
                            if (defined.contains(key)) continue;
                            defined.add(key);
                            MBeanAttributeInfo info = this.defineAttribute(key, value);
                            if (info == null) continue;
                            attributes = LazyList.add(attributes, info);
                        }
                        continue;
                    }
                    catch (MissingResourceException e3) {
                        LOG.ignore(e3);
                    }
                }
                this._info = new MBeanInfo(o_class.getName(), desc, (MBeanAttributeInfo[])LazyList.toArray(attributes, MBeanAttributeInfo.class), (MBeanConstructorInfo[])LazyList.toArray(constructors, MBeanConstructorInfo.class), (MBeanOperationInfo[])LazyList.toArray(operations, MBeanOperationInfo.class), (MBeanNotificationInfo[])LazyList.toArray(notifications, MBeanNotificationInfo.class));
            }
        }
        catch (RuntimeException e4) {
            LOG.warn(e4);
            throw e4;
        }
        return this._info;
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Method getter = (Method)this._getters.get(name);
        if (getter == null) {
            throw new AttributeNotFoundException(name);
        }
        try {
            Object r;
            Object o2 = this._managed;
            if (getter.getDeclaringClass().isInstance(this)) {
                o2 = this;
            }
            if ((r = getter.invoke(o2, (Object[])null)) != null && this._convert.contains(name)) {
                if (r.getClass().isArray()) {
                    ObjectName[] on = new ObjectName[Array.getLength(r)];
                    for (int i2 = 0; i2 < on.length; ++i2) {
                        on[i2] = this._mbeanContainer.findMBean(Array.get(r, i2));
                    }
                    r = on;
                } else if (r instanceof Collection) {
                    Collection c2 = (Collection)r;
                    ObjectName[] on = new ObjectName[c2.size()];
                    int i3 = 0;
                    for (Object obj : c2) {
                        on[i3++] = this._mbeanContainer.findMBean(obj);
                    }
                    r = on;
                } else {
                    ObjectName mbean = this._mbeanContainer.findMBean(r);
                    if (mbean == null) {
                        return null;
                    }
                    r = mbean;
                }
            }
            return r;
        }
        catch (IllegalAccessException e2) {
            LOG.warn("EXCEPTION ", e2);
            throw new AttributeNotFoundException(e2.toString());
        }
        catch (InvocationTargetException e3) {
            LOG.warn("EXCEPTION ", e3);
            throw new ReflectionException(new Exception(e3.getCause()));
        }
    }

    public AttributeList getAttributes(String[] names) {
        AttributeList results = new AttributeList(names.length);
        for (int i2 = 0; i2 < names.length; ++i2) {
            try {
                results.add(new Attribute(names[i2], this.getAttribute(names[i2])));
                continue;
            }
            catch (Exception e2) {
                LOG.warn("EXCEPTION ", e2);
            }
        }
        return results;
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Method setter;
        if (attr == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("setAttribute " + this._managed + ":" + attr.getName() + "=" + attr.getValue(), new Object[0]);
        }
        if ((setter = (Method)this._setters.get(attr.getName())) == null) {
            throw new AttributeNotFoundException(attr.getName());
        }
        try {
            Object value;
            Object o2 = this._managed;
            if (setter.getDeclaringClass().isInstance(this)) {
                o2 = this;
            }
            if ((value = attr.getValue()) != null && this._convert.contains(attr.getName())) {
                if (value.getClass().isArray()) {
                    Class<?> t = setter.getParameterTypes()[0].getComponentType();
                    Object na = Array.newInstance(t, Array.getLength(value));
                    int i2 = Array.getLength(value);
                    while (i2-- > 0) {
                        Array.set(na, i2, this._mbeanContainer.findBean((ObjectName)Array.get(value, i2)));
                    }
                    value = na;
                } else {
                    value = this._mbeanContainer.findBean((ObjectName)value);
                }
            }
            setter.invoke(o2, value);
        }
        catch (IllegalAccessException e2) {
            LOG.warn("EXCEPTION ", e2);
            throw new AttributeNotFoundException(e2.toString());
        }
        catch (InvocationTargetException e3) {
            LOG.warn("EXCEPTION ", e3);
            throw new ReflectionException(new Exception(e3.getCause()));
        }
    }

    public AttributeList setAttributes(AttributeList attrs) {
        LOG.debug("setAttributes", new Object[0]);
        AttributeList results = new AttributeList(attrs.size());
        Iterator iter = attrs.iterator();
        while (iter.hasNext()) {
            try {
                Attribute attr = (Attribute)iter.next();
                this.setAttribute(attr);
                results.add(new Attribute(attr.getName(), this.getAttribute(attr.getName())));
            }
            catch (Exception e2) {
                LOG.warn("EXCEPTION ", e2);
            }
        }
        return results;
    }

    public Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("invoke " + name, new Object[0]);
        }
        String methodKey = name + "(";
        if (signature != null) {
            for (int i2 = 0; i2 < signature.length; ++i2) {
                methodKey = methodKey + (i2 > 0 ? "," : "") + signature[i2];
            }
        }
        methodKey = methodKey + ")";
        ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this._loader);
            Method method = (Method)this._methods.get(methodKey);
            if (method == null) {
                throw new NoSuchMethodException(methodKey);
            }
            Object o2 = this._managed;
            if (method.getDeclaringClass().isInstance(this)) {
                o2 = this;
            }
            Object object = method.invoke(o2, params);
            return object;
        }
        catch (NoSuchMethodException e2) {
            LOG.warn("EXCEPTION ", e2);
            throw new ReflectionException(e2);
        }
        catch (IllegalAccessException e3) {
            LOG.warn("EXCEPTION ", e3);
            throw new MBeanException(e3);
        }
        catch (InvocationTargetException e4) {
            LOG.warn("EXCEPTION ", e4);
            throw new ReflectionException(new Exception(e4.getCause()));
        }
        finally {
            Thread.currentThread().setContextClassLoader(old_loader);
        }
    }

    private static Object findInfluences(Object influences, Class aClass) {
        if (aClass != null) {
            influences = LazyList.add(influences, aClass);
            influences = ObjectMBean.findInfluences(influences, aClass.getSuperclass());
            Class<?>[] ifs = aClass.getInterfaces();
            for (int i2 = 0; ifs != null && i2 < ifs.length; ++i2) {
                influences = ObjectMBean.findInfluences(influences, ifs[i2]);
            }
        }
        return influences;
    }

    public MBeanAttributeInfo defineAttribute(String name, String metaData) {
        Class<?> oClass;
        String description = "";
        boolean writable = true;
        boolean onMBean = false;
        boolean convert = false;
        if (metaData != null) {
            String[] tokens = metaData.split(":", 3);
            for (int t = 0; t < tokens.length - 1; ++t) {
                tokens[t] = tokens[t].trim();
                if ("RO".equals(tokens[t])) {
                    writable = false;
                    continue;
                }
                onMBean = "MMBean".equalsIgnoreCase(tokens[t]) || "MBean".equalsIgnoreCase(tokens[t]);
                convert = "MMBean".equalsIgnoreCase(tokens[t]) || "MObject".equalsIgnoreCase(tokens[t]);
            }
            description = tokens[tokens.length - 1];
        }
        String uName = name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
        Class<?> clazz = oClass = onMBean ? this.getClass() : this._managed.getClass();
        if (LOG.isDebugEnabled()) {
            LOG.debug("defineAttribute " + name + " " + onMBean + ":" + writable + ":" + oClass + ":" + description, new Object[0]);
        }
        Class<?> type = null;
        Method getter = null;
        Method setter = null;
        Method[] methods = oClass.getMethods();
        for (int m2 = 0; m2 < methods.length; ++m2) {
            if ((methods[m2].getModifiers() & 1) == 0) continue;
            if (methods[m2].getName().equals("get" + uName) && methods[m2].getParameterTypes().length == 0) {
                if (getter != null) {
                    LOG.warn("Multiple mbean getters for attr " + name + " in " + oClass, new Object[0]);
                    continue;
                }
                getter = methods[m2];
                if (type != null && !type.equals(methods[m2].getReturnType())) {
                    LOG.warn("Type conflict for mbean attr " + name + " in " + oClass, new Object[0]);
                    continue;
                }
                type = methods[m2].getReturnType();
            }
            if (methods[m2].getName().equals("is" + uName) && methods[m2].getParameterTypes().length == 0) {
                if (getter != null) {
                    LOG.warn("Multiple mbean getters for attr " + name + " in " + oClass, new Object[0]);
                    continue;
                }
                getter = methods[m2];
                if (type != null && !type.equals(methods[m2].getReturnType())) {
                    LOG.warn("Type conflict for mbean attr " + name + " in " + oClass, new Object[0]);
                    continue;
                }
                type = methods[m2].getReturnType();
            }
            if (!writable || !methods[m2].getName().equals("set" + uName) || methods[m2].getParameterTypes().length != 1) continue;
            if (setter != null) {
                LOG.warn("Multiple setters for mbean attr " + name + " in " + oClass, new Object[0]);
                continue;
            }
            setter = methods[m2];
            if (type != null && !type.equals(methods[m2].getParameterTypes()[0])) {
                LOG.warn("Type conflict for mbean attr " + name + " in " + oClass, new Object[0]);
                continue;
            }
            type = methods[m2].getParameterTypes()[0];
        }
        if (convert) {
            if (type == null) {
                LOG.warn("No mbean type for " + name + " on " + this._managed.getClass(), new Object[0]);
                return null;
            }
            if (type.isPrimitive() && !type.isArray()) {
                LOG.warn("Cannot convert mbean primative " + name, new Object[0]);
                return null;
            }
        }
        if (getter == null && setter == null) {
            LOG.warn("No mbean getter or setters found for " + name + " in " + oClass, new Object[0]);
            return null;
        }
        try {
            this._getters.put(name, getter);
            this._setters.put(name, setter);
            MBeanAttributeInfo info = null;
            if (convert) {
                this._convert.add(name);
                info = type.isArray() ? new MBeanAttributeInfo(name, OBJECT_NAME_ARRAY_CLASS, description, getter != null, setter != null, getter != null && getter.getName().startsWith("is")) : new MBeanAttributeInfo(name, OBJECT_NAME_CLASS, description, getter != null, setter != null, getter != null && getter.getName().startsWith("is"));
            } else {
                info = new MBeanAttributeInfo(name, description, getter, setter);
            }
            return info;
        }
        catch (Exception e2) {
            LOG.warn(name + ": " + metaData, e2);
            throw new IllegalArgumentException(e2.toString());
        }
    }

    private MBeanOperationInfo defineOperation(String signature, String metaData, ResourceBundle bundle) {
        boolean convert;
        String impact_name;
        String[] tokens = metaData.split(":", 3);
        int i2 = tokens.length - 1;
        String description = tokens[i2--];
        String string = impact_name = i2 < 0 ? "UNKNOWN" : tokens[i2--].trim();
        if (i2 == 0) {
            tokens[0] = tokens[0].trim();
        }
        boolean onMBean = i2 == 0 && ("MBean".equalsIgnoreCase(tokens[0]) || "MMBean".equalsIgnoreCase(tokens[0]));
        boolean bl = convert = i2 == 0 && ("MObject".equalsIgnoreCase(tokens[0]) || "MMBean".equalsIgnoreCase(tokens[0]));
        if (LOG.isDebugEnabled()) {
            LOG.debug("defineOperation " + signature + " " + onMBean + ":" + impact_name + ":" + description, new Object[0]);
        }
        Class<?> oClass = onMBean ? this.getClass() : this._managed.getClass();
        try {
            int impact = 3;
            if (impact_name == null || impact_name.equals("UNKNOWN")) {
                impact = 3;
            } else if (impact_name.equals("ACTION")) {
                impact = 1;
            } else if (impact_name.equals("INFO")) {
                impact = 0;
            } else if (impact_name.equals("ACTION_INFO")) {
                impact = 2;
            } else {
                LOG.warn("Unknown impact '" + impact_name + "' for " + signature, new Object[0]);
            }
            String[] parts = signature.split("[\\(\\)]");
            String method_name = parts[0];
            String arguments = parts.length == 2 ? parts[1] : null;
            String[] args = arguments == null ? new String[]{} : arguments.split(" *, *");
            Class[] types = new Class[args.length];
            MBeanParameterInfo[] pInfo = new MBeanParameterInfo[args.length];
            signature = method_name;
            for (i2 = 0; i2 < args.length; ++i2) {
                Class<?> type = TypeUtil.fromName(args[i2]);
                if (type == null) {
                    type = Thread.currentThread().getContextClassLoader().loadClass(args[i2]);
                }
                types[i2] = type;
                args[i2] = type.isPrimitive() ? TypeUtil.toName(type) : args[i2];
                signature = signature + (i2 > 0 ? "," : "(") + args[i2];
            }
            signature = signature + (i2 > 0 ? ")" : "()");
            for (i2 = 0; i2 < args.length; ++i2) {
                String param_desc = bundle.getString(signature + "[" + i2 + "]");
                parts = param_desc.split(" *: *", 2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(parts[0] + ": " + parts[1], new Object[0]);
                }
                pInfo[i2] = new MBeanParameterInfo(parts[0].trim(), args[i2], parts[1].trim());
            }
            Method method = oClass.getMethod(method_name, types);
            Class<?> returnClass = method.getReturnType();
            this._methods.put(signature, method);
            if (convert) {
                this._convert.add(signature);
            }
            return new MBeanOperationInfo(method_name, description, pInfo, returnClass.isPrimitive() ? TypeUtil.toName(returnClass) : returnClass.getName(), impact);
        }
        catch (Exception e2) {
            LOG.warn("Operation '" + signature + "'", e2);
            throw new IllegalArgumentException(e2.toString());
        }
    }
}

