/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.Part;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.MultiPartInputStream;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class MultiPartFilter
implements Filter {
    private static final Logger LOG = Log.getLogger(MultiPartFilter.class);
    public static final String CONTENT_TYPE_SUFFIX = ".org.eclipse.jetty.servlet.contentType";
    private static final String MULTIPART = "org.eclipse.jetty.servlet.MultiPartFile.multiPartInputStream";
    private File tempdir;
    private boolean _deleteFiles;
    private ServletContext _context;
    private int _fileOutputBuffer = 0;
    private long _maxFileSize = -1L;
    private long _maxRequestSize = -1L;
    private int _maxFormKeys = Integer.getInteger("org.eclipse.jetty.server.Request.maxFormKeys", 1000);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String maxRequestSize;
        String maxFileSize;
        this.tempdir = (File)filterConfig.getServletContext().getAttribute("javax.servlet.context.tempdir");
        this._deleteFiles = "true".equals(filterConfig.getInitParameter("deleteFiles"));
        String fileOutputBuffer = filterConfig.getInitParameter("fileOutputBuffer");
        if (fileOutputBuffer != null) {
            this._fileOutputBuffer = Integer.parseInt(fileOutputBuffer);
        }
        if ((maxFileSize = filterConfig.getInitParameter("maxFileSize")) != null) {
            this._maxFileSize = Long.parseLong(maxFileSize.trim());
        }
        if ((maxRequestSize = filterConfig.getInitParameter("maxRequestSize")) != null) {
            this._maxRequestSize = Long.parseLong(maxRequestSize.trim());
        }
        this._context = filterConfig.getServletContext();
        String mfks = filterConfig.getInitParameter("maxFormKeys");
        if (mfks != null) {
            this._maxFormKeys = Integer.parseInt(mfks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest srequest = (HttpServletRequest)request;
        if (srequest.getContentType() == null || !srequest.getContentType().startsWith("multipart/form-data")) {
            chain.doFilter(request, response);
            return;
        }
        BufferedInputStream in = new BufferedInputStream(request.getInputStream());
        String content_type = srequest.getContentType();
        MultiMap<String> params = new MultiMap<String>();
        for (Map.Entry<String, String[]> entry : request.getParameterMap().entrySet()) {
            String[] value = entry.getValue();
            if (value instanceof String[]) {
                params.addValues(entry.getKey(), value);
                continue;
            }
            params.add(entry.getKey(), value);
        }
        MultipartConfigElement config = new MultipartConfigElement(this.tempdir.getCanonicalPath(), this._maxFileSize, this._maxRequestSize, this._fileOutputBuffer);
        MultiPartInputStream mpis = new MultiPartInputStream(in, content_type, config, this.tempdir);
        mpis.setDeleteOnExit(this._deleteFiles);
        request.setAttribute(MULTIPART, mpis);
        try {
            Collection<Part> parts = mpis.getParts();
            if (parts != null) {
                Iterator<Part> itor = parts.iterator();
                while (itor.hasNext() && params.size() < this._maxFormKeys) {
                    Part p2 = itor.next();
                    MultiPartInputStream.MultiPart mp = (MultiPartInputStream.MultiPart)p2;
                    if (mp.getFile() != null) {
                        request.setAttribute(mp.getName(), mp.getFile());
                        if (mp.getContentDispositionFilename() == null) continue;
                        params.add(mp.getName(), mp.getContentDispositionFilename());
                        if (mp.getContentType() == null) continue;
                        params.add(mp.getName() + CONTENT_TYPE_SUFFIX, mp.getContentType());
                        continue;
                    }
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    IO.copy(p2.getInputStream(), bytes);
                    params.add(p2.getName(), bytes.toByteArray());
                    if (p2.getContentType() == null) continue;
                    params.add(p2.getName() + CONTENT_TYPE_SUFFIX, p2.getContentType());
                }
            }
            chain.doFilter(new Wrapper(srequest, params), response);
        }
        finally {
            this.deleteFiles(request);
        }
    }

    private void deleteFiles(ServletRequest request) {
        if (!this._deleteFiles) {
            return;
        }
        MultiPartInputStream mpis = (MultiPartInputStream)request.getAttribute(MULTIPART);
        if (mpis != null) {
            try {
                mpis.deleteParts();
            }
            catch (Exception e2) {
                this._context.log("Error deleting multipart tmp files", e2);
            }
        }
        request.removeAttribute(MULTIPART);
    }

    @Override
    public void destroy() {
    }

    private static class Wrapper
    extends HttpServletRequestWrapper {
        String _encoding = "UTF-8";
        MultiMap _params;

        public Wrapper(HttpServletRequest request, MultiMap map) {
            super(request);
            this._params = map;
        }

        @Override
        public int getContentLength() {
            return 0;
        }

        @Override
        public String getParameter(String name) {
            Object o2 = this._params.get(name);
            if (!(o2 instanceof byte[]) && LazyList.size(o2) > 0) {
                o2 = LazyList.get(o2, 0);
            }
            if (o2 instanceof byte[]) {
                try {
                    String s = new String((byte[])o2, this._encoding);
                    return s;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            } else if (o2 != null) {
                return String.valueOf(o2);
            }
            return null;
        }

        public Map getParameterMap() {
            HashMap<String, String[]> cmap = new HashMap<String, String[]>();
            for (Object key : this._params.keySet()) {
                String[] a2 = LazyList.toStringArray(this.getParameter((String)key));
                cmap.put((String)key, a2);
            }
            return Collections.unmodifiableMap(cmap);
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this._params.keySet());
        }

        @Override
        public String[] getParameterValues(String name) {
            List l2 = this._params.getValues(name);
            if (l2 == null || l2.size() == 0) {
                return new String[0];
            }
            String[] v = new String[l2.size()];
            for (int i2 = 0; i2 < l2.size(); ++i2) {
                Object o2 = l2.get(i2);
                if (o2 instanceof byte[]) {
                    try {
                        v[i2] = new String((byte[])o2, this._encoding);
                        continue;
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                }
                if (!(o2 instanceof String)) continue;
                v[i2] = (String)o2;
            }
            return v;
        }

        @Override
        public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
            this._encoding = enc;
        }
    }
}

