/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AggregateLifeCycle
extends AbstractLifeCycle
implements Destroyable,
Dumpable {
    private static final Logger LOG = Log.getLogger(AggregateLifeCycle.class);
    private final List<Bean> _beans = new CopyOnWriteArrayList<Bean>();
    private boolean _started = false;

    @Override
    protected void doStart() throws Exception {
        for (Bean b2 : this._beans) {
            LifeCycle l2;
            if (!b2._managed || !(b2._bean instanceof LifeCycle) || (l2 = (LifeCycle)b2._bean).isRunning()) continue;
            l2.start();
        }
        this._started = true;
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this._started = false;
        super.doStop();
        ArrayList<Bean> reverse = new ArrayList<Bean>(this._beans);
        Collections.reverse(reverse);
        for (Bean b2 : reverse) {
            LifeCycle l2;
            if (!b2._managed || !(b2._bean instanceof LifeCycle) || !(l2 = (LifeCycle)b2._bean).isRunning()) continue;
            l2.stop();
        }
    }

    @Override
    public void destroy() {
        ArrayList<Bean> reverse = new ArrayList<Bean>(this._beans);
        Collections.reverse(reverse);
        for (Bean b2 : reverse) {
            if (!(b2._bean instanceof Destroyable) || !b2._managed) continue;
            Destroyable d2 = (Destroyable)b2._bean;
            d2.destroy();
        }
        this._beans.clear();
    }

    public boolean contains(Object bean) {
        for (Bean b2 : this._beans) {
            if (b2._bean != bean) continue;
            return true;
        }
        return false;
    }

    public boolean isManaged(Object bean) {
        for (Bean b2 : this._beans) {
            if (b2._bean != bean) continue;
            return b2._managed;
        }
        return false;
    }

    public boolean addBean(Object o2) {
        return this.addBean(o2, !(o2 instanceof LifeCycle) || !((LifeCycle)o2).isStarted());
    }

    public boolean addBean(Object o2, boolean managed) {
        if (this.contains(o2)) {
            return false;
        }
        Bean b2 = new Bean(o2);
        b2._managed = managed;
        this._beans.add(b2);
        if (o2 instanceof LifeCycle) {
            LifeCycle l2 = (LifeCycle)o2;
            if (managed && this._started) {
                try {
                    l2.start();
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        return true;
    }

    public void manage(Object bean) {
        for (Bean b2 : this._beans) {
            if (b2._bean != bean) continue;
            b2._managed = true;
            return;
        }
        throw new IllegalArgumentException();
    }

    public void unmanage(Object bean) {
        for (Bean b2 : this._beans) {
            if (b2._bean != bean) continue;
            b2._managed = false;
            return;
        }
        throw new IllegalArgumentException();
    }

    public Collection<Object> getBeans() {
        return this.getBeans(Object.class);
    }

    public <T> List<T> getBeans(Class<T> clazz) {
        ArrayList<Object> beans = new ArrayList<Object>();
        for (Bean b2 : this._beans) {
            if (!clazz.isInstance(b2._bean)) continue;
            beans.add(b2._bean);
        }
        return beans;
    }

    public <T> T getBean(Class<T> clazz) {
        for (Bean b2 : this._beans) {
            if (!clazz.isInstance(b2._bean)) continue;
            return (T)b2._bean;
        }
        return null;
    }

    public void removeBeans() {
        this._beans.clear();
    }

    public boolean removeBean(Object o2) {
        for (Bean b2 : this._beans) {
            if (b2._bean != o2) continue;
            this._beans.remove(b2);
            return true;
        }
        return false;
    }

    public void dumpStdErr() {
        try {
            this.dump(System.err, "");
        }
        catch (IOException e2) {
            LOG.warn(e2);
        }
    }

    @Override
    public String dump() {
        return AggregateLifeCycle.dump(this);
    }

    public static String dump(Dumpable dumpable) {
        StringBuilder b2 = new StringBuilder();
        try {
            dumpable.dump(b2, "");
        }
        catch (IOException e2) {
            LOG.warn(e2);
        }
        return b2.toString();
    }

    public void dump(Appendable out) throws IOException {
        this.dump(out, "");
    }

    protected void dumpThis(Appendable out) throws IOException {
        out.append(String.valueOf(this)).append(" - ").append(this.getState()).append("\n");
    }

    public static void dumpObject(Appendable out, Object o2) throws IOException {
        try {
            if (o2 instanceof LifeCycle) {
                out.append(String.valueOf(o2)).append(" - ").append(AbstractLifeCycle.getState((LifeCycle)o2)).append("\n");
            } else {
                out.append(String.valueOf(o2)).append("\n");
            }
        }
        catch (Throwable th) {
            out.append(" => ").append(th.toString()).append('\n');
        }
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        int size = this._beans.size();
        if (size == 0) {
            return;
        }
        int i2 = 0;
        for (Bean b2 : this._beans) {
            ++i2;
            out.append(indent).append(" +- ");
            if (b2._managed) {
                if (b2._bean instanceof Dumpable) {
                    ((Dumpable)b2._bean).dump(out, indent + (i2 == size ? "    " : " |  "));
                    continue;
                }
                AggregateLifeCycle.dumpObject(out, b2._bean);
                continue;
            }
            AggregateLifeCycle.dumpObject(out, b2._bean);
        }
        if (i2 != size) {
            out.append(indent).append(" |\n");
        }
    }

    public static void dump(Appendable out, String indent, Collection<?> ... collections) throws IOException {
        if (collections.length == 0) {
            return;
        }
        int size = 0;
        for (Collection<?> c2 : collections) {
            size += c2.size();
        }
        if (size == 0) {
            return;
        }
        int i2 = 0;
        for (Collection<?> c3 : collections) {
            for (Object o2 : c3) {
                ++i2;
                out.append(indent).append(" +- ");
                if (o2 instanceof Dumpable) {
                    ((Dumpable)o2).dump(out, indent + (i2 == size ? "    " : " |  "));
                    continue;
                }
                AggregateLifeCycle.dumpObject(out, o2);
            }
            if (i2 == size) continue;
            out.append(indent).append(" |\n");
        }
    }

    private class Bean {
        final Object _bean;
        volatile boolean _managed = true;

        Bean(Object b2) {
            this._bean = b2;
        }

        public String toString() {
            return "{" + this._bean + "," + this._managed + "}";
        }
    }
}

