/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.DefaultsDescriptor;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.DescriptorProcessor;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.FragmentDescriptor;
import org.eclipse.jetty.webapp.MetaDataComplete;
import org.eclipse.jetty.webapp.Ordering;
import org.eclipse.jetty.webapp.Origin;
import org.eclipse.jetty.webapp.OverrideDescriptor;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebDescriptor;

public class MetaData {
    private static final Logger LOG = Log.getLogger(MetaData.class);
    public static final String ORDERED_LIBS = "javax.servlet.context.orderedLibs";
    protected Map<String, OriginInfo> _origins = new HashMap<String, OriginInfo>();
    protected WebDescriptor _webDefaultsRoot;
    protected WebDescriptor _webXmlRoot;
    protected final List<WebDescriptor> _webOverrideRoots = new ArrayList<WebDescriptor>();
    protected boolean _metaDataComplete;
    protected final List<DiscoveredAnnotation> _annotations = new ArrayList<DiscoveredAnnotation>();
    protected final List<DescriptorProcessor> _descriptorProcessors = new ArrayList<DescriptorProcessor>();
    protected final List<FragmentDescriptor> _webFragmentRoots = new ArrayList<FragmentDescriptor>();
    protected final Map<String, FragmentDescriptor> _webFragmentNameMap = new HashMap<String, FragmentDescriptor>();
    protected final Map<Resource, FragmentDescriptor> _webFragmentResourceMap = new HashMap<Resource, FragmentDescriptor>();
    protected final Map<Resource, List<DiscoveredAnnotation>> _webFragmentAnnotations = new HashMap<Resource, List<DiscoveredAnnotation>>();
    protected final List<Resource> _webInfJars = new ArrayList<Resource>();
    protected final List<Resource> _orderedWebInfJars = new ArrayList<Resource>();
    protected final List<Resource> _orderedContainerJars = new ArrayList<Resource>();
    protected Ordering _ordering;
    protected boolean allowDuplicateFragmentNames = false;

    public void clear() {
        this._webDefaultsRoot = null;
        this._origins.clear();
        this._webXmlRoot = null;
        this._webOverrideRoots.clear();
        this._metaDataComplete = false;
        this._annotations.clear();
        this._descriptorProcessors.clear();
        this._webFragmentRoots.clear();
        this._webFragmentNameMap.clear();
        this._webFragmentResourceMap.clear();
        this._webFragmentAnnotations.clear();
        this._webInfJars.clear();
        this._orderedWebInfJars.clear();
        this._orderedContainerJars.clear();
        this._ordering = null;
        this.allowDuplicateFragmentNames = false;
    }

    public void setDefaults(Resource webDefaults) throws Exception {
        this._webDefaultsRoot = new DefaultsDescriptor(webDefaults);
        this._webDefaultsRoot.parse();
        if (this._webDefaultsRoot.isOrdered()) {
            if (this._ordering == null) {
                this._ordering = new Ordering.AbsoluteOrdering(this);
            }
            List<String> order = this._webDefaultsRoot.getOrdering();
            for (String s : order) {
                if (s.equalsIgnoreCase("others")) {
                    ((Ordering.AbsoluteOrdering)this._ordering).addOthers();
                    continue;
                }
                ((Ordering.AbsoluteOrdering)this._ordering).add(s);
            }
        }
    }

    public void setWebXml(Resource webXml) throws Exception {
        this._webXmlRoot = new WebDescriptor(webXml);
        this._webXmlRoot.parse();
        boolean bl = this._metaDataComplete = this._webXmlRoot.getMetaDataComplete() == MetaDataComplete.True;
        if (this._webXmlRoot.isOrdered()) {
            if (this._ordering == null) {
                this._ordering = new Ordering.AbsoluteOrdering(this);
            }
            List<String> order = this._webXmlRoot.getOrdering();
            for (String s : order) {
                if (s.equalsIgnoreCase("others")) {
                    ((Ordering.AbsoluteOrdering)this._ordering).addOthers();
                    continue;
                }
                ((Ordering.AbsoluteOrdering)this._ordering).add(s);
            }
        }
    }

    public void addOverride(Resource override) throws Exception {
        OverrideDescriptor webOverrideRoot = new OverrideDescriptor(override);
        webOverrideRoot.setValidating(false);
        webOverrideRoot.parse();
        switch (webOverrideRoot.getMetaDataComplete()) {
            case True: {
                this._metaDataComplete = true;
                break;
            }
            case False: {
                this._metaDataComplete = false;
                break;
            }
        }
        if (webOverrideRoot.isOrdered()) {
            if (this._ordering == null) {
                this._ordering = new Ordering.AbsoluteOrdering(this);
            }
            List<String> order = webOverrideRoot.getOrdering();
            for (String s : order) {
                if (s.equalsIgnoreCase("others")) {
                    ((Ordering.AbsoluteOrdering)this._ordering).addOthers();
                    continue;
                }
                ((Ordering.AbsoluteOrdering)this._ordering).add(s);
            }
        }
        this._webOverrideRoots.add(webOverrideRoot);
    }

    public void addFragment(Resource jarResource, Resource xmlResource) throws Exception {
        if (this._metaDataComplete) {
            return;
        }
        FragmentDescriptor descriptor = new FragmentDescriptor(xmlResource);
        this._webFragmentResourceMap.put(jarResource, descriptor);
        this._webFragmentRoots.add(descriptor);
        descriptor.parse();
        if (descriptor.getName() != null) {
            Descriptor existing = this._webFragmentNameMap.get(descriptor.getName());
            if (existing != null && !this.isAllowDuplicateFragmentNames()) {
                throw new IllegalStateException("Duplicate fragment name: " + descriptor.getName() + " for " + existing.getResource() + " and " + descriptor.getResource());
            }
            this._webFragmentNameMap.put(descriptor.getName(), descriptor);
        }
        if (this._ordering != null && this._ordering.isAbsolute()) {
            return;
        }
        if (this._ordering == null && descriptor.isOrdered()) {
            this._ordering = new Ordering.RelativeOrdering(this);
        }
    }

    public void addDiscoveredAnnotations(List<DiscoveredAnnotation> annotations) {
        if (annotations == null) {
            return;
        }
        for (DiscoveredAnnotation a2 : annotations) {
            Resource r = a2.getResource();
            if (r == null || !this._webInfJars.contains(r)) {
                this._annotations.add(a2);
                continue;
            }
            this.addDiscoveredAnnotation(a2.getResource(), a2);
        }
    }

    public void addDiscoveredAnnotation(Resource resource, DiscoveredAnnotation annotation) {
        List<DiscoveredAnnotation> list = this._webFragmentAnnotations.get(resource);
        if (list == null) {
            list = new ArrayList<DiscoveredAnnotation>();
            this._webFragmentAnnotations.put(resource, list);
        }
        list.add(annotation);
    }

    public void addDiscoveredAnnotations(Resource resource, List<DiscoveredAnnotation> annotations) {
        List<DiscoveredAnnotation> list = this._webFragmentAnnotations.get(resource);
        if (list == null) {
            list = new ArrayList<DiscoveredAnnotation>();
            this._webFragmentAnnotations.put(resource, list);
        }
        list.addAll(annotations);
    }

    public void addDescriptorProcessor(DescriptorProcessor p2) {
        this._descriptorProcessors.add(p2);
    }

    public void orderFragments() {
        if (this._orderedWebInfJars.size() == this._webInfJars.size()) {
            return;
        }
        if (this._ordering != null) {
            this._orderedWebInfJars.addAll(this._ordering.order(this._webInfJars));
        } else {
            this._orderedWebInfJars.addAll(this._webInfJars);
        }
    }

    public void resolve(WebAppContext context) throws Exception {
        LOG.debug("metadata resolve {}", context);
        this._origins.clear();
        if (this._ordering != null) {
            ArrayList<String> orderedLibs = new ArrayList<String>();
            for (Resource webInfJar : this._orderedWebInfJars) {
                String fullname = webInfJar.getName();
                int i2 = fullname.indexOf(".jar");
                int j2 = fullname.lastIndexOf("/", i2);
                orderedLibs.add(fullname.substring(j2 + 1, i2 + 4));
            }
            context.setAttribute(ORDERED_LIBS, orderedLibs);
        }
        if (this._webXmlRoot != null) {
            context.getServletContext().setEffectiveMajorVersion(this._webXmlRoot.getMajorVersion());
            context.getServletContext().setEffectiveMinorVersion(this._webXmlRoot.getMinorVersion());
        }
        for (DescriptorProcessor p2 : this._descriptorProcessors) {
            p2.process(context, this.getWebDefault());
            p2.process(context, this.getWebXml());
            for (WebDescriptor wd : this.getOverrideWebs()) {
                LOG.debug("process {} {}", context, wd);
                p2.process(context, wd);
            }
        }
        for (DiscoveredAnnotation a2 : this._annotations) {
            LOG.debug("apply {}", a2);
            a2.apply();
        }
        List<Resource> resources = this.getOrderedWebInfJars();
        for (Resource r : resources) {
            List<DiscoveredAnnotation> fragAnnotations;
            FragmentDescriptor fd = this._webFragmentResourceMap.get(r);
            if (fd != null) {
                for (DescriptorProcessor p3 : this._descriptorProcessors) {
                    LOG.debug("process {} {}", context, fd);
                    p3.process(context, fd);
                }
            }
            if ((fragAnnotations = this._webFragmentAnnotations.get(r)) == null) continue;
            for (DiscoveredAnnotation a3 : fragAnnotations) {
                LOG.debug("apply {}", a3);
                a3.apply();
            }
        }
    }

    public boolean isDistributable() {
        boolean distributable = this._webDefaultsRoot != null && this._webDefaultsRoot.isDistributable() || this._webXmlRoot != null && this._webXmlRoot.isDistributable();
        for (WebDescriptor d2 : this._webOverrideRoots) {
            distributable &= d2.isDistributable();
        }
        List<Resource> orderedResources = this.getOrderedWebInfJars();
        for (Resource r : orderedResources) {
            FragmentDescriptor d3 = this._webFragmentResourceMap.get(r);
            if (d3 == null) continue;
            distributable = distributable && d3.isDistributable();
        }
        return distributable;
    }

    public WebDescriptor getWebXml() {
        return this._webXmlRoot;
    }

    public List<WebDescriptor> getOverrideWebs() {
        return this._webOverrideRoots;
    }

    public WebDescriptor getWebDefault() {
        return this._webDefaultsRoot;
    }

    public List<FragmentDescriptor> getFragments() {
        return this._webFragmentRoots;
    }

    public List<Resource> getOrderedWebInfJars() {
        return this._orderedWebInfJars == null ? new ArrayList() : this._orderedWebInfJars;
    }

    public List<FragmentDescriptor> getOrderedFragments() {
        ArrayList<FragmentDescriptor> list = new ArrayList<FragmentDescriptor>();
        if (this._orderedWebInfJars == null) {
            return list;
        }
        for (Resource r : this._orderedWebInfJars) {
            FragmentDescriptor fd = this._webFragmentResourceMap.get(r);
            if (fd == null) continue;
            list.add(fd);
        }
        return list;
    }

    public Ordering getOrdering() {
        return this._ordering;
    }

    public void setOrdering(Ordering o2) {
        this._ordering = o2;
    }

    public FragmentDescriptor getFragment(Resource jar) {
        return this._webFragmentResourceMap.get(jar);
    }

    public FragmentDescriptor getFragment(String name) {
        return this._webFragmentNameMap.get(name);
    }

    public Resource getJarForFragment(String name) {
        FragmentDescriptor f2 = this.getFragment(name);
        if (f2 == null) {
            return null;
        }
        Resource jar = null;
        for (Resource r : this._webFragmentResourceMap.keySet()) {
            if (!this._webFragmentResourceMap.get(r).equals(f2)) continue;
            jar = r;
        }
        return jar;
    }

    public Map<String, FragmentDescriptor> getNamedFragments() {
        return Collections.unmodifiableMap(this._webFragmentNameMap);
    }

    public Origin getOrigin(String name) {
        OriginInfo x = this._origins.get(name);
        if (x == null) {
            return Origin.NotSet;
        }
        return x.getOriginType();
    }

    public Descriptor getOriginDescriptor(String name) {
        OriginInfo o2 = this._origins.get(name);
        if (o2 == null) {
            return null;
        }
        return o2.getDescriptor();
    }

    public void setOrigin(String name, Descriptor d2) {
        OriginInfo x = new OriginInfo(name, d2);
        this._origins.put(name, x);
    }

    public void setOrigin(String name) {
        if (name == null) {
            return;
        }
        OriginInfo x = new OriginInfo(name, Origin.Annotation);
        this._origins.put(name, x);
    }

    public void setOrigin(String name, Origin origin) {
        if (name == null) {
            return;
        }
        OriginInfo x = new OriginInfo(name, origin);
        this._origins.put(name, x);
    }

    public boolean isMetaDataComplete() {
        return this._metaDataComplete;
    }

    public void addWebInfJar(Resource newResource) {
        this._webInfJars.add(newResource);
    }

    public List<Resource> getWebInfJars() {
        return Collections.unmodifiableList(this._webInfJars);
    }

    public List<Resource> getOrderedContainerJars() {
        return this._orderedContainerJars;
    }

    public void addContainerJar(Resource jar) {
        this._orderedContainerJars.add(jar);
    }

    public boolean isAllowDuplicateFragmentNames() {
        return this.allowDuplicateFragmentNames;
    }

    public void setAllowDuplicateFragmentNames(boolean allowDuplicateFragmentNames) {
        this.allowDuplicateFragmentNames = allowDuplicateFragmentNames;
    }

    public static class OriginInfo {
        protected String name;
        protected Origin origin;
        protected Descriptor descriptor;

        public OriginInfo(String n2, Descriptor d2) {
            this.name = n2;
            this.descriptor = d2;
            if (d2 == null) {
                throw new IllegalArgumentException("No descriptor");
            }
            this.origin = d2 instanceof FragmentDescriptor ? Origin.WebFragment : (d2 instanceof OverrideDescriptor ? Origin.WebOverride : (d2 instanceof DefaultsDescriptor ? Origin.WebDefaults : Origin.WebXml));
        }

        public OriginInfo(String n2) {
            this.name = n2;
            this.origin = Origin.Annotation;
        }

        public OriginInfo(String n2, Origin o2) {
            this.name = n2;
            this.origin = o2;
        }

        public String getName() {
            return this.name;
        }

        public Origin getOriginType() {
            return this.origin;
        }

        public Descriptor getDescriptor() {
            return this.descriptor;
        }
    }
}

