/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.DynEnv;
import ice.util.Defs;
import ice.util.alg.HashArray;

public class DynamicObject {
    public static final Object NOT_FOUND = Defs.NOT_FOUND;
    public static final int SETD_NOT_FOUND = 0;
    public static final int SETD_OK = 1;
    public static final int SETD_IGNORE = 2;
    private HashArray slots;
    private static final int Method_toSource = -1;
    private static final int Method_toString = -2;

    protected Object getScriptDataLock() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashArray ensureSlots() {
        HashArray hashArray = this.slots;
        if (hashArray == null) {
            Object object = this.getScriptDataLock();
            if (object == null) {
                this.slots = hashArray = new HashArray(object);
            } else {
                Object object2 = object;
                synchronized (object2) {
                    hashArray = this.slots;
                    if (hashArray == null) {
                        this.slots = hashArray = new HashArray(object);
                    }
                }
            }
        }
        return hashArray;
    }

    public Object javaReflectionTarget() {
        return null;
    }

    public boolean readOnlySlots() {
        return false;
    }

    public Object getDynamicValue(String string, DynEnv dynEnv) {
        int n = DynamicObject.toDynamicId(string);
        if (n < 0) {
            return dynEnv.wrapMethod(this, string);
        }
        return Defs.NOT_FOUND;
    }

    public int setDynamicValue(String string, Object object, DynEnv dynEnv) {
        int n = DynamicObject.toDynamicId(string);
        if (n < 0) {
            return 2;
        }
        return 0;
    }

    public Object execDynamicMethod(String string, Object[] objectArray, DynEnv dynEnv) {
        int n = DynamicObject.toDynamicId(string);
        if (n < 0) {
            return this.execDynamicMethod(n, dynEnv);
        }
        return Defs.NOT_FOUND;
    }

    public DynamicObject getMethodPropertySource(String string, DynEnv dynEnv) {
        return null;
    }

    public Object getDynamicScopeParent() {
        return null;
    }

    private Object execDynamicMethod(int n, DynEnv dynEnv) {
        if (n == -2) {
            return this.script_toString(dynEnv);
        }
        if (n == -1) {
            return this.script_toSource(dynEnv);
        }
        Debug.bug();
        return null;
    }

    protected Object script_toSource(DynEnv dynEnv) {
        return dynEnv.onNotImplemented();
    }

    public String script_toString(DynEnv dynEnv) {
        Object object = this.javaReflectionTarget();
        if (object == null) {
            object = this;
        }
        return object.toString();
    }

    public boolean hasSlot(String string, DynEnv dynEnv) {
        return Defs.NOT_FOUND != this.getSlot(string, dynEnv);
    }

    public boolean hasSlot(int n, DynEnv dynEnv) {
        return Defs.NOT_FOUND != this.getSlot(n, dynEnv);
    }

    public Object getSlot(String string, DynEnv dynEnv) {
        HashArray.Entry entry;
        HashArray hashArray = this.slots;
        if (hashArray != null && (entry = hashArray.getEntry((Object)string)) != null) {
            return entry.value;
        }
        return Defs.NOT_FOUND;
    }

    public Object getSlot(int n, DynEnv dynEnv) {
        HashArray.Entry entry;
        HashArray hashArray = this.slots;
        if (hashArray != null && (entry = hashArray.getEntry(n)) != null) {
            return entry.value;
        }
        return Defs.NOT_FOUND;
    }

    public void setSlot(String string, Object object, DynEnv dynEnv) {
        this.ensureSlots().setValue((Object)string, object);
    }

    public void setSlot(int n, Object object, DynEnv dynEnv) {
        this.ensureSlots().setValue(n, object);
    }

    public void deleteSlot(String string) {
        HashArray hashArray = this.slots;
        if (hashArray != null) {
            hashArray.remove((Object)string);
        }
    }

    public void deleteSlot(int n) {
        HashArray hashArray = this.slots;
        if (hashArray != null) {
            hashArray.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setScriptWrapperIfAbsent(Object object, Object object2) {
        HashArray hashArray = this.ensureSlots();
        Object object3 = hashArray.synchronizationLock();
        synchronized (object3) {
            HashArray.Entry entry = hashArray.ensureEntry(object);
            if (entry.value == null) {
                entry.value = object2;
            }
            return entry.value;
        }
    }

    public Object getScriptWrapper(Object object) {
        HashArray hashArray = this.slots;
        return hashArray != null ? hashArray.get(object) : null;
    }

    public void unlinkAllSlots() {
        this.slots = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getEnumeratableIds(DynEnv dynEnv, int n) {
        HashArray hashArray = this.slots;
        if (hashArray != null) {
            Object object = hashArray.synchronizationLock();
            synchronized (object) {
                HashArray.Iterator iterator = hashArray.newIterator();
                int n2 = 0;
                iterator.start();
                while (!iterator.done()) {
                    HashArray.Entry entry = iterator.entry();
                    if (entry.isIndex() || entry.key() instanceof String) {
                        ++n2;
                    }
                    iterator.next();
                }
                if (n2 != 0) {
                    int n3 = n;
                    Object[] objectArray = new Object[n3 + n2];
                    iterator.start();
                    while (!iterator.done()) {
                        Object object2 = null;
                        HashArray.Entry entry = iterator.entry();
                        if (entry.isIndex()) {
                            object2 = dynEnv.wrapInt(entry.index());
                        } else {
                            Object object3 = entry.key();
                            if (object3 instanceof String) {
                                object2 = object3;
                            }
                        }
                        if (object2 != null) {
                            objectArray[n3] = object2;
                            ++n3;
                        }
                        iterator.next();
                    }
                    return objectArray;
                }
            }
        }
        return n == 0 ? Defs.EMPTY_OBJECT_ARRAY : new Object[n];
    }

    private static int toDynamicId(String string) {
        int n = 0;
        String string2 = null;
        if (string.length() == 8) {
            char c = string.charAt(3);
            if (c == 'o') {
                string2 = "toSource";
                n = -1;
            } else if (c == 't') {
                string2 = "toString";
                n = -2;
            }
        }
        if (string2 != null && (string2 == string || string2.equals(string))) {
            return n;
        }
        return 0;
    }
}

