/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.desktop.client;

import com.google.common.base.Preconditions;
import com.mathworks.desktop.client.Client;
import com.mathworks.desktop.client.DefaultClientCollection;
import java.util.Collection;
import java.util.HashSet;

public class UniqueClientCollection<C extends Client>
extends DefaultClientCollection<C> {
    private static final String THIS_COLLECTION_DOES_NOT_ALLOW_CLIENTS_WITH_DUPLICATE_NAMES = "This collection does not allow clients with duplicate names";
    private static final String CLIENT_NAME_SHOULD_NOT_BE_NULL = "Client name should not be null";

    public UniqueClientCollection() {
    }

    public UniqueClientCollection(C ... CArray) {
        super(CArray);
        this.checkAll();
    }

    public UniqueClientCollection(Collection<C> collection) {
        super(collection);
        this.checkAll();
    }

    @Override
    public boolean add(int n, C c) {
        this.check((Client)c);
        return super.add(n, c);
    }

    @Override
    public boolean add(C c) {
        this.check((Client)c);
        return super.add(c);
    }

    private void check(Client client) {
        Preconditions.checkNotNull((Object)client.getName(), (Object)CLIENT_NAME_SHOULD_NOT_BE_NULL);
        Preconditions.checkArgument((this.get(client.getName()) == null ? 1 : 0) != 0, (Object)THIS_COLLECTION_DOES_NOT_ALLOW_CLIENTS_WITH_DUPLICATE_NAMES);
    }

    private void checkAll() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Client client : this) {
            Preconditions.checkNotNull((Object)client.getName(), (Object)CLIENT_NAME_SHOULD_NOT_BE_NULL);
            Preconditions.checkArgument((!hashSet.contains(client.getName()) ? 1 : 0) != 0, (Object)THIS_COLLECTION_DOES_NOT_ALLOW_CLIENTS_WITH_DUPLICATE_NAMES);
            hashSet.add(client.getName());
        }
    }
}

