/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mvm.eventmgr;

import com.mathworks.mvm.MvmFactoryWrapper;
import com.mathworks.mvm.MvmWrapper;
import com.mathworks.mvm.eventmgr.EventFiring;
import com.mathworks.mvm.eventmgr.EventListening;
import com.mathworks.mvm.eventmgr.EventMgr;
import com.mathworks.mvm.eventmgr.FirableMvmEvent;
import com.mathworks.mvm.eventmgr.InvalidEventTypeException;
import com.mathworks.mvm.eventmgr.MvmEvent;
import com.mathworks.mvm.eventmgr.MvmListener;
import java.lang.reflect.Method;
import org.jetbrains.annotations.Nullable;

public class DefaultEventMgr
implements EventMgr {
    private final Method fListenerMethod = DefaultEventMgr.getListenerMethod();
    private final NativeMethods fNativeMethods;

    public DefaultEventMgr() {
        this.fNativeMethods = new SessionNativeMethods();
    }

    public DefaultEventMgr(MvmFactoryWrapper mvmFactoryWrapper) {
        this.fNativeMethods = new FactoryNativeMethods(mvmFactoryWrapper);
    }

    public DefaultEventMgr(MvmWrapper mvmWrapper) {
        this.fNativeMethods = new MvmNativeMethods(mvmWrapper);
    }

    @Override
    public <E> void addMvmListener(MvmListener<E> mvmListener, Class<E> clazz) throws InvalidEventTypeException {
        this.addMvmListener(mvmListener, clazz, null);
    }

    @Override
    public <E> void addMvmListener(MvmListener<E> mvmListener, Class<E> clazz, @Nullable String string) throws InvalidEventTypeException {
        EventListening eventListening = new EventListening(clazz);
        if (string == null) {
            string = eventListening.getStaticEventType();
        }
        Method method = eventListening.getJavaFactory();
        this.fNativeMethods.addListener(mvmListener, clazz, string, method, this.fListenerMethod);
    }

    @Override
    public <E> void removeMvmListener(MvmListener<E> mvmListener, Class<E> clazz) {
        this.removeMvmListener(mvmListener, clazz, null);
    }

    @Override
    public <E> void removeMvmListener(MvmListener<E> mvmListener, Class<E> clazz, @Nullable String string) {
        try {
            EventListening eventListening = new EventListening(clazz);
            if (string == null) {
                string = eventListening.getStaticEventType();
            }
            this.fNativeMethods.removeListener(mvmListener, string);
        }
        catch (InvalidEventTypeException invalidEventTypeException) {
            // empty catch block
        }
    }

    @Override
    public <E extends FirableMvmEvent> void fireMvmEvent(E e) throws InvalidEventTypeException {
        Class<?> clazz = e.getClass();
        EventFiring eventFiring = new EventFiring(clazz);
        Method method = eventFiring.getCppFactory();
        this.fNativeMethods.notify(e, clazz, method);
    }

    @Override
    public void flush() {
        this.fNativeMethods.flush();
    }

    private static Method getListenerMethod() {
        Method method;
        block3: {
            method = null;
            try {
                method = MvmListener.class.getMethod("mvmChanged", MvmEvent.class);
                assert (null != method);
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)exception.toString());
            }
        }
        return method;
    }

    private static final class SessionNativeMethods
    implements NativeMethods {
        SessionNativeMethods() {
        }

        @Override
        public void addListener(MvmListener<?> mvmListener, Class<?> clazz, String string, Method method, Method method2) {
            SessionNativeMethods.nativeAddListener(mvmListener, clazz, string, method, method2);
        }

        @Override
        public void removeListener(MvmListener<?> mvmListener, String string) {
            SessionNativeMethods.nativeRemoveListener(mvmListener, string);
        }

        @Override
        public void notify(FirableMvmEvent firableMvmEvent, Class<?> clazz, Method method) {
            SessionNativeMethods.nativeNotify(firableMvmEvent, clazz, method);
        }

        @Override
        public void flush() {
            SessionNativeMethods.nativeFlush();
        }

        private static native void nativeAddListener(MvmListener<?> var0, Class<?> var1, String var2, Method var3, Method var4);

        private static native void nativeRemoveListener(MvmListener<?> var0, String var1);

        private static native void nativeNotify(FirableMvmEvent var0, Class<?> var1, Method var2);

        private static native void nativeFlush();
    }

    private static final class MvmNativeMethods
    implements NativeMethods {
        private final long fMvmHandle;

        MvmNativeMethods(MvmWrapper mvmWrapper) {
            this.fMvmHandle = mvmWrapper.get().getHandle();
        }

        @Override
        public void addListener(MvmListener<?> mvmListener, Class<?> clazz, String string, Method method, Method method2) {
            MvmNativeMethods.nativeAddListener(this.fMvmHandle, mvmListener, clazz, string, method, method2);
        }

        @Override
        public void removeListener(MvmListener<?> mvmListener, String string) {
            MvmNativeMethods.nativeRemoveListener(this.fMvmHandle, mvmListener, string);
        }

        @Override
        public void notify(FirableMvmEvent firableMvmEvent, Class<?> clazz, Method method) {
            MvmNativeMethods.nativeNotify(this.fMvmHandle, firableMvmEvent, clazz, method);
        }

        @Override
        public void flush() {
            MvmNativeMethods.nativeFlush(this.fMvmHandle);
        }

        private static native void nativeAddListener(long var0, MvmListener<?> var2, Class<?> var3, String var4, Method var5, Method var6);

        private static native void nativeRemoveListener(long var0, MvmListener<?> var2, String var3);

        private static native void nativeNotify(long var0, FirableMvmEvent var2, Class<?> var3, Method var4);

        private static native void nativeFlush(long var0);
    }

    private static final class FactoryNativeMethods
    implements NativeMethods {
        private final long fFactoryHandle;

        FactoryNativeMethods(MvmFactoryWrapper mvmFactoryWrapper) {
            this.fFactoryHandle = mvmFactoryWrapper.getHandle();
        }

        @Override
        public void addListener(MvmListener<?> mvmListener, Class<?> clazz, String string, Method method, Method method2) {
            FactoryNativeMethods.nativeAddListener(this.fFactoryHandle, mvmListener, clazz, string, method, method2);
        }

        @Override
        public void removeListener(MvmListener<?> mvmListener, String string) {
            FactoryNativeMethods.nativeRemoveListener(this.fFactoryHandle, mvmListener, string);
        }

        @Override
        public void notify(FirableMvmEvent firableMvmEvent, Class<?> clazz, Method method) {
            FactoryNativeMethods.nativeNotify(this.fFactoryHandle, firableMvmEvent, clazz, method);
        }

        @Override
        public void flush() {
            FactoryNativeMethods.nativeFlush(this.fFactoryHandle);
        }

        private static native void nativeAddListener(long var0, MvmListener<?> var2, Class<?> var3, String var4, Method var5, Method var6);

        private static native void nativeRemoveListener(long var0, MvmListener<?> var2, String var3);

        private static native void nativeNotify(long var0, FirableMvmEvent var2, Class<?> var3, Method var4);

        private static native void nativeFlush(long var0);
    }

    private static interface NativeMethods {
        public void addListener(MvmListener<?> var1, Class<?> var2, String var3, Method var4, Method var5);

        public void removeListener(MvmListener<?> var1, String var2);

        public void notify(FirableMvmEvent var1, Class<?> var2, Method var3);

        public void flush();
    }
}

