/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mvm.exec;

import com.mathworks.mvm.exec.FutureResult;
import com.mathworks.mvm.exec.MvmExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;

public abstract class MvmSwingWorker<V> {
    private final FutureResult<V> fResult;
    private AtomicBoolean fWorkerQueued = new AtomicBoolean();

    public MvmSwingWorker(FutureResult<V> futureResult) {
        this.fResult = futureResult;
    }

    protected abstract void done();

    protected V get() throws MvmExecutionException, IllegalStateException {
        if (!this.fResult.isDone()) {
            throw new IllegalStateException("MvmSwingWorker's get() called before command completed");
        }
        try {
            return this.fResult.get();
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("MvmSwingWorker's get() was interrupted");
        }
    }

    public void runWhenReady() {
        if (this.fWorkerQueued.compareAndSet(false, true)) {
            this.fResult.runWhenDone(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MvmSwingWorker.this.done();
                        }
                    });
                }
            });
        }
    }
}

