/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.rmi.server.RMIClassLoader;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.jeri.BasicInvocationHandler;
import net.jini.jeri.BasicObjectEndpoint;
import net.jini.security.Security;
import net.jini.security.TrustVerifier;

public class BasicJeriTrustVerifier
implements TrustVerifier {
    public boolean isTrustedObject(Object object, final TrustVerifier.Context context) throws RemoteException {
        if (object == null || context == null) {
            throw new NullPointerException();
        }
        if (object instanceof RemoteMethodControl) {
            final Class<?> clazz = object.getClass();
            if (Proxy.isProxyClass(clazz)) {
                try {
                    Security.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ClassLoader classLoader = context.getClassLoader();
                            if (classLoader == null) {
                                classLoader = Thread.currentThread().getContextClassLoader();
                            }
                            if (!BasicJeriTrustVerifier.covers(classLoader, clazz.getClassLoader())) {
                                Security.verifyCodebaseIntegrity(RMIClassLoader.getClassAnnotation(clazz), classLoader);
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    return false;
                }
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
                if (invocationHandler.getClass() == BasicInvocationHandler.class) {
                    BasicInvocationHandler basicInvocationHandler = (BasicInvocationHandler)invocationHandler;
                    MethodConstraints methodConstraints = basicInvocationHandler.getServerConstraints();
                    return context.isTrustedObject(basicInvocationHandler.getObjectEndpoint()) && context.isTrustedObject(methodConstraints);
                }
            }
        } else if (object.getClass() == BasicObjectEndpoint.class) {
            BasicObjectEndpoint basicObjectEndpoint = (BasicObjectEndpoint)object;
            return context.isTrustedObject(basicObjectEndpoint.getEndpoint());
        }
        return false;
    }

    private static boolean covers(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader2 == null) {
            return true;
        }
        if (classLoader == null) {
            return false;
        }
        do {
            if (classLoader != classLoader2) continue;
            return true;
        } while ((classLoader = classLoader.getParent()) != null);
        return false;
    }
}

