/*
 * Decompiled with CFR 0.152.
 */
package net.jini.loader;

import java.net.MalformedURLException;
import java.rmi.server.RMIClassLoader;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.WeakHashMap;
import net.jini.security.Security;

public final class ClassLoading {
    private static final ThreadLocal perThreadCache = new ThreadLocal(){

        protected Object initialValue() {
            return new WeakHashMap();
        }
    };

    public static Class loadClass(final String string, String string2, final ClassLoader classLoader, boolean bl, final ClassLoader classLoader2) throws MalformedURLException, ClassNotFoundException {
        final Class<?> clazz = RMIClassLoader.loadClass(string, string2, classLoader);
        if (bl && string != null) {
            try {
                Security.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MalformedURLException, ClassNotFoundException {
                        ClassLoading.verifyIntegrity(clazz, string, classLoader, classLoader2);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof MalformedURLException) {
                    throw (MalformedURLException)throwable;
                }
                throw (ClassNotFoundException)throwable;
            }
        }
        return clazz;
    }

    public static Class loadProxyClass(final String string, String[] stringArray, final ClassLoader classLoader, boolean bl, final ClassLoader classLoader2) throws MalformedURLException, ClassNotFoundException {
        final Class<?> clazz = RMIClassLoader.loadProxyClass(string, stringArray, classLoader);
        if (bl && string != null) {
            try {
                Security.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MalformedURLException, ClassNotFoundException {
                        Class<?>[] classArray = clazz.getInterfaces();
                        for (int i = 0; i < classArray.length && !ClassLoading.verifyIntegrity(classArray[i], string, classLoader, classLoader2); ++i) {
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof MalformedURLException) {
                    throw (MalformedURLException)throwable;
                }
                throw (ClassNotFoundException)throwable;
            }
        }
        return clazz;
    }

    private static boolean verifyIntegrity(Class clazz, String string, ClassLoader classLoader, ClassLoader classLoader2) throws MalformedURLException, ClassNotFoundException {
        ClassLoader classLoader3;
        ClassLoader classLoader4;
        ClassLoader classLoader5 = clazz.getClassLoader();
        Map map = (Map)perThreadCache.get();
        WeakHashMap weakHashMap = (WeakHashMap)map.get(classLoader4 = classLoader2 != null ? classLoader2 : Thread.currentThread().getContextClassLoader());
        if (weakHashMap != null && weakHashMap.containsKey(classLoader5)) {
            return true;
        }
        if (!(ClassLoading.covers(classLoader, classLoader5) || classLoader != (classLoader3 = Thread.currentThread().getContextClassLoader()) && ClassLoading.covers(classLoader3, classLoader5))) {
            try {
                Security.verifyCodebaseIntegrity(string, classLoader2);
            }
            catch (SecurityException securityException) {
                throw new ClassNotFoundException(clazz.getName(), securityException);
            }
            if (weakHashMap == null) {
                weakHashMap = new WeakHashMap();
                map.put(classLoader4, weakHashMap);
            }
            weakHashMap.put(classLoader5, null);
            return true;
        }
        return false;
    }

    private static boolean covers(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader2 == null) {
            return true;
        }
        if (classLoader == null) {
            return false;
        }
        do {
            if (classLoader != classLoader2) continue;
            return true;
        } while ((classLoader = classLoader.getParent()) != null);
        return false;
    }

    private ClassLoading() {
        throw new AssertionError();
    }
}

