/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security.proxytrust;

import com.sun.jini.jeri.internal.runtime.Util;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.security.proxytrust.ProxyTrust;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;
import net.jini.security.proxytrust.TrustEquivalence;

public final class ProxyTrustInvocationHandler
implements InvocationHandler,
TrustEquivalence,
Serializable {
    private static final long serialVersionUID = -3270029468290295063L;
    private static final Class[] consArgs = new Class[]{InvocationHandler.class};
    private final RemoteMethodControl main;
    private final ProxyTrust boot;

    public ProxyTrustInvocationHandler(RemoteMethodControl remoteMethodControl, ProxyTrust proxyTrust) {
        if (remoteMethodControl == null || proxyTrust == null) {
            throw new NullPointerException("arguments cannot be null");
        }
        if (!(remoteMethodControl instanceof TrustEquivalence)) {
            throw new IllegalArgumentException("main proxy must implement TrustEquivalence");
        }
        if (!(proxyTrust instanceof RemoteMethodControl)) {
            throw new IllegalArgumentException("bootstrap proxy must implement RemoteMethodControl");
        }
        if (!(proxyTrust instanceof TrustEquivalence)) {
            throw new IllegalArgumentException("bootstrap proxy must implement TrustEquivalence");
        }
        this.main = remoteMethodControl;
        this.boot = proxyTrust;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Class<?> clazz = method.getDeclaringClass();
        if (clazz == Object.class) {
            String string = method.getName();
            if (string.equals("equals")) {
                Object object2 = objectArray[0];
                if (object == object2 || object2 != null && Util.sameProxyClass(object, object2) && this.equals(Proxy.getInvocationHandler(object2))) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (string.equals("toString")) {
                return this.proxyToString(object);
            }
            if (string.equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            throw new IllegalArgumentException("unexpected Object method");
        }
        if (clazz == RemoteMethodControl.class && method.getName().equals("setConstraints")) {
            if (Proxy.getInvocationHandler(object) != this) {
                throw new IllegalArgumentException("wrong invocation handler");
            }
            ProxyTrustInvocationHandler proxyTrustInvocationHandler = new ProxyTrustInvocationHandler((RemoteMethodControl)this.invoke0(method, objectArray), this.boot);
            return Proxy.newProxyInstance(object.getClass().getClassLoader(), object.getClass().getInterfaces(), (InvocationHandler)proxyTrustInvocationHandler);
        }
        if (clazz == TrustEquivalence.class) {
            if (!method.getName().equals("checkTrustEquivalence")) {
                throw new AssertionError((Object)"unknown TrustEquivalence method");
            }
            Object object3 = objectArray[0];
            if (object == object3 || object3 != null && Util.sameProxyClass(object, object3) && this.checkTrustEquivalence(Proxy.getInvocationHandler(object3))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return this.invoke0(method, objectArray);
    }

    private Object invoke0(Method method, Object[] objectArray) throws Throwable {
        Class<?> clazz;
        Class<?> clazz2 = method.getDeclaringClass();
        if (!Modifier.isPublic(clazz2.getModifiers()) && Modifier.isPublic((clazz = this.main.getClass()).getModifiers()) && clazz2.isInstance(this.main)) {
            try {
                method = clazz.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return method.invoke((Object)this.main, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException().initCause(illegalAccessException);
        }
    }

    public boolean checkTrustEquivalence(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProxyTrustInvocationHandler)) {
            return false;
        }
        ProxyTrustInvocationHandler proxyTrustInvocationHandler = (ProxyTrustInvocationHandler)object;
        return ((TrustEquivalence)((Object)this.main)).checkTrustEquivalence(proxyTrustInvocationHandler.main) && ((TrustEquivalence)((Object)this.boot)).checkTrustEquivalence(proxyTrustInvocationHandler.boot);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProxyTrustInvocationHandler)) {
            return false;
        }
        ProxyTrustInvocationHandler proxyTrustInvocationHandler = (ProxyTrustInvocationHandler)object;
        return this.main.equals(proxyTrustInvocationHandler.main) && this.boot.equals(proxyTrustInvocationHandler.boot);
    }

    public int hashCode() {
        return this.main.hashCode() + this.boot.hashCode();
    }

    public String toString() {
        return "ProxyTrustInvocationHandler[main: " + this.main + ", boot: " + this.boot + "]";
    }

    private String proxyToString(Object object) {
        Class<?>[] classArray = object.getClass().getInterfaces();
        Class<?> clazz = null;
        int n = classArray.length;
        while (--n >= 0 && classArray[n] != (class$net$jini$core$constraint$RemoteMethodControl == null ? ProxyTrustInvocationHandler.class$("net.jini.core.constraint.RemoteMethodControl") : class$net$jini$core$constraint$RemoteMethodControl)) {
            clazz = classArray[n];
        }
        if (clazz == null) {
            return "Proxy[" + this + "]";
        }
        String string = clazz.getName();
        int n2 = string.lastIndexOf(46);
        if (n2 >= 0) {
            string = string.substring(n2 + 1);
        }
        return "Proxy[" + string + "," + this + "]";
    }

    protected ProxyTrustIterator getProxyTrustIterator() {
        return new SingletonProxyTrustIterator(this.boot);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (!(this.main instanceof TrustEquivalence)) {
            throw new InvalidObjectException("main proxy must implement TrustEquivalence");
        }
        if (!(this.boot instanceof RemoteMethodControl)) {
            throw new InvalidObjectException("bootstrap proxy must implement RemoteMethodControl");
        }
        if (!(this.boot instanceof TrustEquivalence)) {
            throw new InvalidObjectException("bootstrap proxy must implement TrustEquivalence");
        }
    }
}

