/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.modules;

import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.EncryptedObject;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.modules.CryptoModuleHelper;
import com.mathworks.toolbox.distcomp.auth.modules.SymmetricKeyProvider;
import java.security.Key;

public final class StorageAESCryptoModule
implements CryptoModule {
    private final Key fKey;

    public StorageAESCryptoModule(SymmetricKeyProvider symmetricKeyProvider) throws CryptoException {
        this.fKey = symmetricKeyProvider.getKey();
    }

    @Override
    public CryptoModule.Encryptor getEncryptor() throws CryptoException {
        return new AESStorageEncryptor(this.fKey);
    }

    @Override
    public CryptoModule.Decryptor getDecryptor() throws CryptoException {
        return new AESStorageDecryptor(this.fKey);
    }

    @Override
    public byte[] createSalt(int n) {
        return CryptoModuleHelper.INSTANCE.createSalt(n);
    }

    static {
        CryptoModuleHelper.INSTANCE.initialize();
    }

    private static final class AESStorageDecryptor
    implements CryptoModule.Decryptor {
        private final Key iAESStorageKey;

        private AESStorageDecryptor(Key key) {
            this.iAESStorageKey = key;
        }

        @Override
        public Erasable decrypt(EncryptedObject encryptedObject) throws CryptoException {
            return new Erasable(CryptoModuleHelper.INSTANCE.decryptSymmetric(encryptedObject, this.iAESStorageKey));
        }

        @Override
        public Erasable decryptWithSalt(EncryptedObject encryptedObject, byte[] byArray) throws CryptoException {
            Erasable erasable = this.decrypt(encryptedObject);
            return CryptoModuleHelper.INSTANCE.removeSalt(erasable, byArray);
        }
    }

    private static final class AESStorageEncryptor
    implements CryptoModule.Encryptor {
        private final transient Key iAESStorageKey;

        private AESStorageEncryptor(Key key) {
            this.iAESStorageKey = key;
        }

        @Override
        public EncryptedObject encrypt(Erasable erasable) throws CryptoException {
            return CryptoModuleHelper.INSTANCE.encryptSymmetric(erasable.get(), this.iAESStorageKey);
        }

        @Override
        public EncryptedObject encryptWithSalt(Erasable erasable, byte[] byArray) throws CryptoException {
            return this.encrypt(CryptoModuleHelper.INSTANCE.addSalt(erasable, byArray));
        }
    }
}

