/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.clusteraccess;

import com.mathworks.toolbox.distcomp.clusteraccess.FileMirrorControl;
import com.mathworks.toolbox.distcomp.clusteraccess.Log;
import com.mathworks.toolbox.distcomp.clusteraccess.RemoteMachineChore;
import com.mathworks.toolbox.distcomp.clusteraccess.RemoteMachineException;
import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.Future;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.spi.Protocol;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

abstract class OneTimeChore
implements RemoteMachineChore {
    private final FileMirrorControl fFileMirrorControl;
    private final String fHostname;
    private final ParameterMap fParameterMap;
    private Lock fLock = new ReentrantLock();
    private Condition fFutureSet = this.fLock.newCondition();
    private Condition fCompleted = this.fLock.newCondition();
    private Future fFuture = null;
    private boolean fCanceled = false;
    private boolean fComplete = false;
    private boolean fSuccessful = false;
    private final List<Throwable> fThrowables = new ArrayList<Throwable>();

    OneTimeChore(String string, ParameterMap parameterMap, FileMirrorControl fileMirrorControl) {
        this.fHostname = string;
        this.fParameterMap = parameterMap;
        this.fFileMirrorControl = fileMirrorControl;
    }

    String getHostname() {
        return this.fHostname;
    }

    ParameterMap getParameterMap() {
        return this.fParameterMap;
    }

    FileMirrorControl getFileMirrorControl() {
        return this.fFileMirrorControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Log.LOGGER.fine(this.logPrefix() + " started");
        try {
            boolean bl = this.runChore();
            this.completedRun(bl);
        }
        catch (RemoteMachineException remoteMachineException) {
            this.addThrowable(remoteMachineException);
            this.completedRun(false);
        }
        catch (RuntimeException runtimeException) {
            this.addThrowable(runtimeException);
            this.completedRun(false);
        }
        finally {
            this.fFileMirrorControl.oneTimeChoreCompleted(this);
        }
    }

    abstract boolean runChore() throws RemoteMachineException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addThrowable(Throwable throwable) {
        this.fLock.lock();
        try {
            Log.LOGGER.log(Level.WARNING, this.logPrefix(), throwable);
            this.fThrowables.add(throwable);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Log.LOGGER.finest(this.logPrefix() + "cancel started");
        this.fLock.lock();
        try {
            this.fCanceled = true;
            if (this.fFuture != null) {
                this.fFuture.cancel();
                Log.LOGGER.finest(this.logPrefix() + "future canceled");
            }
            this.fFutureSet.signalAll();
            this.fCompleted.signalAll();
            Log.LOGGER.finest(this.logPrefix() + "signaled waiters");
        }
        finally {
            this.fLock.unlock();
        }
        Log.LOGGER.fine(this.logPrefix() + "canceled.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasBeenCanceled() {
        this.fLock.lock();
        try {
            boolean bl = this.fCanceled;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasBeenCompleted() {
        this.fLock.lock();
        try {
            boolean bl = this.fComplete;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completedRun(boolean bl) {
        this.fLock.lock();
        try {
            this.fComplete = true;
            this.fSuccessful = bl;
            this.fCompleted.signalAll();
        }
        finally {
            this.fLock.unlock();
        }
        Log.LOGGER.fine(this.logPrefix() + " completed successful? " + this.fSuccessful);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future getFuture() throws InterruptedException {
        this.fLock.lock();
        try {
            if (!this.hasBeenCanceled() && !this.hasBeenCompleted()) {
                while (this.fFuture == null) {
                    Log.LOGGER.finest(this.logPrefix() + " waiting for future to be set");
                    this.fFutureSet.await();
                    Log.LOGGER.finest(this.logPrefix() + " finished waiting for future, got " + this.fFuture);
                }
            }
            Future future = this.fFuture;
            return future;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performRemoteCommand(Command command, Protocol protocol, String string) throws DispatchException {
        this.fLock.lock();
        try {
            if (!this.hasBeenCanceled()) {
                Log.LOGGER.finest(this.logPrefix() + "Starting " + string);
                Future future = protocol.execute(command, this.fHostname, this.fParameterMap);
                this.setFuture(future);
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFuture(Future future) {
        this.fLock.lock();
        try {
            this.fFuture = future;
            this.fFutureSet.signalAll();
            Log.LOGGER.finest(this.logPrefix() + "set future to " + this.fFuture);
        }
        finally {
            this.fLock.unlock();
        }
    }

    void awaitEndOfFuture() throws FulfillmentException, InterruptedException {
        if (!this.hasBeenCanceled()) {
            Future future = this.getFuture();
            Log.LOGGER.finest(this.logPrefix() + "started waiting for " + future);
            future.awaitEnd();
            Log.LOGGER.finest(this.logPrefix() + "finished waiting for " + future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitEnd() throws InterruptedException, RemoteMachineException {
        this.fLock.lock();
        try {
            while (!this.hasBeenCompleted() && !this.hasBeenCanceled()) {
                Log.LOGGER.finest(this.logPrefix() + "started waiting for complete");
                this.fCompleted.await();
                Log.LOGGER.finest(this.logPrefix() + "finished waiting for complete");
            }
            boolean bl = this.fSuccessful;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public boolean hasEnded() {
        return this.hasBeenCompleted() || this.hasBeenCanceled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Throwable> getProblems() {
        this.fLock.lock();
        try {
            ArrayList<Throwable> arrayList = new ArrayList<Throwable>(this.fThrowables);
            return arrayList;
        }
        finally {
            this.fLock.unlock();
        }
    }
}

