/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.toolbox.distcomp.control.ConfigRunner;
import com.mathworks.toolbox.distcomp.control.ControlStartStopProcessInfo;
import com.mathworks.toolbox.distcomp.control.DisplayableResultsImpl;
import com.mathworks.toolbox.distcomp.control.MDCSCommand;
import com.mathworks.toolbox.distcomp.control.MDCSCommandResults;
import com.mathworks.toolbox.distcomp.util.RemoteConfigurationFileOverride;
import com.mathworks.toolbox.distcomp.util.SystemPropertyNames;
import com.mathworks.toolbox.distcomp.util.WarningAndNoteInfo;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public abstract class ControlStartStopProcess
extends MDCSCommand {
    private static final long serialVersionUID = 1L;
    private RemoteConfigurationFileOverride fServiceName;
    private RemoteConfigurationFileOverride fClean;
    private String fConfigFile;
    private ConfigRunner fConfigRunner;
    private boolean fIsStarting;

    private String getConfigFile() {
        String string = "com.mathworks.toolbox.distcomp.configbase";
        String string2 = System.getProperty(string);
        if (string2 == null) {
            throw new IllegalStateException("System property not defined: " + string);
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        return string2 + this.fConfigFile;
    }

    protected abstract String getDefaultServiceName();

    protected void addConfigFileOverride(List<String> list) {
        list.add(this.fServiceName.getConfigEntryOverride());
        list.add(this.fClean.getConfigEntryOverride());
    }

    protected ControlStartStopProcess() {
    }

    ControlStartStopProcess(ConfigRunner configRunner, boolean bl, String string, String string2) {
        this.fConfigRunner = configRunner;
        this.fIsStarting = bl;
        this.fServiceName = new RemoteConfigurationFileOverride(SystemPropertyNames.SERVICE_NAME, string2);
        this.fClean = new RemoteConfigurationFileOverride(SystemPropertyNames.CLEAN_CHECKPOINT_INFO);
        this.fConfigFile = string;
    }

    public void setClean(boolean bl) {
        this.fClean.setValue(Boolean.toString(bl));
    }

    public boolean isStarting() {
        return this.fIsStarting;
    }

    public String getServiceName() {
        return this.fServiceName.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MDCSCommandResults run() throws Exception {
        WarningAndNoteInfo warningAndNoteInfo = new WarningAndNoteInfo();
        this.preRunSetup(warningAndNoteInfo);
        boolean bl = false;
        try {
            bl = this.fConfigRunner.run(warningAndNoteInfo, this.createConfigFileOptions());
        }
        finally {
            this.postRunTeardown();
        }
        String string = bl ? this.getInfo().getSuccessDescription() : this.getInfo().getNotNeededDescription();
        String string2 = null;
        return new DisplayableResultsImpl(string2, warningAndNoteInfo, string);
    }

    private String[] createConfigFileOptions() {
        LinkedList<String> linkedList = new LinkedList<String>();
        this.addConfigFileOverride(linkedList);
        linkedList.add(0, this.getConfigFile());
        return linkedList.toArray(new String[linkedList.size()]);
    }

    protected void preRunSetup(WarningAndNoteInfo warningAndNoteInfo) {
        this.fServiceName.setDefaultValue(this.getDefaultServiceName());
        this.getInfo().setServiceName(this.fServiceName.getValue());
    }

    protected void postRunTeardown() {
    }

    public abstract ControlStartStopProcessInfo getInfo();

    @Override
    public String getPreRunDescription() {
        return this.getInfo().getPreRunDescription();
    }

    @Override
    public int maxTimeForRemoteTries() {
        return 60000;
    }

    @Override
    public int timeBetweenTriesInMilliSeconds() {
        return 5000;
    }

    public String toString() {
        String string = this.fIsStarting ? "start" : "stop";
        return "ControlStartStopProcess " + string + " for " + this.fServiceName + " using config file " + this.fConfigFile + " and config runner " + this.fConfigFile + " " + this.fClean.getValue();
    }
}

