/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client;

import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.Log;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.RemoteMDCEInstallationFailedException;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.RemoteMDCEServiceAlreadyRunningException;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.RemoteMDCEStartFailedException;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.RemoteMDCEStopFailedException;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.RemoteMDCEUninstallationFailedException;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsRemoteExecutionException;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsServiceControl;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsServiceControlError;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsServiceControlException;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsServiceState;
import com.mathworks.util.PlatformInfo;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;

final class WindowsRemoteExecutionSession {
    private static final String SERVICE_NAME = "MDCS Remote Execution Service";
    private final WindowsServiceControl fServiceControl;
    private final String fServiceCmdLine;
    private final long fStoppedTimeoutMillis;
    private final String fLogId;
    private final String fRemoteHostName;
    private final String fRemoteMATLABRoot;

    WindowsRemoteExecutionSession(String string, int n, UUID uUID, String string2, long l) {
        assert (PlatformInfo.isWindows()) : "WindowsRemoteExecutionSession can only be used on Windows";
        this.fRemoteHostName = string;
        this.fRemoteMATLABRoot = string2;
        this.fServiceControl = new WindowsServiceControl(string);
        this.fServiceCmdLine = WindowsRemoteExecutionSession.createServiceCmdLine(string2, n, uUID);
        this.fStoppedTimeoutMillis = l;
        this.fLogId = "WindowsRemoteExecutionSession (RemoteHost:" + string + "): ";
    }

    void start() throws WindowsRemoteExecutionException {
        try {
            this.installService();
        }
        catch (WindowsServiceControlException windowsServiceControlException) {
            WindowsServiceControlError windowsServiceControlError = windowsServiceControlException.getError();
            if (windowsServiceControlError == WindowsServiceControlError.SERVICE_ALREADY_INSTALLED) {
                Log.LOGGER.fine(this.fLogId + "Installation failed - Remote Execution Service is already installed.");
                this.handleServiceAlreadyInstalled();
            }
            if (windowsServiceControlError == WindowsServiceControlError.MARKED_FOR_DELETION) {
                Log.LOGGER.fine(this.fLogId + "Installation failed - Remote Execution Service is marked for deletion.");
                this.handleServiceAlreadyInstalled();
            }
            throw new RemoteMDCEInstallationFailedException(this.fRemoteHostName, windowsServiceControlException);
        }
        try {
            this.startService();
        }
        catch (WindowsServiceControlException windowsServiceControlException) {
            try {
                this.uninstallService();
            }
            catch (WindowsServiceControlException windowsServiceControlException2) {
                Log.LOGGER.log(Level.SEVERE, this.fLogId + "Uninstall failed", windowsServiceControlException2);
            }
            throw new RemoteMDCEStartFailedException(this.fRemoteHostName, windowsServiceControlException);
        }
    }

    void stop() throws WindowsRemoteExecutionException {
        try {
            this.stopService();
        }
        catch (WindowsServiceControlException windowsServiceControlException) {
            throw new RemoteMDCEStopFailedException(this.fRemoteHostName, windowsServiceControlException);
        }
        try {
            this.uninstallService();
        }
        catch (WindowsServiceControlException windowsServiceControlException) {
            throw new RemoteMDCEUninstallationFailedException(this.fRemoteHostName, windowsServiceControlException);
        }
    }

    private void handleServiceAlreadyInstalled() throws WindowsRemoteExecutionException {
        try {
            WindowsServiceState windowsServiceState = this.queryServiceState();
            if (windowsServiceState == WindowsServiceState.NOT_INSTALLED) {
                Log.LOGGER.fine(this.fLogId + "Remote Execution Service does not appear to be installed.");
                this.installService();
            } else {
                if (windowsServiceState.isStartingOrRunning()) {
                    Log.LOGGER.fine(this.fLogId + "Remote Execution Service is " + (Object)((Object)windowsServiceState));
                    throw new RemoteMDCEServiceAlreadyRunningException(this.fRemoteHostName, WindowsServiceControlError.SERVICE_ALREADY_RUNNING);
                }
                if (windowsServiceState.isStoppingOrStopped()) {
                    Log.LOGGER.fine(this.fLogId + "Service is stopped (or stopping). Waiting to see if it goes away.");
                    this.handleAlreadyInstalledButStoppedService();
                } else {
                    Log.LOGGER.log(Level.SEVERE, this.fLogId + "Remote Execution Service is in unexpected state: " + (Object)((Object)windowsServiceState));
                    assert (false) : "Unexpected service state " + (Object)((Object)windowsServiceState);
                }
            }
        }
        catch (WindowsServiceControlException windowsServiceControlException) {
            throw new RemoteMDCEInstallationFailedException(this.fRemoteHostName, windowsServiceControlException);
        }
    }

    private void handleAlreadyInstalledButStoppedService() throws WindowsServiceControlException, WindowsRemoteExecutionException {
        WindowsServiceState windowsServiceState;
        try {
            windowsServiceState = this.waitForServiceState(WindowsServiceState.NOT_INSTALLED, this.fStoppedTimeoutMillis);
        }
        catch (InterruptedException interruptedException) {
            windowsServiceState = this.queryServiceState();
        }
        if (windowsServiceState == WindowsServiceState.NOT_INSTALLED) {
            Log.LOGGER.fine(this.fLogId + "Remote Execution Service is no longer installed.");
            this.installService();
        } else if (windowsServiceState.isStoppingOrStopped()) {
            Log.LOGGER.fine(this.fLogId + "After waiting, Remote Execution Service is still stopped (or stopping). Forcing uninstallation.");
            this.uninstallService();
            this.installService();
        } else {
            if (windowsServiceState.isStartingOrRunning()) {
                Log.LOGGER.fine(this.fLogId + "After waiting, Remote Execution Service is now is state: " + (Object)((Object)windowsServiceState));
                throw new RemoteMDCEServiceAlreadyRunningException(this.fRemoteHostName, WindowsServiceControlError.SERVICE_ALREADY_RUNNING);
            }
            Log.LOGGER.log(Level.SEVERE, this.fLogId + "Remote Execution Service is in unexpected state: " + (Object)((Object)windowsServiceState));
            assert (false) : "Unexpected service state " + (Object)((Object)windowsServiceState);
        }
    }

    private static String createServiceCmdLine(String string, int n, UUID uUID) {
        String string2 = string + "\\toolbox\\distcomp\\";
        String string3 = string2 + "bin\\util\\mdcedlauncher.bat";
        String string4 = string2 + "config\\wrapper-remoteexec.config";
        String string5 = "\\\"";
        String[] stringArray = new String[]{string5 + string3 + string5, "-s", string5 + string4 + string5, string5 + "set.CONFIGFILE=" + string4 + string5, string5 + "set.SERVICENAME=" + SERVICE_NAME + string5, string5 + "set.PORT=" + n + string5, string5 + "set.GROUP=" + uUID + string5};
        return WindowsRemoteExecutionSession.joinList(Arrays.asList(stringArray), ' ');
    }

    private static String joinList(List<String> list, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private void installService() throws WindowsServiceControlException {
        Log.LOGGER.info(this.fLogId + "Installing service '" + SERVICE_NAME + "'");
        Log.LOGGER.finest(this.fLogId + "binPath=" + this.fServiceCmdLine);
        this.fServiceControl.install(SERVICE_NAME, this.fServiceCmdLine);
    }

    private void startService() throws WindowsServiceControlException {
        Log.LOGGER.info(this.fLogId + "Starting service '" + SERVICE_NAME + "'");
        this.fServiceControl.start(SERVICE_NAME);
    }

    private WindowsServiceState queryServiceState() throws WindowsServiceControlException {
        Log.LOGGER.info(this.fLogId + "Querying state of service '" + SERVICE_NAME + "'");
        WindowsServiceState windowsServiceState = this.fServiceControl.query(SERVICE_NAME);
        Log.LOGGER.info(this.fLogId + "Service '" + SERVICE_NAME + "' is " + (Object)((Object)windowsServiceState));
        return windowsServiceState;
    }

    private void stopService() throws WindowsServiceControlException {
        Log.LOGGER.info(this.fLogId + "Stopping service '" + SERVICE_NAME + "'");
        this.fServiceControl.stop(SERVICE_NAME);
    }

    private void uninstallService() throws WindowsServiceControlException {
        Log.LOGGER.info(this.fLogId + "Uninstalling service '" + SERVICE_NAME + "'");
        this.fServiceControl.uninstall(SERVICE_NAME);
    }

    WindowsServiceState waitForServiceState(WindowsServiceState windowsServiceState, long l) throws WindowsServiceControlException, InterruptedException {
        Log.LOGGER.info(this.fLogId + "Waiting for service '" + SERVICE_NAME + "' to be " + (Object)((Object)windowsServiceState));
        return this.fServiceControl.waitForState(SERVICE_NAME, windowsServiceState, l);
    }

    public String toString() {
        return "WindowsRemoteExecutionSession{fServiceControl=" + this.fServiceControl + ", fServiceCmdLine='" + this.fServiceCmdLine + '\'' + ", fStoppedTimeoutMillis=" + this.fStoppedTimeoutMillis + ", fLogId='" + this.fLogId + '\'' + '}';
    }
}

