/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.server;

import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.Log;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.server.LocalExecutionMonitor;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.shared.RemoteExecutionCancelMessage;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.shared.RemoteExecutionCommandMessage;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.shared.RemoteExecutionMessage;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.shared.StreamSegmentMessage;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerDispatcher;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.ShellCommand;

final class PeerSCExecutorDispatcher
implements PeerDispatcher<RemoteExecutionMessage> {
    private final Instance fClient;
    private LocalExecutionMonitor fLocalExecutionMonitor = null;

    PeerSCExecutorDispatcher(Instance instance) {
        this.fClient = instance;
    }

    @Override
    public synchronized void initReturnGroup(ReturnGroup returnGroup) {
        if (this.fLocalExecutionMonitor != null) {
            assert (false) : "initReturnGroup() called more than one time.";
            Log.LOGGER.warning("initReturnGroup called a second time.");
        }
        this.fLocalExecutionMonitor = new LocalExecutionMonitor(this.fClient, returnGroup);
    }

    private synchronized LocalExecutionMonitor getLocalExecutionMonitor() {
        if (this.fLocalExecutionMonitor == null) {
            assert (false) : "getLocalExecutionMonitor() called before initReturnGroup()";
            Log.LOGGER.warning("getLocalExecutionMonitor() called before initReturnGroup().");
        }
        return this.fLocalExecutionMonitor;
    }

    @Override
    public void dispatch(RemoteExecutionMessage remoteExecutionMessage, Instance instance) {
        Log.LOGGER.finest("Got " + remoteExecutionMessage + " from " + instance);
        if (remoteExecutionMessage instanceof RemoteExecutionCommandMessage) {
            RemoteExecutionCommandMessage remoteExecutionCommandMessage = (RemoteExecutionCommandMessage)remoteExecutionMessage;
            Command command = remoteExecutionCommandMessage.getCommand();
            Log.LOGGER.finest("command is " + command);
            if (command instanceof ShellCommand) {
                ShellCommand shellCommand = (ShellCommand)command;
                this.getLocalExecutionMonitor().executeShellCommand(shellCommand, remoteExecutionCommandMessage.getParameterMap(), remoteExecutionCommandMessage.getSequenceNumber());
            } else {
                assert (false) : "command " + command + " " + command.getClass() + " not understood";
                Log.LOGGER.warning("command " + command + " " + command.getClass() + " not understood");
            }
        } else if (remoteExecutionMessage instanceof StreamSegmentMessage) {
            StreamSegmentMessage streamSegmentMessage = (StreamSegmentMessage)remoteExecutionMessage;
            this.getLocalExecutionMonitor().putStreamSegment(streamSegmentMessage.getOriginalSequenceNumber(), streamSegmentMessage.getStreamSegment());
        } else if (remoteExecutionMessage instanceof RemoteExecutionCancelMessage) {
            RemoteExecutionCancelMessage remoteExecutionCancelMessage = (RemoteExecutionCancelMessage)remoteExecutionMessage;
            long l = remoteExecutionCancelMessage.getSequenceNumber();
            this.getLocalExecutionMonitor().cancelCommand(l);
        } else {
            assert (false) : "message " + remoteExecutionMessage + " " + remoteExecutionMessage.getClass() + " not understood";
            Log.LOGGER.warning("message " + remoteExecutionMessage + " " + remoteExecutionMessage.getClass() + " not understood");
        }
    }
}

