/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.distcompobjects;

import com.mathworks.toolbox.distcomp.distcompobjects.PackageInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

abstract class EntityProxy {
    private static MessageDigest sDigest;
    private final Uuid fUuid;

    EntityProxy(String string) {
        this.fUuid = this.computeUuid(string);
    }

    public Uuid getID() {
        return this.fUuid;
    }

    protected Uuid computeUuid(String string) {
        byte[] byArray = sDigest.digest(string.getBytes(Charset.defaultCharset()));
        sDigest.reset();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            return UuidFactory.read((InputStream)byteArrayInputStream);
        }
        catch (IOException iOException) {
            return UuidFactory.create((long)0L, (long)0L);
        }
    }

    public int hashCode() {
        return this.fUuid.hashCode();
    }

    static {
        try {
            sDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Failed to create message digest.", noSuchAlgorithmException);
        }
    }
}

