/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.client;

import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.client.GDSClientWorkUnitAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ReadOnlyClientJobAccess;
import com.mathworks.toolbox.distcomp.mjs.client.WorkUnitLargeDataAccessor;
import com.mathworks.toolbox.distcomp.mjs.datastore.LargeData;
import com.mathworks.toolbox.distcomp.storage.DatabaseStorage;
import com.mathworks.toolbox.distcomp.workunit.JobImpl;
import java.rmi.RemoteException;
import java.util.Date;
import net.jini.id.Uuid;
import org.jetbrains.annotations.NotNull;

public class GDSClientJobAccess
extends GDSClientWorkUnitAccess
implements ReadOnlyClientJobAccess {
    private DatabaseStorage fDatabaseStorage;

    public GDSClientJobAccess(DatabaseStorage databaseStorage) {
        super(databaseStorage);
        this.fDatabaseStorage = databaseStorage;
    }

    @Override
    public LargeData[] getFileDepData(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        LargeData[] largeDataArray = new LargeData[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            largeDataArray[i] = WorkUnitLargeDataAccessor.getJobLargeData(jobImpl, WorkUnitLargeDataAccessor.createFileDepDataAccessor());
        }
        return largeDataArray;
    }

    @Override
    public LargeData[] getJobScopeData(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        LargeData[] largeDataArray = new LargeData[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            largeDataArray[i] = WorkUnitLargeDataAccessor.getJobLargeData(jobImpl, WorkUnitLargeDataAccessor.createJobScopeDataAccessor());
        }
        return largeDataArray;
    }

    @Override
    public LargeData[] getAttachedFilePaths(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        LargeData[] largeDataArray = new LargeData[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            largeDataArray[i] = WorkUnitLargeDataAccessor.getJobLargeData(jobImpl, WorkUnitLargeDataAccessor.createAttachedFilePathDataAccessor());
        }
        return largeDataArray;
    }

    @Override
    public String[][] getAuthorisedUsers(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        String[][] stringArray = new String[uuidArray.length][];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            stringArray[i] = jobImpl.getAuthorisedUsers();
        }
        return stringArray;
    }

    @Override
    public boolean[] getAutoAttachFiles(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        boolean[] blArray = new boolean[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            blArray[i] = jobImpl.getAutoAttachFiles();
        }
        return blArray;
    }

    @Override
    public String[][] getFileDepPathList(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        String[][] stringArray = new String[uuidArray.length][];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            stringArray[i] = jobImpl.getFileDepPathList();
        }
        return stringArray;
    }

    @Override
    public String[][] getAutoAttachedFileList(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        String[][] stringArray = new String[uuidArray.length][];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            stringArray[i] = jobImpl.getAutoAttachedFileList();
        }
        return stringArray;
    }

    @Override
    public int[] getMATLABExecutionMode(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        int[] nArray = new int[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            nArray[i] = jobImpl.getMATLABExecutionMode();
        }
        return nArray;
    }

    @Override
    public int[] getMaxWorkers(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        int[] nArray = new int[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            nArray[i] = jobImpl.getMaxWorkers();
        }
        return nArray;
    }

    @Override
    public int[] getMinWorkers(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        int[] nArray = new int[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            nArray[i] = jobImpl.getMinWorkers();
        }
        return nArray;
    }

    @Override
    public String[][] getPathList(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        String[][] stringArray = new String[uuidArray.length][];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            stringArray[i] = jobImpl.getPathList();
        }
        return stringArray;
    }

    @Override
    public byte[][] getProductList(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        byte[][] byArrayArray = new byte[uuidArray.length][];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            byArrayArray[i] = jobImpl.getProductList();
        }
        return byArrayArray;
    }

    @Override
    public Date[] getSubmitTime(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        Date[] dateArray = new Date[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            dateArray[i] = jobImpl.getSubmitTime();
        }
        return dateArray;
    }

    @Override
    public String[] getTag(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        String[] stringArray = new String[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            stringArray[i] = jobImpl.getTag();
        }
        return stringArray;
    }

    @Override
    public String[] getApiTag(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        String[] stringArray = new String[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            stringArray[i] = jobImpl.getApiTag();
        }
        return stringArray;
    }

    @Override
    public Uuid[][] getTasks(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        Uuid[][] uuidArrayArray = new Uuid[uuidArray.length][];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            uuidArrayArray[i] = jobImpl.getTasks();
        }
        return uuidArrayArray;
    }

    @Override
    public Uuid[][][] getTasks(@NotNull Uuid[] uuidArray, int[][] nArray) throws RemoteException, MJSException {
        Uuid[][][] uuidArrayArray = new Uuid[uuidArray.length][][];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            uuidArrayArray[i] = jobImpl.getTasks(nArray[i]);
        }
        return uuidArrayArray;
    }

    @Override
    public String[] getUserName(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        String[] stringArray = new String[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            stringArray[i] = jobImpl.getUserName();
        }
        return stringArray;
    }

    @Override
    public boolean[] isRestartWorker(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        boolean[] blArray = new boolean[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            JobImpl jobImpl = (JobImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            blArray[i] = jobImpl.isRestartWorker();
        }
        return blArray;
    }
}

