/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.client;

import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.client.GDSClientWorkUnitAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ReadOnlyClientTaskAccess;
import com.mathworks.toolbox.distcomp.mjs.client.WorkUnitLargeDataAccessor;
import com.mathworks.toolbox.distcomp.mjs.datastore.LargeData;
import com.mathworks.toolbox.distcomp.storage.DatabaseStorage;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.mathworks.toolbox.distcomp.worker.WorkerProperties;
import com.mathworks.toolbox.distcomp.workunit.FailedTaskInfo;
import com.mathworks.toolbox.distcomp.workunit.Task;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import com.mathworks.toolbox.distcomp.workunit.TaskInfo;
import java.rmi.RemoteException;
import net.jini.id.Uuid;
import org.jetbrains.annotations.NotNull;

public class GDSClientTaskAccess
extends GDSClientWorkUnitAccess
implements ReadOnlyClientTaskAccess {
    private DatabaseStorage fDatabaseStorage;

    public GDSClientTaskAccess(DatabaseStorage databaseStorage) {
        super(databaseStorage);
        this.fDatabaseStorage = databaseStorage;
    }

    @Override
    public String[][] getAutoAttachedFileList(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        String[][] stringArray = new String[uuidArray.length][];
        for (int i = 0; i < uuidArray.length; ++i) {
            TaskImpl taskImpl = (TaskImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            stringArray[i] = taskImpl.getAutoAttachedFileList();
        }
        return stringArray;
    }

    @Override
    public LargeData[] getCommandWindowOutput(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        LargeData[] largeDataArray = new LargeData[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            TaskImpl taskImpl = (TaskImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            largeDataArray[i] = WorkUnitLargeDataAccessor.getTaskLargeData(taskImpl, WorkUnitLargeDataAccessor.createCommandWindowOutputDataAccessor());
        }
        return largeDataArray;
    }

    @Override
    public LargeData[] getInputData(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        LargeData[] largeDataArray = new LargeData[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            TaskImpl taskImpl = (TaskImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            largeDataArray[i] = WorkUnitLargeDataAccessor.getTaskLargeData(taskImpl, WorkUnitLargeDataAccessor.createInputDataAccessor());
        }
        return largeDataArray;
    }

    @Override
    public String[] getLogOutput(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        String[] stringArray = new String[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            TaskImpl taskImpl = (TaskImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            byte[] byArray = taskImpl.getLogOutput();
            if (byArray == null) continue;
            stringArray[i] = new String(byArray, TaskImpl.LOG_ENCODING);
        }
        return stringArray;
    }

    @Override
    public LargeData[] getMLFunction(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        LargeData[] largeDataArray = new LargeData[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            TaskImpl taskImpl = (TaskImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            largeDataArray[i] = WorkUnitLargeDataAccessor.getTaskLargeData(taskImpl, WorkUnitLargeDataAccessor.createMLFunctionDataAccessor());
        }
        return largeDataArray;
    }

    @Override
    public LargeData[] getOutputData(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        LargeData[] largeDataArray = new LargeData[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            TaskImpl taskImpl = (TaskImpl)this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            largeDataArray[i] = WorkUnitLargeDataAccessor.getTaskLargeData(taskImpl, WorkUnitLargeDataAccessor.createOutputDataAccessor());
        }
        return largeDataArray;
    }

    @Override
    public TaskInfo[][] getFailedAttemptInformation(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        TaskInfo[][] taskInfoArray = new TaskInfo[uuidArray.length][];
        for (int i = 0; i < uuidArray.length; ++i) {
            Task task = (Task)((Object)this.fDatabaseStorage.readWorkUnit(uuidArray[i]));
            FailedTaskInfo[] failedTaskInfoArray = task.getFailedAttemptInformation();
            taskInfoArray[i] = new TaskInfo[failedTaskInfoArray.length];
            for (int j = 0; j < failedTaskInfoArray.length; ++j) {
                TaskInfo taskInfo = failedTaskInfoArray[j].toTaskInfo();
                taskInfo.setCommandWindowOutput((new LargeData[]{taskInfo.getCommandWindowOutput()})[0]);
                taskInfoArray[i][j] = failedTaskInfoArray[j].toTaskInfo();
            }
        }
        return taskInfoArray;
    }

    @Override
    public boolean[] getCaptureCommandWindowOutput(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        boolean[] blArray = new boolean[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            Task task = (Task)((Object)this.fDatabaseStorage.readWorkUnit(uuidArray[i]));
            blArray[i] = task.isCaptureCommandWindowOutput();
        }
        return blArray;
    }

    @Override
    public int[] getNumOutArgs(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        int[] nArray = new int[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            Task task = (Task)((Object)this.fDatabaseStorage.readWorkUnit(uuidArray[i]));
            nArray[i] = task.getNumOutArgs();
        }
        return nArray;
    }

    @Override
    public byte[][] getErrorStruct(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        byte[][] byArrayArray = new byte[uuidArray.length][];
        for (int i = 0; i < uuidArray.length; ++i) {
            Task task = (Task)((Object)this.fDatabaseStorage.readWorkUnit(uuidArray[i]));
            byArrayArray[i] = task.getErrorStruct();
        }
        return byArrayArray;
    }

    @Override
    public String[] getErrorMessage(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        String[] stringArray = new String[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            Task task = (Task)((Object)this.fDatabaseStorage.readWorkUnit(uuidArray[i]));
            stringArray[i] = task.getErrorMessage();
        }
        return stringArray;
    }

    @Override
    public String[] getErrorIdentifier(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        String[] stringArray = new String[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            Task task = (Task)((Object)this.fDatabaseStorage.readWorkUnit(uuidArray[i]));
            stringArray[i] = task.getErrorIdentifier();
        }
        return stringArray;
    }

    @Override
    public Worker[] getWorker(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        Worker[] workerArray = new Worker[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            Task task = (Task)((Object)this.fDatabaseStorage.readWorkUnit(uuidArray[i]));
            workerArray[i] = task.getWorker();
        }
        return workerArray;
    }

    @Override
    public WorkerProperties[] getWorkerProperties(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        WorkerProperties[] workerPropertiesArray = new WorkerProperties[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            Task task = (Task)((Object)this.fDatabaseStorage.readWorkUnit(uuidArray[i]));
            Worker worker = task.getWorker();
            if (worker == null) continue;
            workerPropertiesArray[i] = task.getWorker().getWorkerProperties();
        }
        return workerPropertiesArray;
    }

    @Override
    public Uuid[] getJob(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        Uuid[] uuidArray2 = new Uuid[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            Task task = (Task)((Object)this.fDatabaseStorage.readWorkUnit(uuidArray[i]));
            uuidArray2[i] = task.getJob();
        }
        return uuidArray2;
    }

    @Override
    public int[] getLogLevel(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        int[] nArray = new int[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            Task task = (Task)((Object)this.fDatabaseStorage.readWorkUnit(uuidArray[i]));
            nArray[i] = task.getLogLevel();
        }
        return nArray;
    }

    @Override
    public String[] getMLFunctionName(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        String[] stringArray = new String[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            Task task = (Task)((Object)this.fDatabaseStorage.readWorkUnit(uuidArray[i]));
            stringArray[i] = task.getMLFunctionName();
        }
        return stringArray;
    }

    @Override
    public int[] getMaximumNumberOfRetries(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        int[] nArray = new int[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            Task task = (Task)((Object)this.fDatabaseStorage.readWorkUnit(uuidArray[i]));
            nArray[i] = task.getMaximumNumberOfRetries();
        }
        return nArray;
    }

    @Override
    public int[] getAttemptedNumberOfRetries(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        int[] nArray = new int[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            Task task = (Task)((Object)this.fDatabaseStorage.readWorkUnit(uuidArray[i]));
            nArray[i] = task.getAttemptedNumberOfRetries();
        }
        return nArray;
    }
}

