/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.jidesoft.swing.StyledLabel;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MPopup;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.toolbox.distcomp.parallelui.Actions;
import com.mathworks.toolbox.distcomp.parallelui.HyperLinkScanner;
import com.mathworks.toolbox.distcomp.parallelui.OutputCollection;
import com.mathworks.toolbox.distcomp.parallelui.OutputComponent;
import com.mathworks.toolbox.distcomp.parallelui.OutputHyperLink;
import com.mathworks.toolbox.distcomp.parallelui.OutputWindow;
import com.mathworks.toolbox.distcomp.parallelui.ParallelUI;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.action.AbstractCopyAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ParagraphView;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

class OutputTextPane
extends MJTextPane
implements Actions.Contributor,
OutputComponent {
    private OutputWindow fOutputWindow;
    private Color fAltBackground;
    private Color fAltReference;
    private Color fCommandBackground;
    private Color fCommandReference;
    private DocumentListener fDocumentListener;
    private boolean fShowCommandText = true;
    private Object fCommandHighlight;
    private int fHighlightStart = -1;
    private Timer fHighlightTimer;
    private MJAbstractAction fCopyAction = new CopyAction();
    private BottomLeftScroller fBottomLeftScroller;
    private static char[] sLongPromptChars = new char[0];
    private static int sTextLeftInset;
    private static final int EDGE_TAG_GAP = 3;
    private static final int TAG_LINE_GAP = 3;
    private static final int LINE_TEXT_GAP = 3;
    private static final int PROMPT_COMMAND_GAP = 7;
    private static final int TOTAL_GAP = 9;
    private static final int HIGHLIGHT_DURATION = 5000;

    static void setLongestPrompt(String string) {
        sLongPromptChars = string.toCharArray();
    }

    OutputTextPane(OutputWindow outputWindow, Actions actions) {
        this.fOutputWindow = outputWindow;
        this.setEditorKit(OutputEditorKit.getInstance());
        new DropTarget((Component)((Object)this), new DropListener());
        this.setCaretColor(this.getDisabledTextColor());
        Caret caret = this.getCaret();
        caret.setBlinkRate(0);
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(1);
        }
        this.setCursor(null);
        this.setWrapping(false);
        MouseInputAdapter mouseInputAdapter = new HyperLinkListener();
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
        mouseInputAdapter = new CommandTipListener();
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                OutputTextPane.this.fCopyAction.setEnabled(caretEvent.getDot() != caretEvent.getMark());
            }
        });
        this.fHighlightTimer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputTextPane.this.removeCommandHighlight();
            }
        });
        this.fHighlightTimer.setRepeats(false);
        actions.registerContribution(Actions.Type.COPY, this);
        actions.registerContribution(Actions.Type.SELECT_ALL, this);
        ActionMap actionMap = this.getActionMap();
        final Action action = actionMap.get("caret-previous-word");
        MJAbstractAction mJAbstractAction = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (OutputTextPane.this.getDocument().getLength() > 0) {
                    action.actionPerformed(actionEvent);
                }
            }
        };
        actionMap.put("caret-previous-word", (Action)mJAbstractAction);
        actionMap.put("copy-to-clipboard", (Action)this.fCopyAction);
    }

    public void setDocument(Document document) {
        Document document2 = this.getDocument();
        if (document2 != null && this.fDocumentListener != null) {
            document2.removeDocumentListener(this.fDocumentListener);
        }
        if (this.fDocumentListener == null) {
            this.fDocumentListener = new LocalDocumentListener();
        }
        super.setDocument(document);
        if (document instanceof OutputCollection.OutputDocument) {
            document.addDocumentListener(this.fDocumentListener);
        }
        this.scrollToBottomLeft();
    }

    @Override
    public Action getAction(Actions.Type type) {
        switch (type) {
            case COPY: {
                return this.fCopyAction;
            }
            case SELECT_ALL: {
                return new SelectAllAction();
            }
            case CLEAR_OUTPUT: {
                return new ClearAction();
            }
        }
        return null;
    }

    @Override
    public Component getActionFocusComponent() {
        return this;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        StyledDocument styledDocument = this.getStyledDocument();
        if (styledDocument != null) {
            Style style = styledDocument.getStyle("default");
            StyleConstants.setForeground(style, color);
        }
    }

    void setAltBackground(Color color) {
        this.fAltBackground = color;
        this.fAltReference = null;
    }

    Color getAltBackground() {
        if (this.fAltBackground != null && (this.fAltReference == null || this.fAltReference.equals(this.getBackground()))) {
            return this.fAltBackground;
        }
        this.fAltReference = this.getBackground();
        float[] fArray = Color.RGBtoHSB(this.fAltReference.getRed(), this.fAltReference.getGreen(), this.fAltReference.getBlue(), null);
        fArray[2] = fArray[2] < 0.5f ? fArray[2] + 0.1f : fArray[2] - 0.1f;
        this.fAltBackground = Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
        return this.fAltBackground;
    }

    void setCommandBackground(Color color) {
        this.fCommandBackground = color;
        this.fCommandReference = null;
    }

    Color getCommandBackground() {
        if (this.fCommandBackground != null && (this.fCommandReference == null || this.fCommandReference.equals(this.getSelectionColor()))) {
            return this.fCommandBackground;
        }
        this.fCommandReference = this.getSelectionColor();
        float[] fArray = Color.RGBtoHSB(this.fCommandReference.getRed(), this.fCommandReference.getGreen(), this.fCommandReference.getBlue(), null);
        if (ColorUtils.isDark((Color)this.getBackground())) {
            fArray[2] = 0.15f;
        } else {
            if (fArray[1] > 0.2f) {
                fArray[1] = 0.2f;
            }
            fArray[2] = 0.85f;
        }
        this.fCommandBackground = Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
        return this.fCommandBackground;
    }

    @Override
    public void setShowCommandText(boolean bl) {
        if (this.fShowCommandText != bl) {
            this.fShowCommandText = bl;
            boolean bl2 = this.isAtBottom();
            Point point = this.getVisibleRect().getLocation();
            int n = this.viewToModel(point);
            Document document = this.getDocument();
            if (document instanceof OutputCollection.OutputDocument) {
                ((OutputCollection.OutputDocument)document).refresh();
            }
            if (bl2) {
                this.scrollToBottomImmediately();
            } else if (this.getParent() instanceof JViewport) {
                try {
                    JViewport jViewport = (JViewport)this.getParent();
                    Rectangle rectangle = this.modelToView(n);
                    if (rectangle != null) {
                        Point point2 = rectangle.getLocation();
                        point2.x = point.x;
                        jViewport.setViewPosition(point2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean isShowingCommandText() {
        return this.fShowCommandText;
    }

    @Override
    public void showCorrespondingOutput(OutputCollection.CommandRecord commandRecord) {
        OutputCollection.OutputDocument outputDocument;
        Element element;
        this.removeCommandHighlight();
        Document document = this.getDocument();
        if (document instanceof OutputCollection.OutputDocument && (element = (outputDocument = (OutputCollection.OutputDocument)document).getElement(commandRecord)) != null) {
            try {
                Serializable serializable;
                int n = element.getStartOffset();
                Point point = this.modelToView(n).getLocation();
                if (this.getParent() instanceof JViewport) {
                    serializable = (JViewport)this.getParent();
                    Rectangle rectangle = ((JViewport)serializable).getViewRect();
                    Point point2 = new Point();
                    if (point.y < rectangle.y) {
                        point2.y = point.y;
                        ((JViewport)serializable).setViewPosition(point2);
                    } else if (point.y > rectangle.y + rectangle.height / 2) {
                        point2.y = point.y - rectangle.height / 2;
                        if (point2.y < 0) {
                            point2.y = 0;
                        }
                        ((JViewport)serializable).setViewPosition(point2);
                    }
                }
                if (this.fShowCommandText) {
                    this.fCommandHighlight = this.getHighlighter().addHighlight(element.getStartOffset(), element.getEndOffset(), new DefaultHighlighter.DefaultHighlightPainter(null));
                } else {
                    this.fHighlightStart = element.getStartOffset();
                    serializable = this.modelToView(this.fHighlightStart);
                    ((Rectangle)serializable).x = 0;
                    ((Rectangle)serializable).width = this.getWidth();
                    this.repaint((Rectangle)serializable);
                }
                this.fHighlightTimer.restart();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void clear() {
        Document document = this.getDocument();
        if (document instanceof OutputCollection.OutputDocument) {
            ((OutputCollection.OutputDocument)document).clear();
        }
    }

    @Override
    public void setKeyRedirector(KeyListener keyListener) {
        this.addKeyListener(keyListener);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    void scrollToBottomLeft() {
        if (this.fBottomLeftScroller == null) {
            this.fBottomLeftScroller = new BottomLeftScroller();
        }
        this.fBottomLeftScroller.post();
    }

    private void scrollToBottomImmediately() {
        JScrollPane jScrollPane;
        JScrollBar jScrollBar;
        if (this.getParent() instanceof JViewport && (jScrollBar = (jScrollPane = (JScrollPane)this.getParent().getParent()).getVerticalScrollBar()) != null) {
            int n = jScrollBar.getMaximum() - jScrollBar.getModel().getExtent();
            jScrollBar.setValue(n);
        }
    }

    private void scrollToLeftImmediately() {
        JScrollPane jScrollPane;
        JScrollBar jScrollBar;
        if (this.getParent() instanceof JViewport && (jScrollBar = (jScrollPane = (JScrollPane)this.getParent().getParent()).getHorizontalScrollBar()) != null) {
            jScrollBar.setValue(jScrollBar.getMinimum());
        }
    }

    private boolean isAtBottom() {
        JScrollPane jScrollPane;
        JScrollBar jScrollBar;
        boolean bl = false;
        if (this.getParent() instanceof JViewport && (jScrollBar = (jScrollPane = (JScrollPane)this.getParent().getParent()).getVerticalScrollBar()) != null) {
            int n;
            int n2 = jScrollBar.getValue();
            bl = n2 == (n = jScrollBar.getMaximum() - jScrollBar.getModel().getExtent());
        }
        return bl;
    }

    int getLeftInset() {
        Graphics graphics = this.getGraphics();
        int n = OutputView.getLeftInset(graphics);
        graphics.dispose();
        return n;
    }

    private void removeCommandHighlight() {
        if (this.fCommandHighlight != null) {
            this.getHighlighter().removeHighlight(this.fCommandHighlight);
            this.fCommandHighlight = null;
        }
        if (this.fHighlightStart != -1) {
            try {
                Rectangle rectangle = this.modelToView(this.fHighlightStart);
                rectangle.x = 0;
                rectangle.width = this.getWidth();
                this.fHighlightStart = -1;
                this.repaint(rectangle);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (this.fHighlightTimer.isRunning()) {
            this.fHighlightTimer.stop();
        }
    }

    private static class DropListener
    implements DropTargetListener {
        private DropListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.rejectDrag();
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            dropTargetDropEvent.rejectDrop();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }

    private class CommandViewer
    extends MJPanel {
        MJLabel iPromptLabel;
        StyledLabel iCommandLabel;

        CommandViewer() {
            this.setLayout(null);
            this.iPromptLabel = new MJLabel();
            this.iCommandLabel = new StyledLabel();
            this.iPromptLabel.setOpaque(false);
            this.iCommandLabel.setOpaque(false);
            this.add((Component)this.iPromptLabel);
            this.add((Component)this.iCommandLabel);
        }

        void set(OutputCollection.OutputDocument outputDocument, Element element) {
            this.iPromptLabel.setText(outputDocument.getPromptString(element));
            this.iCommandLabel.setText(outputDocument.getCommandString(element));
            this.iCommandLabel.setStyleRanges(outputDocument.getStyleRanges(element));
            Font font = OutputTextPane.this.getFont();
            this.iPromptLabel.setFont(font);
            this.iCommandLabel.setFont(font);
            Color color = OutputTextPane.this.getForeground();
            this.iPromptLabel.setForeground(color);
            this.iCommandLabel.setForeground(color);
            this.setBackground(OutputTextPane.this.getCommandBackground());
            this.setBorder(BorderFactory.createLineBorder(color));
        }

        public void doLayout() {
            Insets insets = this.getInsets();
            Dimension dimension = this.iPromptLabel.getPreferredSize();
            this.iPromptLabel.setBounds(sTextLeftInset - 7 - dimension.width + 3, insets.top, dimension.width, dimension.height);
            Dimension dimension2 = this.iCommandLabel.getPreferredSize();
            this.iCommandLabel.setBounds(sTextLeftInset + 3, insets.top, dimension2.width, dimension2.height);
        }

        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            Dimension dimension = this.iCommandLabel.getPreferredSize();
            dimension.width += sTextLeftInset + insets.left + insets.right + 3;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }
    }

    private class CommandTipListener
    extends MouseInputAdapter {
        MPopup iTipPopup;
        String iCommand;
        CommandViewer iCommandViewer;

        private CommandTipListener() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            OutputCollection.OutputDocument outputDocument;
            OutputCollection.OutputDocument outputDocument2 = outputDocument = OutputTextPane.this.getDocument() instanceof OutputCollection.OutputDocument ? (OutputCollection.OutputDocument)OutputTextPane.this.getDocument() : null;
            if (!OutputTextPane.this.fShowCommandText && outputDocument != null) {
                String string = null;
                Element element = null;
                int n = OutputTextPane.this.viewToModel(mouseEvent.getPoint());
                if (n != 0) {
                    element = outputDocument.getParagraphElement(n);
                    string = outputDocument.getCommandString(element);
                }
                if (this.iCommand == null && string != null || this.iCommand != null && !this.iCommand.equals(string)) {
                    this.hideTip();
                    if (string != null) {
                        if (this.iCommandViewer == null) {
                            this.iCommandViewer = new CommandViewer();
                        }
                        this.iCommandViewer.set(outputDocument, element);
                        this.iCommand = string;
                        Point point = new Point(0, mouseEvent.getY() - this.iCommandViewer.getPreferredSize().height);
                        SwingUtilities.convertPointToScreen(point, (Component)((Object)OutputTextPane.this));
                        this.iTipPopup = MPopup.getPopup((Component)((Object)OutputTextPane.this), (Component)((Object)this.iCommandViewer), (int)point.x, (int)point.y);
                        this.iTipPopup.show();
                    }
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.hideTip();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.hideTip();
        }

        private void hideTip() {
            if (this.iTipPopup != null) {
                this.iTipPopup.hide();
                this.iTipPopup = null;
                this.iCommand = null;
            }
        }
    }

    private class HyperLinkListener
    extends MouseInputAdapter {
        OutputHyperLink iOverLink;

        private HyperLinkListener() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            OutputCollection.OutputDocument outputDocument;
            OutputCollection.OutputDocument outputDocument2 = outputDocument = OutputTextPane.this.getDocument() instanceof OutputCollection.OutputDocument ? (OutputCollection.OutputDocument)OutputTextPane.this.getDocument() : null;
            if (outputDocument != null) {
                int n = OutputTextPane.this.viewToModel(mouseEvent.getPoint());
                if (n == 0) {
                    this.setOverLink(null);
                } else {
                    Element element = outputDocument.getCharacterElement(n);
                    AttributeSet attributeSet = element.getAttributes();
                    OutputHyperLink outputHyperLink = (OutputHyperLink)attributeSet.getAttribute(HyperLinkScanner.HYPER_LINK_ATTRIBUTE);
                    if (outputHyperLink != this.iOverLink) {
                        this.setOverLink(outputHyperLink);
                    }
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.setOverLink(null);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.iOverLink != null) {
                this.iOverLink.follow();
            }
        }

        private void setOverLink(OutputHyperLink outputHyperLink) {
            if (outputHyperLink != this.iOverLink) {
                if (outputHyperLink == null) {
                    OutputTextPane.this.setCursor(null);
                } else if (this.iOverLink == null) {
                    OutputTextPane.this.setCursor(Cursor.getPredefinedCursor(12));
                }
                this.iOverLink = outputHyperLink;
            }
        }
    }

    private class LocalDocumentListener
    implements DocumentListener {
        private LocalDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            OutputTextPane.this.fOutputWindow.revalidate();
            OutputTextPane.this.scrollToBottomLeft();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            OutputTextPane.this.fOutputWindow.revalidate();
            OutputTextPane.this.scrollToBottomLeft();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            OutputTextPane.this.fOutputWindow.revalidate();
        }
    }

    private static class OutputView
    extends ParagraphView {
        private Boolean iUseAltBackground;
        private Integer iSource;
        private String iPrompt;
        private static final int HIDDEN_COMMAND_HEIGHT = 3;

        public OutputView(Element element) {
            super(element);
        }

        @Override
        protected void setPropertiesFromAttributes() {
            super.setPropertiesFromAttributes();
            AttributeSet attributeSet = this.getAttributes();
            this.iUseAltBackground = attributeSet == null ? null : (Boolean)attributeSet.getAttribute("Toggle Attribute");
            this.iSource = attributeSet == null ? null : (Integer)attributeSet.getAttribute("Source Attribute");
            this.iPrompt = attributeSet == null ? null : (String)attributeSet.getAttribute("Prompt Attribute");
        }

        @Override
        protected short getLeftInset() {
            short s = 0;
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                s = (short)OutputView.getLeftInset(graphics);
                graphics.dispose();
            }
            return s;
        }

        static int getLeftInset(Graphics graphics) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.charsWidth(sLongPromptChars, 0, sLongPromptChars.length);
            int n2 = n + 9 + 1;
            sTextLeftInset = n2;
            return (short)n2;
        }

        private boolean showCommandText() {
            Container container = this.getContainer();
            return !(container instanceof OutputTextPane) || ((OutputTextPane)((Object)container)).fShowCommandText;
        }

        @Override
        public float getMinimumSpan(int n) {
            if (!this.showCommandText() && n == 1 && this.iSource != null && this.iSource == 0) {
                return 3.0f;
            }
            return super.getMinimumSpan(n);
        }

        @Override
        public float getPreferredSpan(int n) {
            if (!this.showCommandText() && n == 1 && this.iSource != null && this.iSource == 0) {
                return 3.0f;
            }
            return super.getPreferredSpan(n);
        }

        @Override
        public float getMaximumSpan(int n) {
            if (!this.showCommandText() && n == 1 && this.iSource != null && this.iSource == 0) {
                return 3.0f;
            }
            return super.getMaximumSpan(n);
        }

        @Override
        public void paint(Graphics graphics, Shape shape) {
            Serializable serializable;
            Object object;
            if (this.iSource != null && this.iSource == Integer.MAX_VALUE) {
                return;
            }
            Rectangle rectangle = new Rectangle(shape.getBounds());
            short s = this.getLeftInset();
            if (this.getContainer() instanceof OutputTextPane) {
                OutputTextPane outputTextPane = (OutputTextPane)((Object)this.getContainer());
                if (this.iSource != null && this.iSource == 0) {
                    object = this.getStartOffset() == outputTextPane.fHighlightStart ? outputTextPane.getSelectionColor() : outputTextPane.getCommandBackground();
                    serializable = outputTextPane.getBackground();
                } else if (this.iUseAltBackground != null && this.iUseAltBackground.booleanValue()) {
                    object = outputTextPane.getAltBackground();
                    serializable = outputTextPane.getBackground();
                } else {
                    object = outputTextPane.getBackground();
                    serializable = outputTextPane.getAltBackground();
                }
                graphics.setColor((Color)object);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.setColor((Color)serializable);
                int n = rectangle.x + s - 3 - 1;
                graphics.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height);
            }
            graphics.setColor(this.getContainer().getForeground());
            int n = 1;
            object = this.getDocument();
            if (object instanceof OutputCollection.OutputDocument) {
                n = ((OutputCollection.OutputDocument)object).getSources().size();
            }
            if (this.iSource != null && (this.iSource > 0 && n > 1 || this.iSource == 0 && this.showCommandText())) {
                serializable = graphics.getFontMetrics();
                String string = this.iSource == 0 ? this.iPrompt : this.iSource.toString();
                int n2 = ((FontMetrics)serializable).charsWidth(string.toCharArray(), 0, string.length());
                graphics.drawString(string, rectangle.x + s - 3 - 3 - n2 - 1, rectangle.y + ((FontMetrics)serializable).getAscent());
            }
            if (this.showCommandText() || this.iSource == null || this.iSource != 0) {
                super.paint(graphics, shape);
            }
        }
    }

    private static class OutputViewFactory
    implements ViewFactory {
        private final ViewFactory fDefaultFactory = new StyledEditorKit().getViewFactory();

        private OutputViewFactory() {
        }

        @Override
        public View create(Element element) {
            if ("paragraph".equals(element.getName())) {
                return new OutputView(element);
            }
            return this.fDefaultFactory.create(element);
        }
    }

    private static class OutputEditorKit
    extends StyledEditorKit {
        private final ViewFactory fOutputViewFactory = new OutputViewFactory();
        private static OutputEditorKit sInstance;

        private OutputEditorKit() {
        }

        static OutputEditorKit getInstance() {
            if (sInstance == null) {
                sInstance = new OutputEditorKit();
            }
            return sInstance;
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.fOutputViewFactory;
        }
    }

    private class ClearAction
    extends MJAbstractAction {
        ClearAction() {
            super(ParallelUI.sRes.getString("action.Clear"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OutputTextPane.this.clear();
        }
    }

    private class SelectAllAction
    extends MJAbstractAction {
        SelectAllAction() {
            super(MJUtilities.intlString((String)"action.SelectAll"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OutputTextPane.this.requestFocusInWindow();
            OutputTextPane.this.selectAll();
        }
    }

    private class CopyAction
    extends AbstractCopyAction {
        CopyAction() {
            this.setEnabled(OutputTextPane.this.getSelectionStart() != OutputTextPane.this.getSelectionEnd());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (OutputTextPane.this.getSelectionStart() != OutputTextPane.this.getSelectionEnd()) {
                try {
                    StringBuilder stringBuilder = new StringBuilder();
                    StyledDocument styledDocument = (StyledDocument)OutputTextPane.this.getDocument();
                    int n = OutputTextPane.this.getSelectionEnd();
                    int n2 = OutputTextPane.this.getSelectionStart();
                    while (n2 < n) {
                        Element element = styledDocument.getParagraphElement(n2);
                        Integer n3 = (Integer)element.getAttributes().getAttribute("Source Attribute");
                        if (OutputTextPane.this.fShowCommandText || n3 == null || n3 != 0) {
                            int n4 = element.getEndOffset();
                            if (n4 > n) {
                                n4 = n;
                            }
                            stringBuilder.append(styledDocument.getText(n2, n4 - n2));
                            if (element.getEndOffset() + 1 < n) {
                                stringBuilder.append('\n');
                            }
                        }
                        n2 = element.getEndOffset();
                    }
                    if (stringBuilder.length() > 0) {
                        String string = stringBuilder.toString();
                        MJClipboard.getMJClipboard().setContents(string, null);
                        if (PlatformInfo.isXWindows()) {
                            MJClipboard.getMJClipboard().setXSelectionContents(string);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    private class BottomLeftScroller
    implements Runnable {
        boolean iIsPending;
        int iDeferCount;

        private BottomLeftScroller() {
        }

        void post() {
            OutputTextPane.this.scrollToLeftImmediately();
            OutputTextPane.this.scrollToBottomImmediately();
            if (!this.iIsPending) {
                this.iIsPending = true;
                this.iDeferCount = 1;
                EventQueue.invokeLater(this);
            }
        }

        @Override
        public void run() {
            --this.iDeferCount;
            if (this.iDeferCount > 0) {
                EventQueue.invokeLater(this);
            } else {
                OutputTextPane.this.scrollToLeftImmediately();
                OutputTextPane.this.scrollToBottomImmediately();
                this.iIsPending = false;
            }
        }
    }
}

