/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.DispatchInvoker;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleDispatcher;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.SessionRoleMapping;
import com.mathworks.toolbox.distcomp.pmode.shared.Dispatcher;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.MCommand;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class DispatcherImpl
implements Dispatcher<Message> {
    private final List<DispatchInvoker<? extends Message>> fDispatchers = new LinkedList<DispatchInvoker<? extends Message>>();
    private final ConcurrentHashMap<Class<?>, DispatchInvoker<? extends Message>> fDispatcherCacheMap = new ConcurrentHashMap(20);
    private final ReentrantReadWriteLock fDispatchLock = new ReentrantReadWriteLock();
    private final SessionRoleMapping fRoleMapping;

    public static DispatcherImpl create() {
        return new DispatcherImpl(null);
    }

    public static DispatcherImpl create(SessionRoleMapping sessionRoleMapping) {
        return new DispatcherImpl(sessionRoleMapping);
    }

    protected DispatcherImpl(SessionRoleMapping sessionRoleMapping) {
        this.fRoleMapping = sessionRoleMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(Message message, Instance instance) {
        ReentrantReadWriteLock.ReadLock readLock = this.fDispatchLock.readLock();
        readLock.lock();
        try {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Dispatching object of type:\n   " + message.getClass().getName());
            if (message instanceof MCommand) {
                MCommand mCommand = (MCommand)message;
                mCommand.setSourceProcess(instance);
            }
            boolean bl = this.dispatchToList(message, instance);
            assert (bl) : "Received an unknown object type to dispatch: " + message.getClass().getName();
        }
        finally {
            readLock.unlock();
        }
    }

    public <T extends Message> void addDispatcher(RoleDispatcher<T> roleDispatcher) {
        if (this.fRoleMapping == null) {
            throw new IllegalStateException("Cannot add RoleDispatcher to this DispatcherImpl.");
        }
        this.addDispatcherImpl(new BridgingDispatcher<T>(roleDispatcher), RoleDispatcher.class, roleDispatcher);
    }

    public <T extends Message> void addDispatcher(Dispatcher<T> dispatcher) {
        this.addDispatcherImpl(dispatcher, Dispatcher.class, dispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Message> void addDispatcherImpl(Dispatcher<T> dispatcher, Class<?> clazz, Object object) {
        DispatchInvoker<T> dispatchInvoker = DispatchInvoker.create(dispatcher, clazz, object);
        ReentrantReadWriteLock.WriteLock writeLock = this.fDispatchLock.writeLock();
        writeLock.lock();
        try {
            Class<?> clazz2 = dispatchInvoker.getMessageClass();
            this.fDispatchers.add(dispatchInvoker);
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Added  " + dispatcher.getClass().getName() + " to list of DispatchInvokers");
            this.fDispatcherCacheMap.put(clazz2, dispatchInvoker);
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Added  " + clazz2.getName() + " to list of msg cache to be invoked by " + dispatcher.getClass().getName());
        }
        finally {
            writeLock.unlock();
        }
    }

    private boolean dispatchToList(Message message, Instance instance) {
        Class<?> clazz = message.getClass();
        DispatchInvoker<? extends Message> dispatchInvoker = this.fDispatcherCacheMap.get(clazz);
        if (dispatchInvoker != null) {
            dispatchInvoker.invoke(message, instance);
            return true;
        }
        for (DispatchInvoker dispatchInvoker2 : this.fDispatchers) {
            if (!dispatchInvoker2.isInvokableObject(clazz)) continue;
            this.fDispatcherCacheMap.put(clazz, dispatchInvoker2);
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Added  " + clazz.getName() + " to list of msg cache to be invoked by " + dispatchInvoker2.getDispatcher().getClass().getName());
            dispatchInvoker2.invoke(message, instance);
            return true;
        }
        return false;
    }

    private class BridgingDispatcher<T extends Message>
    implements Dispatcher<T> {
        private final RoleDispatcher<T> fRoleDispatcher;

        BridgingDispatcher(RoleDispatcher<T> roleDispatcher) {
            this.fRoleDispatcher = roleDispatcher;
        }

        @Override
        public void dispatch(T t, Instance instance) {
            this.fRoleDispatcher.dispatch(t, DispatcherImpl.this.fRoleMapping.instanceToRole(instance));
        }
    }
}

