/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.DependencyCommandResult;
import com.mathworks.toolbox.distcomp.pmode.FileDependenciesAssistant;
import com.mathworks.toolbox.distcomp.pmode.FileTransferObserver;
import com.mathworks.toolbox.distcomp.pmode.NewDirectoryDependencyCommand;
import com.mathworks.toolbox.distcomp.pmode.NewFileDependencyCommand;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.UpdateFileDependencyCommand;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleMessageObserver;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleOutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import com.mathworks.toolbox.distcomp.util.FileUtils;
import com.mathworks.util.NativeJava;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class FileDependenciesAssistantImpl
implements FileDependenciesAssistant {
    private final RoleOutputGroup fComms;
    private final ConcurrentMap<File, DependencyElementInfo> fFileDependencyMap;
    private File fDependencyDir;
    private boolean fDependencyDirSet;
    private long fLastCheckTime;

    FileDependenciesAssistantImpl(SessionService sessionService) {
        this.fComms = sessionService.getRoleCommGroup();
        this.fFileDependencyMap = new ConcurrentHashMap<File, DependencyElementInfo>();
        this.fDependencyDirSet = false;
        this.setLastCheckTime(System.currentTimeMillis() / 1000L);
    }

    @Override
    public FileTransferObserver fileChanged(String string, String string2, String string3) throws IOException {
        File file = new File(string2);
        File file2 = file.isAbsolute() ? file : new File(string, file.getPath());
        return this.fileChanged(file2, file, new File(string3));
    }

    @Override
    public FileTransferObserver fileChanged(File file, File file2, File file3) throws IOException {
        assert (file != null && file2 != null && file3 != null) : "No null inputs accepted";
        assert (file.isAbsolute()) : "absFile input MUST be absolute";
        List<ProcessInstance> list = this.fComms.getConnectedProcessInstances();
        FileTransferObserver fileTransferObserver = new FileTransferObserver(file, list);
        UpdateFileDependencyCommand updateFileDependencyCommand = new UpdateFileDependencyCommand(fileTransferObserver.getByteBufferHandle(), file2, file3);
        this.fComms.sendTo(list, (ObservableMessage)updateFileDependencyCommand, (RoleMessageObserver)fileTransferObserver);
        return fileTransferObserver;
    }

    @Override
    public FileTransferObserver addNewFileDependency(String string, String string2, String string3) throws IOException {
        return this.addNewFileDependency(string, new File(string2), string3);
    }

    @Override
    public FileTransferObserver addNewFileDependency(String string, File file, String string2) throws IOException {
        assert (!file.isDirectory()) : "Use this command to add new files";
        List<ProcessInstance> list = this.fComms.getConnectedProcessInstances();
        NewTransferObserver newTransferObserver = new NewTransferObserver(file, string, file, list);
        NewFileDependencyCommand newFileDependencyCommand = new NewFileDependencyCommand(newTransferObserver.getByteBufferHandle(), file, string2);
        this.fComms.sendTo(list, (ObservableMessage)newFileDependencyCommand, (RoleMessageObserver)newTransferObserver);
        return newTransferObserver;
    }

    @Override
    public FileTransferObserver addNewDirectoryDependency(String string, String string2, String string3, String string4) throws IOException {
        return this.addNewDirectoryDependency(new File(string), string2, new File(string3), string4);
    }

    @Override
    public FileTransferObserver addNewDirectoryDependency(File file, String string, File file2, String string2) throws IOException {
        assert (!file.isDirectory()) : "This command expects to receive a zip file";
        assert (file2.isDirectory()) : "This command expects to receive a directory as a dependency";
        List<ProcessInstance> list = this.fComms.getConnectedProcessInstances();
        NewTransferObserver newTransferObserver = new NewTransferObserver(file, string, file2, list);
        NewDirectoryDependencyCommand newDirectoryDependencyCommand = new NewDirectoryDependencyCommand(newTransferObserver.getByteBufferHandle(), file2, string2);
        this.fComms.sendTo(list, (ObservableMessage)newDirectoryDependencyCommand, (RoleMessageObserver)newTransferObserver);
        return newTransferObserver;
    }

    @Override
    public long getLastCheckTime() {
        return this.fLastCheckTime;
    }

    @Override
    public void setLastCheckTime(long l) {
        this.fLastCheckTime = l;
    }

    @Override
    public List<FileTransferObserver> sendChangedFiles(Map<File, List<File>> map) throws IOException {
        LinkedList<FileTransferObserver> linkedList = new LinkedList<FileTransferObserver>();
        for (Map.Entry<File, List<File>> entry : map.entrySet()) {
            File file = entry.getKey();
            int n = ((DependencyElementInfo)this.fFileDependencyMap.get(file)).getFile().getPath().length();
            for (File file2 : entry.getValue()) {
                File file3 = new File(file, file2.getPath().substring(n));
                linkedList.add(this.fileChanged(file2, file3, file));
            }
        }
        return linkedList;
    }

    @Override
    public Map<File, List<File>> findChangedFiles() {
        HashMap<File, List<File>> hashMap = new HashMap<File, List<File>>();
        for (Map.Entry entry : this.fFileDependencyMap.entrySet()) {
            File file = ((DependencyElementInfo)entry.getValue()).getFile();
            this.putChangedFilesInMap(file, (File)entry.getKey(), hashMap);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    @Override
    public Map<File, List<File>> findSpecificChangedFiles(String string, File[] fileArray) throws IOException {
        HashMap<File, List<File>> hashMap = new HashMap<File, List<File>>();
        for (File file : fileArray) {
            if (!file.isAbsolute()) {
                file = new File(string, file.getPath());
            }
            File file2 = this.getContainingDependency(file);
            this.putChangedFilesInMap(file, file2, hashMap);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    @Override
    public Map<File, List<File>> findSpecificChangedFiles(String string, File file) throws IOException {
        File[] fileArray = new File[]{file};
        return this.findSpecificChangedFiles(string, fileArray);
    }

    @Override
    public void putChangedFilesInMap(File file, File file2, Map<File, List<File>> map) {
        LinkedList<File> linkedList = new LinkedList<File>();
        this.putChangedFilesInList(file, linkedList);
        if (!linkedList.isEmpty()) {
            map.put(file2, linkedList);
        }
    }

    @Override
    public void putChangedFilesInList(File file, List<File> list) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.putChangedFilesInList(file2, list);
            }
        } else {
            NativeJava.StatEntry statEntry = NativeJava.getStat((String)file.getPath());
            if (statEntry != null && (statEntry.st_ctime >= this.getLastCheckTime() || statEntry.st_mtime >= this.getLastCheckTime())) {
                list.add(file);
            }
        }
    }

    @Override
    public synchronized boolean addClientDependency(String string, String string2) {
        return this.addClientDependency(string, new File(string2));
    }

    @Override
    public synchronized boolean addClientDependency(String string, File file) {
        return this.addClientDependency(string, file, file);
    }

    @Override
    public synchronized boolean addClientDependency(String string, File file, File file2) {
        return this.fFileDependencyMap.putIfAbsent(file, new DependencyElementInfo(string, file2)) == null;
    }

    @Override
    public synchronized boolean addClientDependency(File file, File file2) {
        return this.fFileDependencyMap.putIfAbsent(file, new DependencyElementInfo(file2)) == null;
    }

    @Override
    public synchronized boolean addDependency(String string, String string2) {
        return this.addDependency(new File(string), new File(string2));
    }

    @Override
    public synchronized boolean addDependency(File file, File file2) {
        return this.fFileDependencyMap.putIfAbsent(file, new DependencyElementInfo(file2)) == null;
    }

    @Override
    public synchronized boolean removeFileDependency(File file) {
        return this.fFileDependencyMap.remove(file) != null;
    }

    @Override
    public synchronized void setDependencyDir(String string) {
        this.setDependencyDir(new File(string));
    }

    @Override
    public synchronized void setDependencyDir(File file) {
        assert (!this.fDependencyDirSet) : "The DependencyDir on the assistant can only be set once";
        assert (file.isAbsolute()) : "The DependencyDir must be an absolute directory on the local machine";
        assert (this.fFileDependencyMap.isEmpty()) : "You cannot change the dependency dir after entries have been made in the map";
        this.fDependencyDir = file;
        this.fDependencyDirSet = true;
    }

    @Override
    public synchronized File getDependencyDir() {
        return this.fDependencyDir;
    }

    @Override
    public synchronized boolean dependencyExists(File file) {
        if (this.fFileDependencyMap.containsKey(file)) {
            return true;
        }
        for (Map.Entry entry : this.fFileDependencyMap.entrySet()) {
            File file2 = ((DependencyElementInfo)entry.getValue()).getFile();
            if (!file2.equals(file) && !FileUtils.containsFile(file2, file)) continue;
            return true;
        }
        return false;
    }

    private synchronized File getContainingDependency(File file) throws IOException {
        for (Map.Entry entry : this.fFileDependencyMap.entrySet()) {
            File file2 = (File)entry.getKey();
            File file3 = ((DependencyElementInfo)entry.getValue()).getFile();
            if (!file2.equals(file) && !file3.equals(file) && !FileUtils.containsFile(file3, file)) continue;
            return file2;
        }
        throw new UnknownDependencyException("Unable to find dependency in MAP", file);
    }

    @Override
    public synchronized File getLocalFileFromRemoteFile(File file, File file2) throws IOException {
        File file3;
        assert (this.fDependencyDirSet) : "Unable to deduce a local file if I don't know my own dependency directory";
        assert (file != null) : "Remote file is null";
        assert (file.getPath().startsWith(file2.getPath())) : "Remote file MUST begin with the same string as provided to find it in dependency list";
        DependencyElementInfo dependencyElementInfo = (DependencyElementInfo)this.fFileDependencyMap.get(file2);
        if (dependencyElementInfo == null && (dependencyElementInfo = (DependencyElementInfo)this.fFileDependencyMap.get(new File(FileUtils.convertToLocalSeparators(file2.getPath())))) == null) {
            throw new UnknownDependencyException("Unable to find dependency in MAP", file2);
        }
        if (dependencyElementInfo.isDirectory()) {
            String string = file.getPath().substring(file2.getPath().length());
            file3 = new File(dependencyElementInfo.getFile(), FileUtils.convertToLocalSeparators(string));
        } else {
            file3 = dependencyElementInfo.getFile();
        }
        return file3;
    }

    private static class UnknownDependencyException
    extends IOException {
        UnknownDependencyException(String string, File file) {
            super(string + ": " + file);
        }
    }

    private static class DependencyElementInfo {
        private final boolean fIsDirectory;
        private final File fFile;

        DependencyElementInfo(File file) {
            assert (file.exists()) : "File must exist";
            assert (file.isAbsolute()) : "File must be absolute";
            this.fIsDirectory = file.isDirectory();
            this.fFile = file;
        }

        DependencyElementInfo(String string, File file) {
            this.fIsDirectory = file.isDirectory();
            File file2 = this.fFile = file.isAbsolute() ? file : new File(string, file.getPath());
            assert (this.fFile.isAbsolute()) : "fFile must be absolute";
            assert (this.fFile.exists()) : "fFile must exist";
        }

        public boolean isDirectory() {
            return this.fIsDirectory;
        }

        public File getFile() {
            return this.fFile;
        }
    }

    private class NewTransferObserver
    extends FileTransferObserver {
        private final File fDependency;
        private final File fAbsFile;

        NewTransferObserver(File file, String string, File file2, List<ProcessInstance> list) throws IOException {
            super(file, list);
            this.fDependency = file2;
            this.fAbsFile = this.fDependency.isAbsolute() ? this.fDependency : new File(string, this.fDependency.getPath());
        }

        @Override
        protected void onAllComplete() {
            super.onAllComplete();
            for (DependencyCommandResult dependencyCommandResult : this.getReturnMessages()) {
                if (dependencyCommandResult.commandCompletedSucessfully()) continue;
                return;
            }
            FileDependenciesAssistantImpl.this.addClientDependency(this.fDependency, this.fAbsFile);
        }

        @Override
        public File getFile() {
            return this.fDependency;
        }
    }
}

