/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io;

import com.mathworks.toolbox.distcomp.pmode.io.HeaderPayload;
import com.mathworks.toolbox.distcomp.pmode.io.Log;
import com.mathworks.toolbox.distcomp.pmode.shared.BufferTransferrable;
import com.mathworks.toolbox.distcomp.pmode.shared.PmodeSerializable;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import com.mathworks.toolbox.parallel.pctutil.EnumUtils;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.IntBuffer;
import java.util.Vector;

final class Messages {
    static HeaderPayload createHeaderPayloadForReceive() {
        ByteBufferHandle byteBufferHandle = ByteBufferHandle.allocate(80);
        byteBufferHandle.get().position(0).limit(byteBufferHandle.get().capacity());
        return new DefaultHeaderPayload(byteBufferHandle);
    }

    static void configurePayload(HeaderPayload headerPayload) {
        assert (headerPayload.isHeaderCompletelyTransmitted()) : "Illegal attempt to configure payload";
        ByteBufferHandle byteBufferHandle = headerPayload.getHeaderMessage();
        int[] nArray = Messages.readHeaderInfo(byteBufferHandle);
        MessageType messageType = (MessageType)EnumUtils.ordinalToEnum(MessageType.class, (int)nArray[0]);
        switch (messageType) {
            case PLAIN_SERIAL: {
                Messages.configurePlainSerial(headerPayload, nArray);
                break;
            }
            case BUFFER_ATTACHED: {
                Messages.configureBufTransf(headerPayload, nArray);
            }
        }
    }

    static PmodeSerializable interpretCompletedMessage(HeaderPayload headerPayload) throws IOException, ClassNotFoundException {
        assert (headerPayload.isHeaderCompletelyTransmitted()) : "Illegal attempt to interpret message when header not transmitted: " + headerPayload.getHeaderMessage();
        assert (headerPayload.isPayloadCompletelyTransmitted()) : "Illegal attempt to interpret message when payload not transmitted";
        ByteBufferHandle[] byteBufferHandleArray = headerPayload.getPayloadMessages();
        assert (byteBufferHandleArray.length > 0) : "Currently, cannot handle 0 payloads - no concept of header-only message";
        byteBufferHandleArray[0].get().flip();
        PmodeSerializable pmodeSerializable = SerializationHelpers.deserializeFromByteBuffer(byteBufferHandleArray[0]);
        if (pmodeSerializable instanceof BufferTransferrable) {
            BufferTransferrable bufferTransferrable = (BufferTransferrable)pmodeSerializable;
            ByteBufferHandle[] byteBufferHandleArray2 = new ByteBufferHandle[byteBufferHandleArray.length - 1];
            for (int i = 0; i < byteBufferHandleArray.length - 1; ++i) {
                ByteBufferHandle byteBufferHandle = byteBufferHandleArray[i + 1];
                byteBufferHandle.get().rewind();
                byteBufferHandleArray2[i] = byteBufferHandle;
            }
            bufferTransferrable.setByteBuffers(byteBufferHandleArray2);
        } else assert (byteBufferHandleArray.length == 1) : "Unhandled ByteBufferHandles!";
        return pmodeSerializable;
    }

    static HeaderPayload createHeaderPayloadForSend(PmodeSerializable pmodeSerializable) throws IOException {
        if (pmodeSerializable instanceof BufferTransferrable) {
            return Messages.createHeaderPayloadForSendBT((BufferTransferrable)pmodeSerializable);
        }
        return Messages.createHeaderPayloadForSendDefault(pmodeSerializable);
    }

    private static ByteBufferHandle buildHeader(Integer[] integerArray) {
        ByteBufferHandle byteBufferHandle = ByteBufferHandle.allocate(80);
        byteBufferHandle.get().putLong(System.currentTimeMillis());
        for (Integer n : integerArray) {
            byteBufferHandle.get().putInt(n);
        }
        byteBufferHandle.get().position(0).limit(byteBufferHandle.get().capacity());
        return byteBufferHandle;
    }

    private static HeaderPayload createHeaderPayloadForSendDefault(PmodeSerializable pmodeSerializable) throws IOException {
        ByteBufferHandle byteBufferHandle = SerializationHelpers.serializeToByteBuffer(pmodeSerializable, BufferType.HEAP);
        ByteBufferHandle byteBufferHandle2 = Messages.buildHeader(new Integer[]{MessageType.PLAIN_SERIAL.ordinal(), 1, byteBufferHandle.get().capacity()});
        return new DefaultHeaderPayload(byteBufferHandle2, new ByteBufferHandle[]{byteBufferHandle});
    }

    private static HeaderPayload createHeaderPayloadForSendBT(BufferTransferrable bufferTransferrable) throws IOException {
        ByteBufferHandle byteBufferHandle = SerializationHelpers.serializeToByteBuffer(bufferTransferrable, BufferType.HEAP);
        ByteBufferHandle[] byteBufferHandleArray = bufferTransferrable.getByteBuffers();
        Vector<ByteBufferHandle> vector = new Vector<ByteBufferHandle>();
        Vector<Integer> vector2 = new Vector<Integer>();
        vector2.addElement(MessageType.BUFFER_ATTACHED.ordinal());
        vector2.addElement(1 + byteBufferHandleArray.length);
        vector2.addElement(byteBufferHandle.get().capacity());
        vector.addElement(byteBufferHandle);
        for (ByteBufferHandle byteBufferHandle2 : byteBufferHandleArray) {
            ByteBufferHandle byteBufferHandle3 = byteBufferHandle2.duplicate();
            vector.addElement(byteBufferHandle3);
            vector2.addElement(byteBufferHandle3.get().capacity());
        }
        ByteBufferHandle byteBufferHandle4 = Messages.buildHeader(vector2.toArray(new Integer[vector2.size()]));
        ByteBufferHandle[] byteBufferHandleArray2 = vector.toArray(new ByteBufferHandle[vector.size()]);
        return new DefaultHeaderPayload(byteBufferHandle4, byteBufferHandleArray2);
    }

    private static int[] readHeaderInfo(ByteBufferHandle byteBufferHandle) {
        ByteBufferHandle byteBufferHandle2 = byteBufferHandle.duplicate();
        byteBufferHandle2.get().position(0);
        long l = byteBufferHandle2.get().getLong();
        Log.LOGGER.log(DistcompLevel.SIX, "Received message latency: " + (System.currentTimeMillis() - l));
        IntBuffer intBuffer = byteBufferHandle2.get().asIntBuffer();
        int[] nArray = new int[intBuffer.capacity()];
        intBuffer.get(nArray);
        byteBufferHandle2.free();
        return nArray;
    }

    private static void configurePlainSerial(HeaderPayload headerPayload, int[] nArray) {
        int n = nArray[1];
        int n2 = nArray[2];
        assert (n == 1) : "Expected only 1 buffer for plain old PmodeSerializable";
        ByteBufferHandle byteBufferHandle = n2 > 102400 ? ByteBufferHandle.allocateDirect(n2) : ByteBufferHandle.allocate(n2);
        byteBufferHandle.get().position(0).limit(n2);
        headerPayload.setPayloadMessages(new ByteBufferHandle[]{byteBufferHandle});
        Log.LOGGER.log(DistcompLevel.FIVE, "Configured for PmodeSerializable expecting " + n2);
    }

    private static void configureBufTransf(HeaderPayload headerPayload, int[] nArray) {
        int n = nArray[1];
        int n2 = 2;
        ByteBufferHandle[] byteBufferHandleArray = new ByteBufferHandle[n];
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[n2++];
            byteBufferHandleArray[i] = i == 0 ? ByteBufferHandle.allocate(n3) : ByteBufferHandle.allocateDirect(n3);
            Log.LOGGER.log(DistcompLevel.FIVE, "Configured for BufferTransferable, buffer " + i + " expecting " + n3);
        }
        headerPayload.setPayloadMessages(byteBufferHandleArray);
    }

    private Messages() {
    }

    private static final class DefaultHeaderPayload
    implements HeaderPayload {
        private static final ByteBufferHandle[] EMPTY_PAYLOAD = new ByteBufferHandle[0];
        private ByteBufferHandle fHeaderBuf;
        private ByteBufferHandle[] fPayloadBufs;
        private ByteBufferHandle[] fAllBufs;
        private boolean fGotAllBufs;

        DefaultHeaderPayload(ByteBufferHandle byteBufferHandle, ByteBufferHandle[] byteBufferHandleArray) {
            this.fHeaderBuf = byteBufferHandle;
            this.fPayloadBufs = byteBufferHandleArray;
            this.iBuildAllBufs();
        }

        DefaultHeaderPayload(ByteBufferHandle byteBufferHandle) {
            this(byteBufferHandle, EMPTY_PAYLOAD);
            this.fAllBufs = null;
            this.fGotAllBufs = false;
        }

        @Override
        public ByteBufferHandle getHeaderMessage() {
            return this.fHeaderBuf;
        }

        @Override
        public boolean isHeaderCompletelyTransmitted() {
            return !this.fHeaderBuf.get().hasRemaining();
        }

        @Override
        public ByteBufferHandle[] getAllMessages() {
            assert (this.fGotAllBufs) : "Must have all buffers available to return them";
            return this.fAllBufs;
        }

        @Override
        public ByteBufferHandle[] getPayloadMessages() {
            return this.fPayloadBufs;
        }

        @Override
        public void setPayloadMessages(ByteBufferHandle[] byteBufferHandleArray) {
            this.fPayloadBufs = byteBufferHandleArray;
            this.iBuildAllBufs();
        }

        private void iBuildAllBufs() {
            this.fAllBufs = new ByteBufferHandle[1 + this.fPayloadBufs.length];
            this.fAllBufs[0] = this.fHeaderBuf;
            int n = 1;
            for (ByteBufferHandle byteBufferHandle : this.fPayloadBufs) {
                this.fAllBufs[n++] = byteBufferHandle;
            }
            this.fGotAllBufs = true;
        }

        @Override
        public boolean isPayloadCompletelyTransmitted() {
            for (ByteBufferHandle byteBufferHandle : this.fPayloadBufs) {
                if (!byteBufferHandle.get().hasRemaining()) continue;
                Log.LOGGER.log(DistcompLevel.SIX, "Remaining data for " + byteBufferHandle);
                return false;
            }
            return true;
        }

        private int getKBytes(BufferType bufferType) {
            long l = 0L;
            boolean bl = bufferType == BufferType.DIRECT;
            l += (this.fHeaderBuf.get().isDirect() == bl ? (long)this.fHeaderBuf.get().capacity() : 0L) / 1024L;
            for (ByteBufferHandle byteBufferHandle : this.fPayloadBufs) {
                l += (byteBufferHandle.get().isDirect() == bl ? (long)byteBufferHandle.get().capacity() : 0L) / 1024L;
            }
            assert (l <= Integer.MAX_VALUE);
            return (int)l;
        }

        @Override
        public int heapKBytes() {
            return this.getKBytes(BufferType.HEAP);
        }

        @Override
        public int directKBytes() {
            return this.getKBytes(BufferType.DIRECT);
        }
    }

    private static final class BufAccessibleByteArrayOutputStream
    extends ByteArrayOutputStream {
        private BufAccessibleByteArrayOutputStream() {
        }

        byte[] getBuf() {
            return this.buf;
        }
    }

    private static final class SerializationHelpers {
        private SerializationHelpers() {
        }

        static ByteBufferHandle serializeToByteBuffer(PmodeSerializable pmodeSerializable, BufferType bufferType) throws IOException {
            Object object;
            BufAccessibleByteArrayOutputStream bufAccessibleByteArrayOutputStream = new BufAccessibleByteArrayOutputStream();
            try {
                object = new ObjectOutputStream(bufAccessibleByteArrayOutputStream);
                Throwable throwable = null;
                try {
                    ((ObjectOutputStream)object).writeObject(pmodeSerializable);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((ObjectOutputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((ObjectOutputStream)object).close();
                        }
                    }
                }
            }
            catch (NotSerializableException notSerializableException) {
                Log.LOGGER.log(DistcompLevel.ONE, "Non-serializable message: " + pmodeSerializable + " of class: " + pmodeSerializable.getClass(), notSerializableException);
                throw notSerializableException;
            }
            if (bufferType == BufferType.DIRECT) {
                object = ByteBufferHandle.allocateDirect(bufAccessibleByteArrayOutputStream.size());
                ((ByteBufferHandle)object).get().put(bufAccessibleByteArrayOutputStream.getBuf());
            } else {
                object = ByteBufferHandle.wrap(bufAccessibleByteArrayOutputStream.getBuf());
            }
            ((ByteBufferHandle)object).get().position(0).limit(((ByteBufferHandle)object).get().capacity());
            return object;
        }

        static PmodeSerializable deserializeFromByteBuffer(ByteBufferHandle byteBufferHandle) throws IOException, ClassNotFoundException {
            Object object;
            ByteArrayInputStream byteArrayInputStream;
            if (byteBufferHandle.get().hasArray()) {
                byteArrayInputStream = new ByteArrayInputStream(byteBufferHandle.get().array());
            } else {
                object = new byte[byteBufferHandle.get().capacity()];
                byteBufferHandle.get().get((byte[])object);
                byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            }
            try (ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);){
                object = (PmodeSerializable)objectInputStream.readObject();
            }
            byteBufferHandle.free();
            return object;
        }
    }

    private static enum MessageType {
        PLAIN_SERIAL,
        BUFFER_ATTACHED;

    }

    private static enum BufferType {
        DIRECT,
        HEAP;

    }
}

