/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.peermessaging;

import com.mathworks.toolbox.distcomp.pmode.peermessaging.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.Dispatcher;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.OutputGroup;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public final class KeepAlive {
    private static final long KEEP_ALIVE_PERIOD = 10L;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.MINUTES;
    private final ScheduledExecutorService fExecutor = Executors.newScheduledThreadPool(1, (ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " fExecutor-"), (Logger)PackageInfo.LOGGER));
    private final KeepAliveSender fSender;
    private final KeepAliveDispatcher fDispatcher;

    public KeepAlive(OutputGroup outputGroup, Collection<? extends Instance> collection) {
        this.fDispatcher = new KeepAliveDispatcher(outputGroup.getLocalInstance());
        this.fSender = new KeepAliveSender(outputGroup, collection);
    }

    public Dispatcher<KeepAliveMessage> getDispatcher() {
        return this.fDispatcher;
    }

    public void start() {
        this.fExecutor.scheduleWithFixedDelay(this.fSender, 10L, 10L, KEEP_ALIVE_TIME_UNIT);
        PackageInfo.LOGGER.finer("KeepAlive fSender scheduled to send every 10 " + (Object)((Object)KEEP_ALIVE_TIME_UNIT));
    }

    public void shutdownNow() {
        this.fExecutor.shutdownNow();
        PackageInfo.LOGGER.finer("KeepAlive fExecutor shut down");
    }

    private static final class KeepAliveSender
    implements Runnable {
        private final OutputGroup fOutputGroup;
        private final List<Instance> fInstanceList;

        KeepAliveSender(OutputGroup outputGroup, Collection<? extends Instance> collection) {
            this.fOutputGroup = outputGroup;
            this.fInstanceList = new ArrayList<Instance>(collection);
        }

        @Override
        public void run() {
            KeepAliveMessage keepAliveMessage = new KeepAliveMessage();
            this.fOutputGroup.sendTo(this.fInstanceList, (Message)keepAliveMessage);
            PackageInfo.LOGGER.fine("KeepAliveSender for " + this.fOutputGroup.getLocalInstance() + " sent " + keepAliveMessage + " to " + this.fInstanceList);
        }
    }

    private static final class KeepAliveMessage
    implements Message {
        KeepAliveMessage() {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static final class KeepAliveDispatcher
    implements Dispatcher<KeepAliveMessage> {
        private final Instance fLocalInstance;

        KeepAliveDispatcher(Instance instance) {
            this.fLocalInstance = instance;
        }

        @Override
        public void dispatch(KeepAliveMessage keepAliveMessage, Instance instance) {
            PackageInfo.LOGGER.fine("KeepAliveDispatcher for " + this.fLocalInstance + " received " + keepAliveMessage + " from " + instance);
        }
    }
}

