/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.peermessaging;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.peermessaging;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.AbstractPeerAcceptor;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.HandShake;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public final class PeerActiveAcceptor
extends AbstractPeerAcceptor {
    public PeerActiveAcceptor(String string, Instance instance, ServerSocketAcceptInfo serverSocketAcceptInfo) throws AbstractPeerAcceptor.InitializeServerSocketChannelException {
        super(string, instance, serverSocketAcceptInfo);
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "PeerActiveAcceptor (" + instance + ") constructed.");
    }

    private Connection acceptAndConfigureConnection() throws AbstractPeerAcceptor.CouldNotConfigureSocketChannelException, HandShake.HandShakeException, CouldNotAcceptException {
        SocketChannel socketChannel;
        try {
            socketChannel = this.getServerSocketChannel().accept();
        }
        catch (IOException iOException) {
            throw new CouldNotAcceptException(this.getServerSocketChannel(), iOException);
        }
        if (socketChannel != null) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Did accept() : " + socketChannel);
            try {
                return this.createConnection(socketChannel);
            }
            catch (AbstractPeerAcceptor.CouldNotConfigureSocketChannelException | HandShake.HandShakeException | RuntimeException exception) {
                this.safeClose(socketChannel, exception);
                throw exception;
            }
        }
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "accept() returned null instead of a SocketChannel.");
        return null;
    }

    private void safeClose(SocketChannel socketChannel, Exception exception) {
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Closing socket " + socketChannel + " because we caught an exception during bootstrap.", exception);
            socketChannel.close();
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Exception while closing socketChannel " + socketChannel.socket(), iOException);
        }
    }

    public Connection activelyAcceptOnce() {
        try {
            return this.acceptAndConfigureConnection();
        }
        catch (Exception exception) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Unexpected exception within activelyAcceptOnce()", exception);
            return null;
        }
    }

    public Connection activelyAccept() throws PeerMessagingException {
        int n = this.getAcceptInfo().getNumberOfAttempts() * 10;
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "activelyAccept() starting to poll " + n + " times on accept for " + this.getAcceptInfo().getRemainingTime() + " ms");
        PeerMessagingException peerMessagingException = null;
        for (int i = n; i > 0; --i) {
            try {
                Connection connection = this.acceptAndConfigureConnection();
                if (connection != null) {
                    return connection;
                }
            }
            catch (PeerMessagingException peerMessagingException2) {
                if (peerMessagingException == null) {
                    peerMessagingException = peerMessagingException2;
                }
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "activelyAccept() caught exception", peerMessagingException2);
            }
            try {
                PackageInfo.LOGGER.log(DistcompLevel.SIX, "activelyAccept().getRemainingTime() is " + this.getAcceptInfo().getRemainingTime());
                PackageInfo.LOGGER.log(DistcompLevel.SIX, "activelyAccept() is " + this.getAcceptInfo());
                long l = Math.min(this.getAcceptInfo().getAcceptTimeout(), this.getAcceptInfo().getRemainingTime());
                PackageInfo.LOGGER.log(DistcompLevel.SIX, "activelyAccept() will poll again after " + l + " ms");
                Thread.sleep(l);
                continue;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new ActivelyAcceptInterruptedException(this.getServerSocketChannel(), interruptedException);
            }
        }
        try {
            return this.acceptAndConfigureConnection();
        }
        catch (PeerMessagingException peerMessagingException3) {
            if (peerMessagingException == null) {
                peerMessagingException = peerMessagingException3;
            }
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "activelyAccept() caught exception", peerMessagingException3);
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Failed to activelyAccept.");
            throw peerMessagingException;
        }
    }

    public String toString() {
        return "[PeerActiveAcceptor for: " + this.getLocalPeerInstance() + " with ServerSocketChannel: " + this.getServerSocketChannel() + "]";
    }

    private static final class ActivelyAcceptInterruptedException
    extends PeerMessagingException {
        private final InetSocketAddress fLocalSocketAddress;

        private ActivelyAcceptInterruptedException(ServerSocketChannel serverSocketChannel, InterruptedException interruptedException) {
            super(interruptedException);
            this.fLocalSocketAddress = (InetSocketAddress)serverSocketChannel.socket().getLocalSocketAddress();
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new peermessaging.SocketChannelAcceptWasInterrupted(this.fLocalSocketAddress.toString(), this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new peermessaging.SocketChannelAcceptWasInterrupted(this.fLocalSocketAddress.toString(), this.getCause().getLocalizedMessage());
        }
    }

    private static final class CouldNotAcceptException
    extends PeerMessagingException {
        private final InetSocketAddress fLocalSocketAddress;

        private CouldNotAcceptException(ServerSocketChannel serverSocketChannel, IOException iOException) {
            super(iOException);
            this.fLocalSocketAddress = (InetSocketAddress)serverSocketChannel.socket().getLocalSocketAddress();
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new peermessaging.SocketChannelAcceptFailed(this.fLocalSocketAddress.toString(), this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new peermessaging.SocketChannelAcceptFailed(this.fLocalSocketAddress.toString(), this.getCause().getLocalizedMessage());
        }
    }
}

