/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.poolmessaging;

import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerConnector;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.Log;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.MatlabPoolConnector;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.MatlabPoolPeerInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectorPlainSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;

final class MatlabPoolSocketConnector
extends MatlabPoolConnector {
    private final PeerConnector fPeerConnector;
    private MatlabPoolPeerInstance fLocalPeer;
    private Map<ProcessInstance, ConnectInfo> fProcessInstancesToConnectInfos;

    MatlabPoolSocketConnector(MatlabPoolPeerInstance matlabPoolPeerInstance) throws PeerMessagingException {
        super(matlabPoolPeerInstance);
        this.fLocalPeer = matlabPoolPeerInstance;
        this.fPeerConnector = new PeerConnector();
        this.fProcessInstancesToConnectInfos = new HashMap<ProcessInstance, ConnectInfo>();
        Log.LOGGER.log(DistcompLevel.THREE, "ConnectionManager (" + matlabPoolPeerInstance + ") constructed.");
    }

    @Override
    void registerConnectInfo(ConnectInfo connectInfo, ProcessInstance processInstance) {
        ProcessInstance processInstance2 = ProcessInstance.getClientInstance();
        String string = System.getenv("MDCE_OVERRIDE_CLIENT_HOST");
        if (processInstance.equals(processInstance2) && string != null && !string.isEmpty() && connectInfo instanceof ServerSocketConnectInfo && ((ServerSocketConnectInfo)connectInfo).getSocketAddress() != null) {
            ServerSocketConnectInfo serverSocketConnectInfo = (ServerSocketConnectInfo)connectInfo;
            InetSocketAddress inetSocketAddress = serverSocketConnectInfo.getSocketAddress();
            Log.LOGGER.log(DistcompLevel.THREE, "Using overriding client hostname: " + string + " to override " + inetSocketAddress);
            InetSocketAddress inetSocketAddress2 = new InetSocketAddress(string, inetSocketAddress.getPort());
            ConnectorPlainSecurityDescription connectorPlainSecurityDescription = new ConnectorPlainSecurityDescription();
            ServerSocketConnectInfo serverSocketConnectInfo2 = serverSocketConnectInfo.createCopyReplaceSocket(inetSocketAddress2).createCopyReplaceSecurityDescription(connectorPlainSecurityDescription);
            this.fProcessInstancesToConnectInfos.put(processInstance2, serverSocketConnectInfo2);
        } else {
            this.fProcessInstancesToConnectInfos.put(processInstance, connectInfo);
        }
    }

    @Override
    Connection activelyConnectTo(ProcessInstance processInstance) throws PeerMessagingException {
        if (!this.fProcessInstancesToConnectInfos.containsKey(processInstance)) {
            assert (false) : "No address for: " + processInstance;
            return null;
        }
        ConnectInfo connectInfo = this.fProcessInstancesToConnectInfos.get(processInstance);
        if (connectInfo instanceof ServerSocketConnectInfo) {
            ServerSocketConnectInfo serverSocketConnectInfo = (ServerSocketConnectInfo)connectInfo;
            return this.fPeerConnector.activelyConnectTo(serverSocketConnectInfo, this.fLocalPeer);
        }
        throw new IllegalArgumentException("Does not understand how to connect using a " + connectInfo.getClass());
    }

    @Override
    void close() {
    }

    public String toString() {
        return "MatlabPoolSocketConnector{, fPeerConnector=" + this.fPeerConnector + ", fLocalPeer=" + this.fLocalPeer + ", fProcessInstancesToConnectInfos.size()=" + this.fProcessInstancesToConnectInfos.size() + '}';
    }
}

