/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.taskqueue;

import com.mathworks.toolbox.distcomp.pmode.taskqueue.Task;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.TaskCompletionListener;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.TaskQueue;
import com.mathworks.toolbox.parallel.util.resourcemanagement.Disposable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class TaskCompletionWaiter
implements TaskCompletionListener,
Disposable {
    private final TaskQueue fTaskQueue;
    private final AtomicBoolean fDisposed = new AtomicBoolean(false);
    private final Object fSync = new Object();
    private long fCompletedID = -1L;

    public static TaskCompletionWaiter build(TaskQueue taskQueue) {
        TaskCompletionWaiter taskCompletionWaiter = new TaskCompletionWaiter(taskQueue);
        taskQueue.addTaskCompletionListener(taskCompletionWaiter);
        return taskCompletionWaiter;
    }

    private TaskCompletionWaiter(TaskQueue taskQueue) {
        this.fTaskQueue = taskQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(Task task) {
        Object object = this.fSync;
        synchronized (object) {
            this.fCompletedID = task.getID();
            this.fSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long awaitTaskCompletion(long l, TimeUnit timeUnit) throws InterruptedException {
        assert (!this.fDisposed.get()) : "This WaitForOneHelper has been disposed of.";
        long l2 = timeUnit.toMillis(l);
        Object object = this.fSync;
        synchronized (object) {
            this.fCompletedID = -1L;
            this.fSync.wait(l2);
            return this.fCompletedID;
        }
    }

    public boolean isDisposed() {
        return this.fDisposed.get();
    }

    public void dispose() {
        boolean bl = this.fDisposed.getAndSet(true);
        if (bl) {
            this.fTaskQueue.removeTaskCompletionListener(this);
        }
    }
}

