/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.ShellFuture;
import java.io.InputStream;
import java.io.OutputStream;

final class ProcessShellFuture
implements ShellFuture {
    private final Process fProcess;
    private final boolean fIsRemoteExitValue;
    private final String fCommand;
    private final String fHostname;

    ProcessShellFuture(Process process, boolean bl, String string, String string2) {
        this.fProcess = process;
        this.fIsRemoteExitValue = bl;
        this.fCommand = string;
        this.fHostname = string2;
    }

    @Override
    public void cancel() {
        this.fProcess.destroy();
        Logger.LOGGER.fine(this.fHostname + " " + this.fCommand + " cancelled.");
    }

    @Override
    public boolean isRunning() {
        try {
            this.fProcess.exitValue();
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    @Override
    public void awaitEnd() throws InterruptedException {
        Logger.LOGGER.finest(this.fHostname + " " + this.fCommand + " waiting to complete.");
        this.fProcess.waitFor();
        Logger.LOGGER.fine(this.fHostname + " " + this.fCommand + " finished waiting.");
    }

    @Override
    public boolean isExitStatusOfRemoteCommand() {
        return this.fIsRemoteExitValue;
    }

    @Override
    public int getExitStatus() throws InterruptedException, FulfillmentException {
        this.awaitEnd();
        return this.fProcess.exitValue();
    }

    @Override
    public InputStream getErrorStream() {
        return this.fProcess.getErrorStream();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.fProcess.getOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.fProcess.getInputStream();
    }
}

