/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.service;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.service.AbstractRMIClientSocketFactory;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedException;
import com.mathworks.toolbox.parallel.util.i18n.I18nMessageCreator;
import com.mathworks.toolbox.parallel.util.i18n.XMLMessageCreator;
import java.io.IOException;
import java.net.Socket;
import javax.net.SocketFactory;

abstract class AbstractHostnameRMIClientSocketFactory
extends AbstractRMIClientSocketFactory {
    private final String fHostname = AbstractHostnameRMIClientSocketFactory.getHostname();

    protected AbstractHostnameRMIClientSocketFactory() {
    }

    protected AbstractHostnameRMIClientSocketFactory(int n) {
        super(n);
    }

    private static String getHostname() {
        String string = System.getProperty("distcomp.rmi.server.hostname");
        if (string == null) {
            string = System.getProperty("java.rmi.server.hostname");
        }
        return string;
    }

    @Override
    protected Socket createSocket(SocketFactory socketFactory, String string, int n) throws IOException {
        String string2;
        boolean bl = "true".equals(System.getProperty("com.mathworks.toolbox.distcomp.rmi.useServerSpecifiedHostname"));
        String string3 = string2 = bl ? this.fHostname : string;
        if (string2 == null) {
            throw new NoHostnameSpecifiedException();
        }
        return super.createSocket(socketFactory, string2, n);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractHostnameRMIClientSocketFactory)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AbstractHostnameRMIClientSocketFactory abstractHostnameRMIClientSocketFactory = (AbstractHostnameRMIClientSocketFactory)object;
        return !(this.fHostname != null ? !this.fHostname.equals(abstractHostnameRMIClientSocketFactory.fHostname) : abstractHostnameRMIClientSocketFactory.fHostname != null);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.fHostname != null ? this.fHostname.hashCode() : 0);
        return n;
    }

    private static final class NoHostnameSpecifiedException
    extends IOException
    implements I18nMatlabIdentifiedException {
        private final I18nMessageCreator fErrorMessageCreator = new XMLMessageCreator();
        private final BaseMsgID fMessageID = new mjs.NoHostnameSpecified("com.mathworks.toolbox.distcomp.rmi.useServerSpecifiedHostname");

        private NoHostnameSpecifiedException() {
        }

        @Override
        public String getMessage() {
            return this.fErrorMessageCreator.createMessage(this.fMessageID);
        }

        @Override
        public String getLocalizedMessage() {
            return this.fErrorMessageCreator.createLocalizedMessage(this.fMessageID);
        }

        public String getMessageID() {
            return this.fMessageID.getCatalogId() + ":" + this.fMessageID.getMessageId();
        }
    }
}

