/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage;

import com.mathworks.toolbox.distcomp.auth.credentials.UserCredentials;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.storage.DatabaseStorage;
import com.mathworks.toolbox.distcomp.storage.PackageInfo;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.workunit.JobIDAndMLType;
import com.mathworks.toolbox.distcomp.workunit.JobImpl;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitStateException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.logging.Level;
import net.jini.id.Uuid;

public class LoggingDatabaseStorage
implements DatabaseStorage {
    private final DatabaseStorage fStorage;

    public LoggingDatabaseStorage(DatabaseStorage databaseStorage) {
        this.fStorage = databaseStorage;
    }

    @Override
    public void updateData(Uuid uuid, InputStream inputStream, int n) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "dataid: " + uuid + ", numBytes: " + n + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        this.fStorage.updateData(uuid, inputStream, n);
    }

    @Override
    public void removeData(Uuid uuid) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "dataid: " + uuid + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        this.fStorage.removeData(uuid);
    }

    @Override
    public Uuid copyData(Uuid uuid) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "dataid: " + uuid + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.copyData(uuid);
    }

    @Override
    public void appendToData(Uuid uuid, InputStream inputStream, int n) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "dataid: " + uuid + ", numBytes: " + n + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        this.fStorage.appendToData(uuid, inputStream, n);
    }

    @Override
    public void putTaskData(Uuid uuid, Uuid uuid2, Uuid uuid3, InputStream inputStream, int n) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "jobid: " + uuid + ", taskid: " + uuid2 + ", dataid: " + uuid3 + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        this.fStorage.putTaskData(uuid, uuid2, uuid3, inputStream, n);
    }

    @Override
    public void putJobData(Uuid uuid, Uuid uuid2, InputStream inputStream, int n) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "jobid: " + uuid + ", dataid: " + uuid2 + ", numBytes: " + n + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        this.fStorage.putJobData(uuid, uuid2, inputStream, n);
    }

    @Override
    public void removeDataForJobAndTasks(Uuid uuid) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "jobid: " + uuid + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        this.fStorage.removeDataForJobAndTasks(uuid);
    }

    @Override
    public int readData(Uuid uuid, OutputStream outputStream, int n) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "dataid: " + uuid + ", numBytesToRead: " + n + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.readData(uuid, outputStream, n);
    }

    @Override
    public byte[] readData(Uuid uuid) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "dataid: " + uuid + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.readData(uuid);
    }

    @Override
    public Uuid putJob(JobImpl jobImpl) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "job: " + jobImpl + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.putJob(jobImpl);
    }

    @Override
    public void removeJob(Uuid uuid) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "jobid: " + uuid + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        this.fStorage.removeJob(uuid);
    }

    @Override
    public void addToQueue(Uuid uuid) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "jobid: " + uuid + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        this.fStorage.addToQueue(uuid);
    }

    @Override
    public void removeFromQueue(Uuid uuid) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "jobid: " + uuid + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        this.fStorage.removeFromQueue(uuid);
    }

    @Override
    public void promoteJob(Uuid uuid) throws StorageException, WorkUnitStateException {
        PackageInfo.LOGGER.log(Level.FINEST, "jobid: " + uuid + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        this.fStorage.promoteJob(uuid);
    }

    @Override
    public void demoteJob(Uuid uuid) throws StorageException, WorkUnitStateException {
        PackageInfo.LOGGER.log(Level.FINEST, "jobid: " + uuid + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        this.fStorage.demoteJob(uuid);
    }

    @Override
    public void updateCredentials(UserCredentials userCredentials) {
        PackageInfo.LOGGER.log(Level.FINEST, "UserCredentials: " + userCredentials.toString() + Arrays.toString(Thread.currentThread().getStackTrace()));
        this.fStorage.updateCredentials(userCredentials);
    }

    @Override
    public JobIDAndMLType[] readJobsAndTypes() throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.readJobsAndTypes();
    }

    @Override
    public JobIDAndMLType[][] readJobsAndTypesByState(int[] nArray) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "states: " + Arrays.toString(nArray) + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.readJobsAndTypesByState(nArray);
    }

    @Override
    public Uuid[] readTasksByState(int n) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "state: " + n + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.readTasksByState(n);
    }

    @Override
    public Uuid[] readTasksByJobIDAndState(Uuid uuid, int n, int n2) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "jobid: " + uuid + ", state: " + n + ", numTasksToRead: " + n2 + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.readTasksByJobIDAndState(uuid, n, n2);
    }

    @Override
    public Uuid[] readJobsByState(int n) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "state: " + n + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.readJobsByState(n);
    }

    @Override
    public Uuid[] readJobsByJobStateWithTasksInState(int n, int n2) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "jobState: " + n + ", taskState: " + n2 + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.readJobsByJobStateWithTasksInState(n, n2);
    }

    @Override
    public Uuid readFirstJobByState(int n) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "state: " + n + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.readFirstJobByState(n);
    }

    @Override
    public int countTasksByJobID(Uuid uuid) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "jobid: " + uuid + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.countTasksByJobID(uuid);
    }

    @Override
    public int countTasksByJobIDAndState(Uuid uuid, int n) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "jobid: " + uuid + ", state: " + n + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.countTasksByJobIDAndState(uuid, n);
    }

    @Override
    public int countTasksByJobIDAndBeforeState(Uuid uuid, int n) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "jobid: " + uuid + ", state: " + n + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.countTasksByJobIDAndBeforeState(uuid, n);
    }

    @Override
    public void close() throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, Arrays.toString(Thread.currentThread().getStackTrace()));
        this.fStorage.close();
    }

    @Override
    public int updateWorkUnit(WorkUnitImpl workUnitImpl) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "workUnit: " + workUnitImpl + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.updateWorkUnit(workUnitImpl);
    }

    @Override
    public int getCacheSize() {
        PackageInfo.LOGGER.log(Level.FINEST, Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.getCacheSize();
    }

    @Override
    public WorkUnitImpl readWorkUnit(Uuid uuid) throws WorkUnitNotFoundException, StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "workUnitID: " + uuid + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.readWorkUnit(uuid);
    }

    @Override
    public Uuid putTask(TaskImpl taskImpl) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "task: " + taskImpl + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.putTask(taskImpl);
    }

    @Override
    public Uuid[] readTasksByJobID(Uuid uuid) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "jobid: " + uuid + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.readTasksByJobID(uuid);
    }

    @Override
    public Uuid[][] readTasksByJobIDAndState(Uuid uuid, int[] nArray) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "jobid: " + uuid + ", states: " + Arrays.toString(nArray) + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.readTasksByJobIDAndState(uuid, nArray);
    }

    @Override
    public Uuid[] readTasksByJobIDAndBeforeState(Uuid uuid, int n) throws MJSException {
        PackageInfo.LOGGER.log(Level.FINEST, "jobid: " + uuid + ", state: " + n + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        return this.fStorage.readTasksByJobIDAndBeforeState(uuid, n);
    }

    @Override
    public void removeTask(Uuid uuid) throws StorageException {
        PackageInfo.LOGGER.log(Level.FINEST, "taskid: " + uuid + " " + Arrays.toString(Thread.currentThread().getStackTrace()));
        this.fStorage.removeTask(uuid);
    }
}

