/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.test;

import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class MulticastTester {
    private static String sHostname;
    private static final Charset CHARACTER_ENCODING;
    private static final String LISTENING_SERVICE_NAME = "Listening";
    private static final String SENDING_SERVICE_NAME = "Sending";
    private MulticastSocket fSocket;
    private InetAddress fGroup;
    private int fPort;
    private boolean fKeepFromSelf = true;
    private Thread fListeningThread;
    private ScheduledExecutorService fSendingService;
    private ScheduledExecutorService fListeningService;
    private int fSendCounter;
    private int fListenCounter;

    public MulticastTester(String string, int n) {
        try {
            this.fSendingService = MulticastTester.createService(SENDING_SERVICE_NAME);
            this.fListeningService = MulticastTester.createService(LISTENING_SERVICE_NAME);
            this.fGroup = InetAddress.getByName(string);
            this.fPort = n;
            this.fSocket = new MulticastSocket(this.fPort);
            this.fSocket.joinGroup(this.fGroup);
            this.fSocket.setTimeToLive(15);
            this.fSocket.setSoTimeout(1000);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getHostName() {
        return sHostname;
    }

    public MulticastSocket getSocket() {
        return this.fSocket;
    }

    public InetAddress getGroup() {
        return this.fGroup;
    }

    public int getPort() {
        return this.fPort;
    }

    public void startListeningThread() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    String string = MulticastTester.this.receiveString();
                    if (MulticastTester.this.fKeepFromSelf || !MulticastTester.this.isMessageFromThisHost(string)) {
                        System.out.println(MulticastTester.this.fListenCounter++ + " : " + string);
                        MulticastTester.this.fKeepFromSelf = false;
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        };
        this.fListenCounter = 0;
        if (this.fListeningService.isShutdown()) {
            this.fListeningService = MulticastTester.createService(LISTENING_SERVICE_NAME);
        }
        this.fListeningService.scheduleAtFixedRate(runnable, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    public void stopListeningThread() {
        MulticastTester.stopServiceThread(this.fListeningService, LISTENING_SERVICE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopServiceThread(ScheduledExecutorService scheduledExecutorService, String string) {
        if (!scheduledExecutorService.isShutdown()) {
            System.out.println(string + " thread exiting");
            scheduledExecutorService.shutdown();
            try {
                scheduledExecutorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                if (!scheduledExecutorService.isShutdown()) {
                    scheduledExecutorService.shutdownNow();
                }
            }
        }
    }

    public void startSendingThread() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    MulticastTester.this.sendString(sHostname + " : " + MulticastTester.this.fSendCounter++);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        };
        this.fSendCounter = 0;
        if (this.fSendingService.isShutdown()) {
            this.fSendingService = MulticastTester.createService(SENDING_SERVICE_NAME);
        }
        this.fSendingService.scheduleAtFixedRate(runnable, 0L, 5000L, TimeUnit.MILLISECONDS);
    }

    private static ScheduledExecutorService createService(String string) {
        return Executors.newScheduledThreadPool(1, (ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(MulticastTester.class.getSimpleName() + " " + string + "Service-"), (Logger)Logger.getLogger(MulticastTester.class.getName())));
    }

    public void stopSendingThread() {
        MulticastTester.stopServiceThread(this.fSendingService, SENDING_SERVICE_NAME);
    }

    public void sendString(String string) throws IOException {
        byte[] byArray = string.getBytes(CHARACTER_ENCODING);
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.fGroup, this.fPort);
        this.fSocket.send(datagramPacket);
    }

    public String receiveString() throws IOException {
        byte[] byArray = new byte[1000];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        this.fSocket.receive(datagramPacket);
        int n = 0;
        return new String(byArray, n, datagramPacket.getLength(), CHARACTER_ENCODING);
    }

    public boolean isMessageFromThisHost(String string) {
        int n = string.lastIndexOf(" : ");
        if (n <= 0) {
            return false;
        }
        String string2 = string.substring(0, n);
        return sHostname.equals(string2);
    }

    public static void main(String[] stringArray) {
        String string = "239.1.1.1";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        int n = 9999;
        if (stringArray.length > 1) {
            n = Integer.parseInt(stringArray[1]);
        }
        MulticastTester multicastTester = new MulticastTester(string, n);
        multicastTester.startListeningThread();
        multicastTester.startSendingThread();
    }

    static {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            sHostname = inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            sHostname = "Unknown host";
        }
        CHARACTER_ENCODING = Charset.forName("UTF-16");
    }
}

