/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.discover;

import com.jidesoft.grid.SortableTable;
import com.jidesoft.wizard.DefaultWizardPage;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.jmi.Callback;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.toolbox.distcomp.ui.discover.ClusterTableModel;
import com.mathworks.toolbox.distcomp.ui.discover.DiscoverClusterData;
import com.mathworks.toolbox.distcomp.ui.discover.PageActionProvider;
import com.mathworks.toolbox.distcomp.ui.discover.model.DiscoverClusterWizardModel;
import com.mathworks.toolbox.distcomp.ui.panel.AbstractStyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.resources.icons.ParallelIcon;
import com.mathworks.toolbox.distcomp.ui.widget.TablePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

final class ClusterTablePage
extends DefaultWizardPage
implements PropertyChangeListener,
PageActionProvider {
    private final Callback fCreateProfileCallback = new Callback();
    private final DiscoverClusterWizardModel fDiscoverClusterModel;
    private JLabel fOverallStatusLabel;
    private TablePanel fClusterTablePanel;
    private JLabel fWarningLabel;
    private StyleGuidePanel fClusterFoundPanel;
    private StyleGuidePanel fClusterNotFoundPanel;
    private final AbstractStyleGuidePanel fContentPane;
    private static final String MJS_TYPE = "MJS";
    private static final String MJS_COMPUTE_CLOUD_TYPE = "MJSComputeCloud";
    private static final String HPC_SERVER_TYPE = "HPCServer";
    private MJLabel fSelectLabel;
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile");
    private static final ResourceBundle RESOURCE_BUNDLE_NO_TRANSLATE = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile_notranslation");
    private static final int ERROR_MESSAGE_CHARS_PER_LINE = 100;

    ClusterTablePage(DiscoverClusterWizardModel discoverClusterWizardModel) {
        super(RESOURCE_BUNDLE.getString("DiscoverDialog.ClusterTablePage"));
        this.fDiscoverClusterModel = discoverClusterWizardModel;
        this.fDiscoverClusterModel.addPropertyChangeListener(this);
        this.fContentPane = new StyleGuideEmptyPanel();
        this.createClusterFoundPanel();
        this.createClusterNotFoundPanel();
        this.addComponent((JComponent)((Object)this.fContentPane), true);
        this.fWarningLabel.setName("WarningLabel");
        this.fOverallStatusLabel.setName("ClusterTablePage.StatusLabel");
    }

    private void createClusterFoundPanel() {
        this.fOverallStatusLabel = new MJLabel();
        this.fClusterTablePanel = this.createClusterTable();
        this.fSelectLabel = new MJLabel(RESOURCE_BUNDLE.getString("DiscoverDialog.SelectClusterLabel"));
        this.fWarningLabel = new MJLabel();
        JPanel jPanel = new JPanel();
        jPanel.setMinimumSize(new Dimension(0, 20));
        this.fClusterFoundPanel = new StyleGuidePanel();
        this.fClusterFoundPanel.addLine(this.fOverallStatusLabel);
        this.fClusterFoundPanel.addLine(jPanel);
        this.fClusterFoundPanel.addLine((JComponent)this.fSelectLabel);
        this.fClusterFoundPanel.addLine((JComponent)((Object)this.fClusterTablePanel), 8);
        this.fClusterFoundPanel.addLine(this.fWarningLabel);
    }

    private void createClusterNotFoundPanel() {
        MJLabel mJLabel = new MJLabel(RESOURCE_BUNDLE.getString("DiscoverDialog.StatusLabel.DiscoveryDone.NoneFound"));
        mJLabel.setIcon(DialogIcon.WARNING_32x32.getIcon());
        mJLabel.setName("ClusterTablePage.ClusterNotFoundWarningLabel");
        MJLabel mJLabel2 = new MJLabel(RESOURCE_BUNDLE.getString("DiscoverDialog.WarningLabel.NoneFound"));
        this.fClusterNotFoundPanel = new StyleGuidePanel();
        this.fClusterNotFoundPanel.addLine((JComponent)mJLabel);
        this.fClusterNotFoundPanel.addLine((JComponent)mJLabel2);
        this.fClusterNotFoundPanel.addLine(new JPanel(), 8);
    }

    public void setupWizardButtons() {
        super.setupWizardButtons();
        this.fireButtonEvent(3300, "BACK");
        this.fireButtonEvent(3300, "FINISH");
        this.fireButtonEvent(3299, "NEXT");
        this.fireButtonEvent(3299, "CANCEL");
        this.setupNextButton();
        this.fireButtonEvent(3301, "CANCEL");
    }

    private void setupNextButton() {
        if (this.fClusterTablePanel.getSelectedRow() != -1) {
            this.fireButtonEvent(3301, "NEXT");
        } else {
            this.fireButtonEvent(3302, "NEXT");
        }
    }

    public boolean showBannerPane() {
        return false;
    }

    private TablePanel createClusterTable() {
        ClusterTableModel clusterTableModel = new ClusterTableModel(this.fDiscoverClusterModel.getDiscoveredClusters());
        TablePanel tablePanel = new TablePanel(clusterTableModel, "DiscoverClusterTable");
        for (int i = 0; i < clusterTableModel.getColumnCount(); ++i) {
            tablePanel.setCustomRenderer(i, new ClusterCompatibilityCellRenderer(this.fDiscoverClusterModel));
        }
        tablePanel.setCustomRenderer(3, new ClusterCompatibilityCellRenderer(this.fDiscoverClusterModel){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setHorizontalTextPosition(10);
                DiscoverClusterData discoverClusterData = this.getClusterData(jTable, n);
                if (discoverClusterData.isSecure()) {
                    jLabel.setIcon(ParallelIcon.LOCK.getIcon());
                    jLabel.setToolTipText(RESOURCE_BUNDLE.getString("DiscoverDialog.ClusterTable.Lock.Tooltip"));
                } else {
                    jLabel.setIcon(null);
                    jLabel.setToolTipText(null);
                }
                String string = discoverClusterData.getType();
                if (string.equals(ClusterTablePage.MJS_TYPE) || string.equals(ClusterTablePage.MJS_COMPUTE_CLOUD_TYPE)) {
                    string = RESOURCE_BUNDLE_NO_TRANSLATE.getString("DiscoverDialog.ClusterTable.Type.MJS");
                } else if (string.equals(ClusterTablePage.HPC_SERVER_TYPE)) {
                    string = RESOURCE_BUNDLE_NO_TRANSLATE.getString("DiscoverDialog.ClusterTable.Type.HPCServer");
                }
                jLabel.setText(string);
                return jLabel;
            }
        });
        tablePanel.setCustomRenderer(5, new ClusterCompatibilityCellRenderer(this.fDiscoverClusterModel){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                String string = ClusterTablePage.generateCommaSeparatedList(object);
                jLabel.setText(string);
                return jLabel;
            }
        });
        tablePanel.setCustomRenderer(2, new ClusterCompatibilityCellRenderer(this.fDiscoverClusterModel){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setHorizontalAlignment(4);
                return jLabel;
            }
        });
        tablePanel.setCustomRenderer(4, new ClusterCompatibilityCellRenderer(this.fDiscoverClusterModel){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (this.getClusterData(jTable, n).isCompatible()) {
                    jLabel.setToolTipText("");
                } else {
                    jLabel.setToolTipText(RESOURCE_BUNDLE.getString("DiscoverDialog.ClusterTable.IncompatibleCluster.Tooltip"));
                }
                return jLabel;
            }
        });
        tablePanel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    return;
                }
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = ClusterTablePage.this.fClusterTablePanel.getSelectedRow();
                    ClusterTablePage.this.fDiscoverClusterModel.setSelectedCluster(ClusterTablePage.this.fDiscoverClusterModel.getDiscoveredClusters().get(n));
                }
            }
        });
        return tablePanel;
    }

    private static String generateCommaSeparatedList(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        if (object != null && object instanceof String[] && ((String[])object).length != 0) {
            String[] stringArray;
            for (String string : stringArray = (String[])object) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        switch (string = propertyChangeEvent.getPropertyName()) {
            case "ClusterList": {
                this.fSelectLabel.setVisible(true);
                this.fClusterTablePanel.updateTable();
                break;
            }
            case "DiscoveryStarted": {
                this.fOverallStatusLabel.setText(RESOURCE_BUNDLE.getString("DiscoverDialog.StatusLabel.DiscoveryStarted"));
                this.fOverallStatusLabel.setIcon(ParallelIcon.BUSY.getIcon());
                this.fClusterTablePanel.clearSelectedRow();
                this.fClusterTablePanel.updateTable();
                this.fWarningLabel.setText("");
                this.fWarningLabel.setIcon(null);
                this.fContentPane.removeAll();
                this.fContentPane.addLine((JComponent)((Object)this.fClusterFoundPanel), 8);
                this.fContentPane.revalidate();
                this.fContentPane.repaint();
                break;
            }
            case "DiscoveryDone": {
                if (this.fClusterTablePanel.getRowCount() > 0) {
                    void var9_16;
                    Object object;
                    List<DiscoverClusterData> list = this.fDiscoverClusterModel.getDiscoveredClusters();
                    boolean bl = true;
                    boolean bl2 = true;
                    for (DiscoverClusterData object22 : list) {
                        bl = bl && object22.isCompatible();
                        bl2 = bl2 && !object22.isCompatible();
                    }
                    ParallelIcon bl4 = ParallelIcon.PASSED;
                    if (bl) {
                        object = "DiscoverDialog.StatusLabel.DiscoveryDone";
                    } else if (bl2) {
                        object = "DiscoverDialog.StatusLabel.DiscoveryDone.NoCompatibleFound";
                        ParallelIcon parallelIcon = ParallelIcon.FAILED;
                    } else {
                        object = "DiscoverDialog.StatusLabel.DiscoveryDone.SomeIncompatible";
                    }
                    this.fOverallStatusLabel.setText(RESOURCE_BUNDLE.getString((String)object));
                    this.fOverallStatusLabel.setIcon(var9_16.getIcon());
                    this.fSelectLabel.setVisible(true);
                    break;
                }
                this.fContentPane.removeAll();
                this.fContentPane.addLine((JComponent)((Object)this.fClusterNotFoundPanel), 8);
                this.fContentPane.revalidate();
                this.fContentPane.repaint();
                this.fireButtonEvent(3300, "NEXT");
                this.fireButtonEvent(3300, "CANCEL");
                this.fireButtonEvent(3299, "FINISH");
                this.fireButtonEvent(3301, "FINISH");
                break;
            }
            case "DiscoveryFailed": {
                assert (propertyChangeEvent.getNewValue() instanceof Exception) : "The values used by the the DISCOVERY_FAILED event should be exceptions.";
                Exception exception = (Exception)propertyChangeEvent.getNewValue();
                assert (exception != null) : "Received DISCOVERY_FAILED event with a null exception.";
                MJOptionPane mJOptionPane = new MJOptionPane(exception.getLocalizedMessage(), 2, -1){

                    public int getMaxCharactersPerLineCount() {
                        return 100;
                    }
                };
                JDialog jDialog = mJOptionPane.createDialog((Component)((Object)this), RESOURCE_BUNDLE.getString("DiscoverDialog.WarningDialog.Title"));
                jDialog.setVisible(true);
                jDialog.dispose();
                break;
            }
            case "SelectedCluster": {
                int n;
                ImageIcon imageIcon;
                String string2;
                boolean bl;
                this.setupNextButton();
                boolean bl3 = this.fDiscoverClusterModel.getSelectedCluster() != null && this.fDiscoverClusterModel.getSelectedCluster().isCompatible();
                boolean bl2 = bl = bl3 && this.fDiscoverClusterModel.getSelectedCluster().getCorrespondingProfileNames() != null && this.fDiscoverClusterModel.getSelectedCluster().getCorrespondingProfileNames().length != 0;
                if (!bl3) {
                    string2 = RESOURCE_BUNDLE.getString("DiscoverDialog.WarningLabel.IncompatibleCluster");
                    imageIcon = DialogIcon.WARNING.getIcon();
                    n = 3302;
                } else if (bl) {
                    string2 = RESOURCE_BUNDLE.getString("DiscoverDialog.WarningLabel.MultipleProfilesFound");
                    imageIcon = DialogIcon.WARNING.getIcon();
                    n = 3301;
                } else {
                    string2 = "";
                    imageIcon = null;
                    n = 3301;
                }
                if (!string2.isEmpty()) {
                    FontMetrics fontMetrics = this.fWarningLabel.getFontMetrics(this.fWarningLabel.getFont());
                    double d = Math.ceil((double)fontMetrics.stringWidth(string2) / (double)this.fClusterTablePanel.getWidth()) * (double)fontMetrics.getHeight();
                    if (!this.fWarningLabel.isMinimumSizeSet() || d > this.fWarningLabel.getMinimumSize().getHeight()) {
                        this.fWarningLabel.setMinimumSize(new Dimension(this.fClusterTablePanel.getWidth(), (int)d));
                    }
                }
                this.fWarningLabel.setText(string2);
                this.fWarningLabel.setIcon(imageIcon);
                this.fireButtonEvent(n, "NEXT");
                break;
            }
        }
    }

    @Override
    public void doCancel() {
        this.fireButtonEvent(3302, "NEXT");
        this.fireButtonEvent(3302, "CANCEL");
        this.fDiscoverClusterModel.setUserCancelled(true);
    }

    @Override
    public void doNext() {
        this.fireButtonEvent(3302, "NEXT");
        this.fireButtonEvent(3302, "CANCEL");
        this.fDiscoverClusterModel.setUserCancelled(true);
        this.fCreateProfileCallback.postCallback();
    }

    @Override
    public void doFinish() {
    }

    public Callback getCallback() {
        return this.fCreateProfileCallback;
    }

    private static class ClusterCompatibilityCellRenderer
    extends DefaultTableCellRenderer {
        private final DiscoverClusterWizardModel fModel;

        ClusterCompatibilityCellRenderer(DiscoverClusterWizardModel discoverClusterWizardModel) {
            this.fModel = discoverClusterWizardModel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            component.setEnabled(this.getClusterData(jTable, n).isCompatible());
            return component;
        }

        DiscoverClusterData getClusterData(JTable jTable, int n) {
            int n2 = ((SortableTable)jTable).getActualRowAt(n);
            return this.fModel.getDiscoveredClusters().get(n2);
        }
    }
}

