/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.model;

import com.mathworks.toolbox.distcomp.ui.model.DefaultValue;
import com.mathworks.toolbox.distcomp.ui.model.Destroyable;
import com.mathworks.toolbox.distcomp.ui.model.PropertyChangeSupportAdaptor;
import com.mathworks.toolbox.distcomp.ui.model.PropertyInfo;
import com.mathworks.toolbox.distcomp.ui.model.PropertyStorage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;

public final class Property
extends PropertyChangeSupportAdaptor
implements Comparable<Property>,
Destroyable {
    private final PropertyStorage fPropertyStorage;
    private final PropertyInfo fPropertyInfo;
    private PropertyChangeListener fPropertyListener;
    private static final String INF = "inf";
    public static final String EMPTY_MATLAB_STRING = "''";
    public static final String EMPTY_MATLAB_STRING_VALUE = "";
    private static final String CARRIAGE_RETURN = "\n";
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile");

    public Property(PropertyStorage propertyStorage, PropertyInfo propertyInfo) {
        this.fPropertyInfo = propertyInfo;
        this.fPropertyStorage = propertyStorage;
        this.fPropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Property.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        };
        this.fPropertyStorage.addPropertyChangeListener(this.fPropertyListener);
    }

    public Object getValue() {
        return this.fPropertyStorage.get();
    }

    public boolean isDefaultValue() {
        return this.fPropertyStorage.get() instanceof DefaultValue;
    }

    public void unsetValue() {
        this.fPropertyStorage.set(new DefaultValue());
    }

    public void setValue(Object object) {
        assert (this.fPropertyInfo.isConfigurable()) : "This property " + this.fPropertyInfo.getName() + " is defined as read only.";
        Object object2 = this.fPropertyStorage.get();
        this.fPropertyStorage.set(object);
        if (object2.equals(Double.POSITIVE_INFINITY) && object.equals(Double.POSITIVE_INFINITY)) {
            this.fPropertyStorage.firePropertyChange("ValueChanged", null, object);
        }
    }

    public PropertyInfo getPropertyInfo() {
        return this.fPropertyInfo;
    }

    @Override
    public int compareTo(Property property) {
        return this.fPropertyInfo.compareTo(property.getPropertyInfo());
    }

    @Override
    public void destroy() {
        this.fPropertyStorage.removePropertyChangeListener(this.fPropertyListener);
        if (this.fPropertyStorage instanceof Destroyable) {
            ((Destroyable)((Object)this.fPropertyStorage)).destroy();
        }
    }

    public String toString() {
        return "Property for " + this.fPropertyInfo.getName() + " using a " + this.fPropertyStorage.getClass().getSimpleName();
    }

    public String getDisplayString() {
        Object object = this.fPropertyStorage.get();
        if (object instanceof DefaultValue && this.fPropertyInfo.hasDefaultString()) {
            return MessageFormat.format(sRes.getString("Property.DisplayString.Default"), this.fPropertyInfo.getDefaultString());
        }
        if (object instanceof DefaultValue) {
            return sRes.getString("Property.DisplayString.None");
        }
        String string = EMPTY_MATLAB_STRING_VALUE;
        switch (this.fPropertyInfo.getConstraint().getConstraintType()) {
            case DATALOCATION: {
                string = (String)object;
                break;
            }
            case POSITIVEINTSCALAR: {
                assert (object instanceof Double) : "Positive int scalar is stored as double. Type is " + object.getClass();
                string = Property.convertIntegerString((Double)object);
                break;
            }
            case STRING: {
                if (object.equals(EMPTY_MATLAB_STRING_VALUE)) {
                    string = EMPTY_MATLAB_STRING;
                    break;
                }
                string = (String)object;
                break;
            }
            case NONEMPTYSTRING: {
                string = (String)object;
                break;
            }
            case CELLSTR: {
                string = StringUtils.join((Object[])((Object[])object), (String)CARRIAGE_RETURN);
                break;
            }
            case LOGICALSCALAR: {
                string = object.toString();
                break;
            }
            case CALLBACK: {
                if (object.equals(EMPTY_MATLAB_STRING_VALUE)) {
                    string = EMPTY_MATLAB_STRING;
                    break;
                }
                string = (String)object;
                break;
            }
            case WORKERLIMITS: {
                if (object instanceof Double) {
                    string = Property.convertIntegerString((Double)object);
                    break;
                }
                if (object instanceof Double[]) {
                    Double[] doubleArray = (Double[])object;
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Double d : doubleArray) {
                        stringBuilder.append(Property.convertIntegerString(d));
                        stringBuilder.append(" ");
                    }
                    stringBuilder.substring(0, stringBuilder.length() - 1);
                    string = "[" + stringBuilder.substring(0, stringBuilder.length() - 1) + "]";
                    break;
                }
                assert (false) : "Unsupported type " + object.getClass().getSimpleName();
                string = EMPTY_MATLAB_STRING_VALUE;
                break;
            }
            case ENUM: {
                string = (String)object;
            }
        }
        return string;
    }

    private static String convertIntegerString(Double d) {
        String string;
        if (d.equals(Double.POSITIVE_INFINITY)) {
            string = INF;
        } else {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setParseIntegerOnly(true);
            numberFormat.setGroupingUsed(false);
            string = numberFormat.format(d);
        }
        return string;
    }
}

